/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.policy;

import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.ListUtils;
import org.eclipse.edc.policy.model.AndConstraint;
import org.eclipse.edc.policy.model.AtomicConstraint;
import org.eclipse.edc.policy.model.Operator;
import org.eclipse.edc.policy.model.OrConstraint;
import org.eclipse.tractusx.irs.edc.client.policy.AtomicConstraintValidator;
import org.eclipse.tractusx.irs.edc.client.policy.Constraint;
import org.eclipse.tractusx.irs.edc.client.policy.Constraints;
import org.eclipse.tractusx.irs.edc.client.policy.Permission;
import org.eclipse.tractusx.irs.edc.client.policy.Policy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConstraintCheckerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConstraintCheckerService.class);

    public boolean hasAllConstraint(Policy acceptedPolicy, List<org.eclipse.edc.policy.model.Constraint> constraints) {
        List<Constraints> acceptedConstraintsList = acceptedPolicy.getPermissions().stream().map(Permission::getConstraint).toList();
        return constraints.stream().allMatch(constraint -> this.isValidOnList((org.eclipse.edc.policy.model.Constraint)constraint, acceptedConstraintsList));
    }

    private boolean isValidOnList(org.eclipse.edc.policy.model.Constraint constraint, List<Constraints> acceptedConstraintsList) {
        return acceptedConstraintsList.stream().allMatch(acceptedConstraints -> this.isSameAs(constraint, (Constraints)acceptedConstraints));
    }

    private boolean isSameAs(org.eclipse.edc.policy.model.Constraint constraint, Constraints acceptedConstraints) {
        if (constraint instanceof AtomicConstraint) {
            AtomicConstraint atomicConstraint = (AtomicConstraint)constraint;
            return ListUtils.emptyIfNull(acceptedConstraints.getOr()).stream().anyMatch(p -> this.isSameAs(atomicConstraint, (Constraint)p)) || ListUtils.emptyIfNull(acceptedConstraints.getAnd()).stream().anyMatch(p -> this.isSameAs(atomicConstraint, (Constraint)p));
        }
        if (constraint instanceof AndConstraint) {
            AndConstraint andConstraint = (AndConstraint)constraint;
            if (acceptedConstraints.getAnd() != null && acceptedConstraints.getAnd().size() != andConstraint.getConstraints().size()) {
                return false;
            }
            return andConstraint.getConstraints().stream().allMatch(constr -> this.isInList((org.eclipse.edc.policy.model.Constraint)constr, ListUtils.emptyIfNull(acceptedConstraints.getAnd())));
        }
        if (constraint instanceof OrConstraint) {
            OrConstraint orConstraint = (OrConstraint)constraint;
            return orConstraint.getConstraints().stream().anyMatch(constr -> this.isInList((org.eclipse.edc.policy.model.Constraint)constr, ListUtils.emptyIfNull(acceptedConstraints.getOr())));
        }
        return false;
    }

    private boolean isInList(org.eclipse.edc.policy.model.Constraint constraint, List<Constraint> acceptedConstraints) {
        if (constraint instanceof AtomicConstraint) {
            AtomicConstraint atomicConstraint = (AtomicConstraint)constraint;
            return acceptedConstraints.stream().anyMatch(ac -> this.isSameAs(atomicConstraint, (Constraint)ac));
        }
        return false;
    }

    private boolean isSameAs(AtomicConstraint atomicConstraint, Constraint acceptedConstraint) {
        return AtomicConstraintValidator.builder().atomicConstraint(atomicConstraint).leftExpressionValue(acceptedConstraint.getLeftOperand()).rightExpressionValue(acceptedConstraint.getRightOperand()).expectedOperator(Operator.valueOf((String)acceptedConstraint.getOperator().getOperatorType().name())).build().isValid();
    }
}

