/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.policy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import lombok.Generated;

@JsonSerialize(using=ToStringSerializer.class)
public enum OperatorType {
    EQ("eq", "Equals to"),
    NEQ("neq", "Not equal to"),
    LT("lt", "Less than"),
    GT("gt", "Greater than"),
    IN("in", "In"),
    LTEQ("lteq", "Less than or equal to"),
    GTEQ("gteq", "Greater than or equal to"),
    ISA("isA", "Is a"),
    HASPART("hasPart", "Has part"),
    ISPARTOF("isPartOf", "Is part of"),
    ISONEOF("isOneOf", "Is one of"),
    ISALLOF("isAllOf", "Is all of"),
    ISNONEOF("isNoneOf", "Is none of");

    private final String code;
    private final String label;
    private static final int ODRL_PREFIX_INDEX = 5;

    private OperatorType(String code, String label) {
        this.code = code;
        this.label = label;
    }

    @JsonCreator
    public static OperatorType fromValue(String value) {
        String operator = value.startsWith("odrl:") ? value.substring(5) : value;
        return Stream.of(OperatorType.values()).filter(operatorType -> operatorType.code.equals(operator)).findFirst().orElseThrow(() -> new NoSuchElementException("Unsupported OperatorType: " + operator));
    }

    public String toString() {
        return this.code;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }
}

