/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.policy;

import java.time.OffsetDateTime;
import java.util.List;
import lombok.Generated;
import org.eclipse.edc.policy.model.Permission;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.tractusx.irs.edc.client.policy.AcceptedPoliciesProvider;
import org.eclipse.tractusx.irs.edc.client.policy.AcceptedPolicy;
import org.eclipse.tractusx.irs.edc.client.policy.ConstraintCheckerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="irsEdcClientPolicyCheckerService")
public class PolicyCheckerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PolicyCheckerService.class);
    private final AcceptedPoliciesProvider policyStore;
    private final ConstraintCheckerService constraintCheckerService;

    public boolean isValid(Policy policy, String bpn) {
        List<AcceptedPolicy> validStoredPolicies = this.getValidStoredPolicies(bpn);
        return policy.getPermissions().stream().allMatch(permission -> this.hasValidConstraints((Permission)permission, validStoredPolicies));
    }

    private boolean hasValidConstraints(Permission permission, List<AcceptedPolicy> validStoredPolicies) {
        return validStoredPolicies.stream().anyMatch(acceptedPolicy -> this.constraintCheckerService.hasAllConstraint(acceptedPolicy.policy(), permission.getConstraints()));
    }

    public boolean isExpired(Policy policy, String bpn) {
        return policy.getPermissions().stream().allMatch(permission -> this.hasExpiredConstraint((Permission)permission, this.getValidStoredPolicies(bpn)));
    }

    private boolean hasExpiredConstraint(Permission permission, List<AcceptedPolicy> validStoredPolicies) {
        return validStoredPolicies.stream().filter(acceptedPolicy -> this.constraintCheckerService.hasAllConstraint(acceptedPolicy.policy(), permission.getConstraints())).allMatch(acceptedPolicy -> acceptedPolicy.validUntil().isBefore(OffsetDateTime.now()));
    }

    public List<AcceptedPolicy> getValidStoredPolicies(String bpn) {
        return this.policyStore.getAcceptedPolicies(bpn).stream().toList();
    }

    @Generated
    public PolicyCheckerService(AcceptedPoliciesProvider policyStore, ConstraintCheckerService constraintCheckerService) {
        this.policyStore = policyStore;
        this.constraintCheckerService = constraintCheckerService;
    }
}

