/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.policy.service;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.eclipse.tractusx.irs.edc.client.EdcConfiguration;
import org.eclipse.tractusx.irs.edc.client.asset.model.Context;
import org.eclipse.tractusx.irs.edc.client.contract.model.EdcOperator;
import org.eclipse.tractusx.irs.edc.client.policy.PolicyType;
import org.eclipse.tractusx.irs.edc.client.policy.model.EdcCreatePolicyDefinitionRequest;
import org.eclipse.tractusx.irs.edc.client.policy.model.EdcPolicy;
import org.eclipse.tractusx.irs.edc.client.policy.model.EdcPolicyPermission;
import org.eclipse.tractusx.irs.edc.client.policy.model.EdcPolicyPermissionConstraint;
import org.eclipse.tractusx.irs.edc.client.policy.model.EdcPolicyPermissionConstraintExpression;
import org.eclipse.tractusx.irs.edc.client.policy.model.exception.CreateEdcPolicyDefinitionException;
import org.eclipse.tractusx.irs.edc.client.policy.model.exception.DeleteEdcPolicyDefinitionException;
import org.eclipse.tractusx.irs.edc.client.policy.model.exception.EdcPolicyDefinitionAlreadyExists;
import org.eclipse.tractusx.irs.edc.client.policy.model.exception.GetEdcPolicyDefinitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class EdcPolicyDefinitionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdcPolicyDefinitionService.class);
    private static final String POLICY_TYPE = "Policy";
    private static final String POLICY_DEFINITION_TYPE = "PolicyDefinitionRequestDto";
    private static final String ATOMIC_CONSTRAINT = "AtomicConstraint";
    private static final String CONSTRAINT = "Constraint";
    private static final String OPERATOR_PREFIX = "odrl:";
    private static final String USE_ACTION = PolicyType.USE.getValue();
    private final EdcConfiguration config;
    private final RestTemplate restTemplate;

    @Deprecated(since="5.1.1")
    public String createAccessPolicy(String policyName) throws CreateEdcPolicyDefinitionException {
        String accessPolicyId = UUID.randomUUID().toString();
        return this.createAccessPolicy(policyName, accessPolicyId);
    }

    @Deprecated(since="5.1.1")
    public String createAccessPolicy(String policyName, String policyId) throws CreateEdcPolicyDefinitionException {
        EdcCreatePolicyDefinitionRequest request = this.createPolicyDefinition(policyName, policyId);
        return this.createAccessPolicy(request);
    }

    public String createAccessPolicy(EdcCreatePolicyDefinitionRequest policyRequest) throws CreateEdcPolicyDefinitionException {
        ResponseEntity createPolicyDefinitionResponse;
        try {
            createPolicyDefinitionResponse = this.restTemplate.postForEntity(this.config.getControlplane().getEndpoint().getPolicyDefinition(), (Object)policyRequest, String.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            log.error("Failed to create EDC policy definition. Reason: ", (Throwable)e);
            if (e.getStatusCode().value() == HttpStatus.CONFLICT.value()) {
                throw new EdcPolicyDefinitionAlreadyExists("Policy definition already exists in the EDC", e);
            }
            throw new CreateEdcPolicyDefinitionException(e);
        }
        HttpStatusCode responseCode = createPolicyDefinitionResponse.getStatusCode();
        if (responseCode.value() == HttpStatus.OK.value()) {
            return policyRequest.getPolicyDefinitionId();
        }
        throw new CreateEdcPolicyDefinitionException("Failed to create EDC policy definition for asset");
    }

    public boolean policyDefinitionExists(String policyName) throws GetEdcPolicyDefinitionException {
        try {
            ResponseEntity getPolicyDefinitionRequest = this.restTemplate.getForEntity(this.config.getControlplane().getEndpoint().getPolicyDefinition() + "/" + policyName, String.class, new Object[0]);
            HttpStatusCode responseCode = getPolicyDefinitionRequest.getStatusCode();
            if (responseCode.value() == HttpStatus.OK.value()) {
                return true;
            }
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode().value() == HttpStatus.NOT_FOUND.value()) {
                log.info(String.format("Policy with id %s not found within the edc", policyName));
                return false;
            }
            throw new GetEdcPolicyDefinitionException(e);
        }
        return false;
    }

    public EdcCreatePolicyDefinitionRequest createPolicyDefinition(String policyName, String accessPolicyId) {
        EdcPolicyPermissionConstraintExpression constraint = EdcPolicyPermissionConstraintExpression.builder().leftOperand("PURPOSE").rightOperand(policyName).operator(new EdcOperator("odrl:eq")).type(CONSTRAINT).build();
        EdcPolicyPermissionConstraint edcPolicyPermissionConstraint = EdcPolicyPermissionConstraint.builder().andExpressions(List.of(constraint)).orExpressions(Collections.emptyList()).type(ATOMIC_CONSTRAINT).build();
        EdcPolicyPermission odrlPermissions = EdcPolicyPermission.builder().action(USE_ACTION).edcPolicyPermissionConstraints(edcPolicyPermissionConstraint).build();
        EdcPolicy edcPolicy = EdcPolicy.builder().odrlPermissions(List.of(odrlPermissions)).type(POLICY_TYPE).build();
        Context context = Context.builder().odrl("http://www.w3.org/ns/odrl/2/").edc("https://w3id.org/edc/v0.0.1/ns/").vocab("https://w3id.org/edc/v0.0.1/ns/").cxPolicy("https://w3id.org/catenax/policy/").build();
        return EdcCreatePolicyDefinitionRequest.builder().policyDefinitionId(accessPolicyId).policy(edcPolicy).context(context).type(POLICY_DEFINITION_TYPE).build();
    }

    public void deleteAccessPolicy(String accessPolicyId) throws DeleteEdcPolicyDefinitionException {
        String deleteUri = UriComponentsBuilder.fromPath((String)this.config.getControlplane().getEndpoint().getPolicyDefinition()).pathSegment(new String[]{"{accessPolicyId}"}).buildAndExpand(new Object[]{accessPolicyId}).toUriString();
        try {
            this.restTemplate.delete(deleteUri, new Object[0]);
        }
        catch (RestClientException e) {
            log.error("Failed to delete EDC notification asset policy {}. Reason: ", (Object)accessPolicyId, (Object)e);
            throw new DeleteEdcPolicyDefinitionException(e);
        }
    }

    @Generated
    public EdcPolicyDefinitionService(EdcConfiguration config, RestTemplate restTemplate) {
        this.config = config;
        this.restTemplate = restTemplate;
    }
}

