/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.relationships;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.eclipse.tractusx.irs.component.GlobalAssetIdentification;
import org.eclipse.tractusx.irs.component.LinkedItem;
import org.eclipse.tractusx.irs.component.MeasurementUnit;
import org.eclipse.tractusx.irs.component.Relationship;
import org.eclipse.tractusx.irs.component.enums.AspectType;
import org.eclipse.tractusx.irs.component.enums.BomLifecycle;

@JsonDeserialize(builder=ParentItemBuilder.class)
class ParentItem {
    private String catenaXId;
    private Quantity quantity;
    private String businessPartner;
    private ZonedDateTime createdOn;
    private ZonedDateTime lastModifiedOn;

    public Relationship toRelationship(String catenaXId, BomLifecycle bomLifecycle, AspectType aspectType) {
        LinkedItem.LinkedItemBuilder linkedItem = LinkedItem.builder().childCatenaXId(GlobalAssetIdentification.of((String)catenaXId)).lifecycleContext(bomLifecycle).hasAlternatives(Boolean.FALSE.booleanValue()).assembledOn(this.createdOn).lastModifiedOn(this.lastModifiedOn);
        if (this.thereIsQuantity()) {
            linkedItem.quantity(org.eclipse.tractusx.irs.component.Quantity.builder().quantityNumber(this.quantity.getQuantityNumber()).measurementUnit(MeasurementUnit.builder().lexicalValue(this.quantity.getMeasurementUnit()).build()).build());
        }
        return Relationship.builder().catenaXId(GlobalAssetIdentification.of((String)this.catenaXId)).linkedItem(linkedItem.build()).bpn(this.businessPartner).aspectType(aspectType.toString()).build();
    }

    private boolean thereIsQuantity() {
        return this.quantity != null;
    }

    @Generated
    public static ParentItemBuilder builder() {
        return new ParentItemBuilder();
    }

    @Generated
    public String getCatenaXId() {
        return this.catenaXId;
    }

    @Generated
    public Quantity getQuantity() {
        return this.quantity;
    }

    @Generated
    public String getBusinessPartner() {
        return this.businessPartner;
    }

    @Generated
    public ZonedDateTime getCreatedOn() {
        return this.createdOn;
    }

    @Generated
    public ZonedDateTime getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    @Generated
    public void setCatenaXId(String catenaXId) {
        this.catenaXId = catenaXId;
    }

    @Generated
    public void setQuantity(Quantity quantity) {
        this.quantity = quantity;
    }

    @Generated
    public void setBusinessPartner(String businessPartner) {
        this.businessPartner = businessPartner;
    }

    @Generated
    public void setCreatedOn(ZonedDateTime createdOn) {
        this.createdOn = createdOn;
    }

    @Generated
    public void setLastModifiedOn(ZonedDateTime lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParentItem)) {
            return false;
        }
        ParentItem other = (ParentItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$catenaXId = this.getCatenaXId();
        String other$catenaXId = other.getCatenaXId();
        if (this$catenaXId == null ? other$catenaXId != null : !this$catenaXId.equals(other$catenaXId)) {
            return false;
        }
        Quantity this$quantity = this.getQuantity();
        Quantity other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        String this$businessPartner = this.getBusinessPartner();
        String other$businessPartner = other.getBusinessPartner();
        if (this$businessPartner == null ? other$businessPartner != null : !this$businessPartner.equals(other$businessPartner)) {
            return false;
        }
        ZonedDateTime this$createdOn = this.getCreatedOn();
        ZonedDateTime other$createdOn = other.getCreatedOn();
        if (this$createdOn == null ? other$createdOn != null : !((Object)this$createdOn).equals(other$createdOn)) {
            return false;
        }
        ZonedDateTime this$lastModifiedOn = this.getLastModifiedOn();
        ZonedDateTime other$lastModifiedOn = other.getLastModifiedOn();
        return !(this$lastModifiedOn == null ? other$lastModifiedOn != null : !((Object)this$lastModifiedOn).equals(other$lastModifiedOn));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ParentItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $catenaXId = this.getCatenaXId();
        result = result * 59 + ($catenaXId == null ? 43 : $catenaXId.hashCode());
        Quantity $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        String $businessPartner = this.getBusinessPartner();
        result = result * 59 + ($businessPartner == null ? 43 : $businessPartner.hashCode());
        ZonedDateTime $createdOn = this.getCreatedOn();
        result = result * 59 + ($createdOn == null ? 43 : ((Object)$createdOn).hashCode());
        ZonedDateTime $lastModifiedOn = this.getLastModifiedOn();
        result = result * 59 + ($lastModifiedOn == null ? 43 : ((Object)$lastModifiedOn).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ParentItem(catenaXId=" + this.getCatenaXId() + ", quantity=" + String.valueOf(this.getQuantity()) + ", businessPartner=" + this.getBusinessPartner() + ", createdOn=" + String.valueOf(this.getCreatedOn()) + ", lastModifiedOn=" + String.valueOf(this.getLastModifiedOn()) + ")";
    }

    @Generated
    public ParentItem(String catenaXId, Quantity quantity, String businessPartner, ZonedDateTime createdOn, ZonedDateTime lastModifiedOn) {
        this.catenaXId = catenaXId;
        this.quantity = quantity;
        this.businessPartner = businessPartner;
        this.createdOn = createdOn;
        this.lastModifiedOn = lastModifiedOn;
    }

    @Generated
    public ParentItem() {
    }

    @JsonDeserialize(builder=QuantityBuilder.class)
    static class Quantity {
        @JsonAlias(value={"quantityNumber", "value"})
        private Double quantityNumber;
        @JsonAlias(value={"measurementUnit", "unit"})
        private String measurementUnit;

        @Generated
        Quantity(Double quantityNumber, String measurementUnit) {
            this.quantityNumber = quantityNumber;
            this.measurementUnit = measurementUnit;
        }

        @Generated
        public static QuantityBuilder builder() {
            return new QuantityBuilder();
        }

        @Generated
        public Double getQuantityNumber() {
            return this.quantityNumber;
        }

        @Generated
        public String getMeasurementUnit() {
            return this.measurementUnit;
        }

        @JsonAlias(value={"quantityNumber", "value"})
        @Generated
        public void setQuantityNumber(Double quantityNumber) {
            this.quantityNumber = quantityNumber;
        }

        @JsonAlias(value={"measurementUnit", "unit"})
        @Generated
        public void setMeasurementUnit(String measurementUnit) {
            this.measurementUnit = measurementUnit;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Quantity)) {
                return false;
            }
            Quantity other = (Quantity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$quantityNumber = this.getQuantityNumber();
            Double other$quantityNumber = other.getQuantityNumber();
            if (this$quantityNumber == null ? other$quantityNumber != null : !((Object)this$quantityNumber).equals(other$quantityNumber)) {
                return false;
            }
            String this$measurementUnit = this.getMeasurementUnit();
            String other$measurementUnit = other.getMeasurementUnit();
            return !(this$measurementUnit == null ? other$measurementUnit != null : !this$measurementUnit.equals(other$measurementUnit));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Quantity;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $quantityNumber = this.getQuantityNumber();
            result = result * 59 + ($quantityNumber == null ? 43 : ((Object)$quantityNumber).hashCode());
            String $measurementUnit = this.getMeasurementUnit();
            result = result * 59 + ($measurementUnit == null ? 43 : $measurementUnit.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ParentItem.Quantity(quantityNumber=" + this.getQuantityNumber() + ", measurementUnit=" + this.getMeasurementUnit() + ")";
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class QuantityBuilder {
            @Generated
            private Double quantityNumber;
            @Generated
            private String measurementUnit;

            @Generated
            QuantityBuilder() {
            }

            @JsonAlias(value={"quantityNumber", "value"})
            @Generated
            public QuantityBuilder quantityNumber(Double quantityNumber) {
                this.quantityNumber = quantityNumber;
                return this;
            }

            @JsonAlias(value={"measurementUnit", "unit"})
            @Generated
            public QuantityBuilder measurementUnit(String measurementUnit) {
                this.measurementUnit = measurementUnit;
                return this;
            }

            @Generated
            public Quantity build() {
                return new Quantity(this.quantityNumber, this.measurementUnit);
            }

            @Generated
            public String toString() {
                return "ParentItem.Quantity.QuantityBuilder(quantityNumber=" + this.quantityNumber + ", measurementUnit=" + this.measurementUnit + ")";
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class ParentItemBuilder {
        @Generated
        private String catenaXId;
        @Generated
        private Quantity quantity;
        @Generated
        private String businessPartner;
        @Generated
        private ZonedDateTime createdOn;
        @Generated
        private ZonedDateTime lastModifiedOn;

        @Generated
        ParentItemBuilder() {
        }

        @Generated
        public ParentItemBuilder catenaXId(String catenaXId) {
            this.catenaXId = catenaXId;
            return this;
        }

        @Generated
        public ParentItemBuilder quantity(Quantity quantity) {
            this.quantity = quantity;
            return this;
        }

        @Generated
        public ParentItemBuilder businessPartner(String businessPartner) {
            this.businessPartner = businessPartner;
            return this;
        }

        @Generated
        public ParentItemBuilder createdOn(ZonedDateTime createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        @Generated
        public ParentItemBuilder lastModifiedOn(ZonedDateTime lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        @Generated
        public ParentItem build() {
            return new ParentItem(this.catenaXId, this.quantity, this.businessPartner, this.createdOn, this.lastModifiedOn);
        }

        @Generated
        public String toString() {
            return "ParentItem.ParentItemBuilder(catenaXId=" + this.catenaXId + ", quantity=" + String.valueOf(this.quantity) + ", businessPartner=" + this.businessPartner + ", createdOn=" + String.valueOf(this.createdOn) + ", lastModifiedOn=" + String.valueOf(this.lastModifiedOn) + ")";
        }
    }
}

