/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.relationships;

import java.util.NoSuchElementException;
import java.util.stream.Stream;
import lombok.Generated;
import org.eclipse.tractusx.irs.component.enums.BomLifecycle;
import org.eclipse.tractusx.irs.component.enums.Direction;
import org.eclipse.tractusx.irs.edc.client.RelationshipSubmodel;
import org.eclipse.tractusx.irs.edc.client.relationships.SingleLevelBomAsBuilt;
import org.eclipse.tractusx.irs.edc.client.relationships.SingleLevelBomAsPlanned;
import org.eclipse.tractusx.irs.edc.client.relationships.SingleLevelBomAsSpecified;
import org.eclipse.tractusx.irs.edc.client.relationships.SingleLevelUsageAsBuilt;
import org.eclipse.tractusx.irs.edc.client.relationships.SingleLevelUsageAsPlanned;

public enum RelationshipAspect {
    SINGLE_LEVEL_BOM_AS_PLANNED("SingleLevelBomAsPlanned", SingleLevelBomAsPlanned.class, BomLifecycle.AS_PLANNED, Direction.DOWNWARD),
    SINGLE_LEVEL_BOM_AS_BUILT("SingleLevelBomAsBuilt", SingleLevelBomAsBuilt.class, BomLifecycle.AS_BUILT, Direction.DOWNWARD),
    SINGLE_LEVEL_BOM_AS_SPECIFIED("SingleLevelBomAsSpecified", SingleLevelBomAsSpecified.class, BomLifecycle.AS_SPECIFIED, Direction.DOWNWARD),
    SINGLE_LEVEL_USAGE_AS_BUILT("SingleLevelUsageAsBuilt", SingleLevelUsageAsBuilt.class, BomLifecycle.AS_BUILT, Direction.UPWARD),
    SINGLE_LEVEL_USAGE_AS_PLANNED("SingleLevelUsageAsPlanned", SingleLevelUsageAsPlanned.class, BomLifecycle.AS_PLANNED, Direction.UPWARD);

    private final String name;
    private final Class<? extends RelationshipSubmodel> submodelClazz;
    private final BomLifecycle bomLifecycle;
    private final Direction direction;

    public static RelationshipAspect from(BomLifecycle bomLifecycle, Direction direction) {
        return Stream.of(RelationshipAspect.values()).filter(aspect -> aspect.bomLifecycle.equals((Object)bomLifecycle) && aspect.direction.equals((Object)direction)).findFirst().orElseThrow(NoSuchElementException::new);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Class<? extends RelationshipSubmodel> getSubmodelClazz() {
        return this.submodelClazz;
    }

    @Generated
    public BomLifecycle getBomLifecycle() {
        return this.bomLifecycle;
    }

    @Generated
    public Direction getDirection() {
        return this.direction;
    }

    @Generated
    private RelationshipAspect(String name, Class<? extends RelationshipSubmodel> submodelClazz, BomLifecycle bomLifecycle, Direction direction) {
        this.name = name;
        this.submodelClazz = submodelClazz;
        this.bomLifecycle = bomLifecycle;
        this.direction = direction;
    }
}

