/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.relationships;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.eclipse.tractusx.irs.component.GlobalAssetIdentification;
import org.eclipse.tractusx.irs.component.LinkedItem;
import org.eclipse.tractusx.irs.component.MeasurementUnit;
import org.eclipse.tractusx.irs.component.Quantity;
import org.eclipse.tractusx.irs.component.Relationship;
import org.eclipse.tractusx.irs.component.enums.AspectType;
import org.eclipse.tractusx.irs.component.enums.BomLifecycle;
import org.eclipse.tractusx.irs.edc.client.RelationshipSubmodel;

@JsonDeserialize(builder=SingleLevelBomAsBuiltBuilder.class)
class SingleLevelBomAsBuilt
implements RelationshipSubmodel {
    private String catenaXId;
    private Set<ChildData> childItems;

    @Override
    public List<Relationship> asRelationships() {
        return Optional.ofNullable(this.childItems).stream().flatMap(Collection::stream).map(childData -> childData.toRelationship(this.catenaXId)).toList();
    }

    @Generated
    public static SingleLevelBomAsBuiltBuilder builder() {
        return new SingleLevelBomAsBuiltBuilder();
    }

    @Generated
    public String getCatenaXId() {
        return this.catenaXId;
    }

    @Generated
    public Set<ChildData> getChildItems() {
        return this.childItems;
    }

    @Generated
    public void setCatenaXId(String catenaXId) {
        this.catenaXId = catenaXId;
    }

    @Generated
    public void setChildItems(Set<ChildData> childItems) {
        this.childItems = childItems;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleLevelBomAsBuilt)) {
            return false;
        }
        SingleLevelBomAsBuilt other = (SingleLevelBomAsBuilt)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$catenaXId = this.getCatenaXId();
        String other$catenaXId = other.getCatenaXId();
        if (this$catenaXId == null ? other$catenaXId != null : !this$catenaXId.equals(other$catenaXId)) {
            return false;
        }
        Set<ChildData> this$childItems = this.getChildItems();
        Set<ChildData> other$childItems = other.getChildItems();
        return !(this$childItems == null ? other$childItems != null : !((Object)this$childItems).equals(other$childItems));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SingleLevelBomAsBuilt;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $catenaXId = this.getCatenaXId();
        result = result * 59 + ($catenaXId == null ? 43 : $catenaXId.hashCode());
        Set<ChildData> $childItems = this.getChildItems();
        result = result * 59 + ($childItems == null ? 43 : ((Object)$childItems).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SingleLevelBomAsBuilt(catenaXId=" + this.getCatenaXId() + ", childItems=" + String.valueOf(this.getChildItems()) + ")";
    }

    @Generated
    public SingleLevelBomAsBuilt(String catenaXId, Set<ChildData> childItems) {
        this.catenaXId = catenaXId;
        this.childItems = childItems;
    }

    @Generated
    public SingleLevelBomAsBuilt() {
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class SingleLevelBomAsBuiltBuilder {
        @Generated
        private String catenaXId;
        @Generated
        private Set<ChildData> childItems;

        @Generated
        SingleLevelBomAsBuiltBuilder() {
        }

        @Generated
        public SingleLevelBomAsBuiltBuilder catenaXId(String catenaXId) {
            this.catenaXId = catenaXId;
            return this;
        }

        @Generated
        public SingleLevelBomAsBuiltBuilder childItems(Set<ChildData> childItems) {
            this.childItems = childItems;
            return this;
        }

        @Generated
        public SingleLevelBomAsBuilt build() {
            return new SingleLevelBomAsBuilt(this.catenaXId, this.childItems);
        }

        @Generated
        public String toString() {
            return "SingleLevelBomAsBuilt.SingleLevelBomAsBuiltBuilder(catenaXId=" + this.catenaXId + ", childItems=" + String.valueOf(this.childItems) + ")";
        }
    }

    @JsonDeserialize(builder=ChildDataBuilder.class)
    static class ChildData {
        private ZonedDateTime createdOn;
        private Quantity quantity;
        private ZonedDateTime lastModifiedOn;
        private String catenaXId;
        private String businessPartner;
        private boolean hasAlternatives;

        public Relationship toRelationship(String catenaXId) {
            LinkedItem.LinkedItemBuilder linkedItem = LinkedItem.builder().childCatenaXId(GlobalAssetIdentification.of((String)this.catenaXId)).lifecycleContext(BomLifecycle.AS_BUILT).hasAlternatives(this.hasAlternatives).assembledOn(this.createdOn).lastModifiedOn(this.lastModifiedOn);
            if (this.thereIsQuantity()) {
                MeasurementUnit measurementUnit = MeasurementUnit.builder().build();
                Object object = this.quantity.getMeasurementUnit();
                if (object instanceof String) {
                    String str = (String)object;
                    measurementUnit = MeasurementUnit.builder().lexicalValue(str).build();
                } else {
                    object = this.quantity.getMeasurementUnit();
                    if (object instanceof Map) {
                        Map map = (Map)object;
                        measurementUnit = MeasurementUnit.builder().lexicalValue(String.valueOf(map.get("lexicalValue"))).datatypeURI(String.valueOf(map.get("datatypeURI"))).build();
                    }
                }
                linkedItem.quantity(org.eclipse.tractusx.irs.component.Quantity.builder().quantityNumber(this.quantity.getQuantityNumber()).measurementUnit(measurementUnit).build());
            }
            return Relationship.builder().catenaXId(GlobalAssetIdentification.of((String)catenaXId)).linkedItem(linkedItem.build()).bpn(this.businessPartner).aspectType(AspectType.SINGLE_LEVEL_BOM_AS_BUILT.toString()).build();
        }

        private boolean thereIsQuantity() {
            return this.quantity != null;
        }

        @Generated
        public static ChildDataBuilder builder() {
            return new ChildDataBuilder();
        }

        @Generated
        public ZonedDateTime getCreatedOn() {
            return this.createdOn;
        }

        @Generated
        public Quantity getQuantity() {
            return this.quantity;
        }

        @Generated
        public ZonedDateTime getLastModifiedOn() {
            return this.lastModifiedOn;
        }

        @Generated
        public String getCatenaXId() {
            return this.catenaXId;
        }

        @Generated
        public String getBusinessPartner() {
            return this.businessPartner;
        }

        @Generated
        public boolean isHasAlternatives() {
            return this.hasAlternatives;
        }

        @Generated
        public void setCreatedOn(ZonedDateTime createdOn) {
            this.createdOn = createdOn;
        }

        @Generated
        public void setQuantity(Quantity quantity) {
            this.quantity = quantity;
        }

        @Generated
        public void setLastModifiedOn(ZonedDateTime lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        @Generated
        public void setCatenaXId(String catenaXId) {
            this.catenaXId = catenaXId;
        }

        @Generated
        public void setBusinessPartner(String businessPartner) {
            this.businessPartner = businessPartner;
        }

        @Generated
        public void setHasAlternatives(boolean hasAlternatives) {
            this.hasAlternatives = hasAlternatives;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChildData)) {
                return false;
            }
            ChildData other = (ChildData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isHasAlternatives() != other.isHasAlternatives()) {
                return false;
            }
            ZonedDateTime this$createdOn = this.getCreatedOn();
            ZonedDateTime other$createdOn = other.getCreatedOn();
            if (this$createdOn == null ? other$createdOn != null : !((Object)this$createdOn).equals(other$createdOn)) {
                return false;
            }
            Quantity this$quantity = this.getQuantity();
            Quantity other$quantity = other.getQuantity();
            if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
                return false;
            }
            ZonedDateTime this$lastModifiedOn = this.getLastModifiedOn();
            ZonedDateTime other$lastModifiedOn = other.getLastModifiedOn();
            if (this$lastModifiedOn == null ? other$lastModifiedOn != null : !((Object)this$lastModifiedOn).equals(other$lastModifiedOn)) {
                return false;
            }
            String this$catenaXId = this.getCatenaXId();
            String other$catenaXId = other.getCatenaXId();
            if (this$catenaXId == null ? other$catenaXId != null : !this$catenaXId.equals(other$catenaXId)) {
                return false;
            }
            String this$businessPartner = this.getBusinessPartner();
            String other$businessPartner = other.getBusinessPartner();
            return !(this$businessPartner == null ? other$businessPartner != null : !this$businessPartner.equals(other$businessPartner));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ChildData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isHasAlternatives() ? 79 : 97);
            ZonedDateTime $createdOn = this.getCreatedOn();
            result = result * 59 + ($createdOn == null ? 43 : ((Object)$createdOn).hashCode());
            Quantity $quantity = this.getQuantity();
            result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
            ZonedDateTime $lastModifiedOn = this.getLastModifiedOn();
            result = result * 59 + ($lastModifiedOn == null ? 43 : ((Object)$lastModifiedOn).hashCode());
            String $catenaXId = this.getCatenaXId();
            result = result * 59 + ($catenaXId == null ? 43 : $catenaXId.hashCode());
            String $businessPartner = this.getBusinessPartner();
            result = result * 59 + ($businessPartner == null ? 43 : $businessPartner.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SingleLevelBomAsBuilt.ChildData(createdOn=" + String.valueOf(this.getCreatedOn()) + ", quantity=" + String.valueOf(this.getQuantity()) + ", lastModifiedOn=" + String.valueOf(this.getLastModifiedOn()) + ", catenaXId=" + this.getCatenaXId() + ", businessPartner=" + this.getBusinessPartner() + ", hasAlternatives=" + this.isHasAlternatives() + ")";
        }

        @Generated
        public ChildData(ZonedDateTime createdOn, Quantity quantity, ZonedDateTime lastModifiedOn, String catenaXId, String businessPartner, boolean hasAlternatives) {
            this.createdOn = createdOn;
            this.quantity = quantity;
            this.lastModifiedOn = lastModifiedOn;
            this.catenaXId = catenaXId;
            this.businessPartner = businessPartner;
            this.hasAlternatives = hasAlternatives;
        }

        @Generated
        public ChildData() {
        }

        @JsonDeserialize(builder=QuantityBuilder.class)
        static class Quantity {
            @JsonAlias(value={"quantityNumber", "value"})
            private Double quantityNumber;
            @JsonAlias(value={"measurementUnit", "unit"})
            private Object measurementUnit;

            @Generated
            Quantity(Double quantityNumber, Object measurementUnit) {
                this.quantityNumber = quantityNumber;
                this.measurementUnit = measurementUnit;
            }

            @Generated
            public static QuantityBuilder builder() {
                return new QuantityBuilder();
            }

            @Generated
            public Double getQuantityNumber() {
                return this.quantityNumber;
            }

            @Generated
            public Object getMeasurementUnit() {
                return this.measurementUnit;
            }

            @JsonAlias(value={"quantityNumber", "value"})
            @Generated
            public void setQuantityNumber(Double quantityNumber) {
                this.quantityNumber = quantityNumber;
            }

            @JsonAlias(value={"measurementUnit", "unit"})
            @Generated
            public void setMeasurementUnit(Object measurementUnit) {
                this.measurementUnit = measurementUnit;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Quantity)) {
                    return false;
                }
                Quantity other = (Quantity)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Double this$quantityNumber = this.getQuantityNumber();
                Double other$quantityNumber = other.getQuantityNumber();
                if (this$quantityNumber == null ? other$quantityNumber != null : !((Object)this$quantityNumber).equals(other$quantityNumber)) {
                    return false;
                }
                Object this$measurementUnit = this.getMeasurementUnit();
                Object other$measurementUnit = other.getMeasurementUnit();
                return !(this$measurementUnit == null ? other$measurementUnit != null : !this$measurementUnit.equals(other$measurementUnit));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Quantity;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Double $quantityNumber = this.getQuantityNumber();
                result = result * 59 + ($quantityNumber == null ? 43 : ((Object)$quantityNumber).hashCode());
                Object $measurementUnit = this.getMeasurementUnit();
                result = result * 59 + ($measurementUnit == null ? 43 : $measurementUnit.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "SingleLevelBomAsBuilt.ChildData.Quantity(quantityNumber=" + this.getQuantityNumber() + ", measurementUnit=" + String.valueOf(this.getMeasurementUnit()) + ")";
            }

            @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
            @Generated
            public static class QuantityBuilder {
                @Generated
                private Double quantityNumber;
                @Generated
                private Object measurementUnit;

                @Generated
                QuantityBuilder() {
                }

                @JsonAlias(value={"quantityNumber", "value"})
                @Generated
                public QuantityBuilder quantityNumber(Double quantityNumber) {
                    this.quantityNumber = quantityNumber;
                    return this;
                }

                @JsonAlias(value={"measurementUnit", "unit"})
                @Generated
                public QuantityBuilder measurementUnit(Object measurementUnit) {
                    this.measurementUnit = measurementUnit;
                    return this;
                }

                @Generated
                public Quantity build() {
                    return new Quantity(this.quantityNumber, this.measurementUnit);
                }

                @Generated
                public String toString() {
                    return "SingleLevelBomAsBuilt.ChildData.Quantity.QuantityBuilder(quantityNumber=" + this.quantityNumber + ", measurementUnit=" + String.valueOf(this.measurementUnit) + ")";
                }
            }

            @JsonDeserialize(builder=MeasurementUnitBuilder.class)
            static class MeasurementUnit {
                private String lexicalValue;
                private String datatypeURI;

                @Generated
                MeasurementUnit(String lexicalValue, String datatypeURI) {
                    this.lexicalValue = lexicalValue;
                    this.datatypeURI = datatypeURI;
                }

                @Generated
                public static MeasurementUnitBuilder builder() {
                    return new MeasurementUnitBuilder();
                }

                @Generated
                public String getLexicalValue() {
                    return this.lexicalValue;
                }

                @Generated
                public String getDatatypeURI() {
                    return this.datatypeURI;
                }

                @Generated
                public void setLexicalValue(String lexicalValue) {
                    this.lexicalValue = lexicalValue;
                }

                @Generated
                public void setDatatypeURI(String datatypeURI) {
                    this.datatypeURI = datatypeURI;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof MeasurementUnit)) {
                        return false;
                    }
                    MeasurementUnit other = (MeasurementUnit)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$lexicalValue = this.getLexicalValue();
                    String other$lexicalValue = other.getLexicalValue();
                    if (this$lexicalValue == null ? other$lexicalValue != null : !this$lexicalValue.equals(other$lexicalValue)) {
                        return false;
                    }
                    String this$datatypeURI = this.getDatatypeURI();
                    String other$datatypeURI = other.getDatatypeURI();
                    return !(this$datatypeURI == null ? other$datatypeURI != null : !this$datatypeURI.equals(other$datatypeURI));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof MeasurementUnit;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $lexicalValue = this.getLexicalValue();
                    result = result * 59 + ($lexicalValue == null ? 43 : $lexicalValue.hashCode());
                    String $datatypeURI = this.getDatatypeURI();
                    result = result * 59 + ($datatypeURI == null ? 43 : $datatypeURI.hashCode());
                    return result;
                }

                @Generated
                public String toString() {
                    return "SingleLevelBomAsBuilt.ChildData.Quantity.MeasurementUnit(lexicalValue=" + this.getLexicalValue() + ", datatypeURI=" + this.getDatatypeURI() + ")";
                }

                @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
                @Generated
                public static class MeasurementUnitBuilder {
                    @Generated
                    private String lexicalValue;
                    @Generated
                    private String datatypeURI;

                    @Generated
                    MeasurementUnitBuilder() {
                    }

                    @Generated
                    public MeasurementUnitBuilder lexicalValue(String lexicalValue) {
                        this.lexicalValue = lexicalValue;
                        return this;
                    }

                    @Generated
                    public MeasurementUnitBuilder datatypeURI(String datatypeURI) {
                        this.datatypeURI = datatypeURI;
                        return this;
                    }

                    @Generated
                    public MeasurementUnit build() {
                        return new MeasurementUnit(this.lexicalValue, this.datatypeURI);
                    }

                    @Generated
                    public String toString() {
                        return "SingleLevelBomAsBuilt.ChildData.Quantity.MeasurementUnit.MeasurementUnitBuilder(lexicalValue=" + this.lexicalValue + ", datatypeURI=" + this.datatypeURI + ")";
                    }
                }
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class ChildDataBuilder {
            @Generated
            private ZonedDateTime createdOn;
            @Generated
            private Quantity quantity;
            @Generated
            private ZonedDateTime lastModifiedOn;
            @Generated
            private String catenaXId;
            @Generated
            private String businessPartner;
            @Generated
            private boolean hasAlternatives;

            @Generated
            ChildDataBuilder() {
            }

            @Generated
            public ChildDataBuilder createdOn(ZonedDateTime createdOn) {
                this.createdOn = createdOn;
                return this;
            }

            @Generated
            public ChildDataBuilder quantity(Quantity quantity) {
                this.quantity = quantity;
                return this;
            }

            @Generated
            public ChildDataBuilder lastModifiedOn(ZonedDateTime lastModifiedOn) {
                this.lastModifiedOn = lastModifiedOn;
                return this;
            }

            @Generated
            public ChildDataBuilder catenaXId(String catenaXId) {
                this.catenaXId = catenaXId;
                return this;
            }

            @Generated
            public ChildDataBuilder businessPartner(String businessPartner) {
                this.businessPartner = businessPartner;
                return this;
            }

            @Generated
            public ChildDataBuilder hasAlternatives(boolean hasAlternatives) {
                this.hasAlternatives = hasAlternatives;
                return this;
            }

            @Generated
            public ChildData build() {
                return new ChildData(this.createdOn, this.quantity, this.lastModifiedOn, this.catenaXId, this.businessPartner, this.hasAlternatives);
            }

            @Generated
            public String toString() {
                return "SingleLevelBomAsBuilt.ChildData.ChildDataBuilder(createdOn=" + String.valueOf(this.createdOn) + ", quantity=" + String.valueOf(this.quantity) + ", lastModifiedOn=" + String.valueOf(this.lastModifiedOn) + ", catenaXId=" + this.catenaXId + ", businessPartner=" + this.businessPartner + ", hasAlternatives=" + this.hasAlternatives + ")";
            }
        }
    }
}

