/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.relationships;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.eclipse.tractusx.irs.component.GlobalAssetIdentification;
import org.eclipse.tractusx.irs.component.LinkedItem;
import org.eclipse.tractusx.irs.component.MeasurementUnit;
import org.eclipse.tractusx.irs.component.Quantity;
import org.eclipse.tractusx.irs.component.Relationship;
import org.eclipse.tractusx.irs.component.enums.AspectType;
import org.eclipse.tractusx.irs.component.enums.BomLifecycle;
import org.eclipse.tractusx.irs.edc.client.RelationshipSubmodel;

@JsonDeserialize(builder=SingleLevelBomAsPlannedBuilder.class)
class SingleLevelBomAsPlanned
implements RelationshipSubmodel {
    private String catenaXId;
    private Set<ChildData> childItems;

    @Override
    public List<Relationship> asRelationships() {
        return Optional.ofNullable(this.childItems).stream().flatMap(Collection::stream).map(childData -> childData.toRelationship(this.catenaXId)).toList();
    }

    @Generated
    public static SingleLevelBomAsPlannedBuilder builder() {
        return new SingleLevelBomAsPlannedBuilder();
    }

    @Generated
    public String getCatenaXId() {
        return this.catenaXId;
    }

    @Generated
    public Set<ChildData> getChildItems() {
        return this.childItems;
    }

    @Generated
    public void setCatenaXId(String catenaXId) {
        this.catenaXId = catenaXId;
    }

    @Generated
    public void setChildItems(Set<ChildData> childItems) {
        this.childItems = childItems;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleLevelBomAsPlanned)) {
            return false;
        }
        SingleLevelBomAsPlanned other = (SingleLevelBomAsPlanned)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$catenaXId = this.getCatenaXId();
        String other$catenaXId = other.getCatenaXId();
        if (this$catenaXId == null ? other$catenaXId != null : !this$catenaXId.equals(other$catenaXId)) {
            return false;
        }
        Set<ChildData> this$childItems = this.getChildItems();
        Set<ChildData> other$childItems = other.getChildItems();
        return !(this$childItems == null ? other$childItems != null : !((Object)this$childItems).equals(other$childItems));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SingleLevelBomAsPlanned;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $catenaXId = this.getCatenaXId();
        result = result * 59 + ($catenaXId == null ? 43 : $catenaXId.hashCode());
        Set<ChildData> $childItems = this.getChildItems();
        result = result * 59 + ($childItems == null ? 43 : ((Object)$childItems).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SingleLevelBomAsPlanned(catenaXId=" + this.getCatenaXId() + ", childItems=" + String.valueOf(this.getChildItems()) + ")";
    }

    @Generated
    public SingleLevelBomAsPlanned(String catenaXId, Set<ChildData> childItems) {
        this.catenaXId = catenaXId;
        this.childItems = childItems;
    }

    @Generated
    public SingleLevelBomAsPlanned() {
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class SingleLevelBomAsPlannedBuilder {
        @Generated
        private String catenaXId;
        @Generated
        private Set<ChildData> childItems;

        @Generated
        SingleLevelBomAsPlannedBuilder() {
        }

        @Generated
        public SingleLevelBomAsPlannedBuilder catenaXId(String catenaXId) {
            this.catenaXId = catenaXId;
            return this;
        }

        @Generated
        public SingleLevelBomAsPlannedBuilder childItems(Set<ChildData> childItems) {
            this.childItems = childItems;
            return this;
        }

        @Generated
        public SingleLevelBomAsPlanned build() {
            return new SingleLevelBomAsPlanned(this.catenaXId, this.childItems);
        }

        @Generated
        public String toString() {
            return "SingleLevelBomAsPlanned.SingleLevelBomAsPlannedBuilder(catenaXId=" + this.catenaXId + ", childItems=" + String.valueOf(this.childItems) + ")";
        }
    }

    @JsonDeserialize(builder=ChildDataBuilder.class)
    static class ChildData {
        private ZonedDateTime createdOn;
        private Quantity quantity;
        private ZonedDateTime lastModifiedOn;
        private String catenaXId;
        private String businessPartner;

        public Relationship toRelationship(String catenaXId) {
            LinkedItem.LinkedItemBuilder linkedItem = LinkedItem.builder().childCatenaXId(GlobalAssetIdentification.of((String)this.catenaXId)).lifecycleContext(BomLifecycle.AS_PLANNED).hasAlternatives(Boolean.FALSE.booleanValue()).assembledOn(this.createdOn).lastModifiedOn(this.lastModifiedOn);
            if (this.thereIsQuantity()) {
                linkedItem.quantity(org.eclipse.tractusx.irs.component.Quantity.builder().quantityNumber(this.quantity.getQuantityNumber()).measurementUnit(MeasurementUnit.builder().lexicalValue(this.quantity.getMeasurementUnit()).build()).build());
            }
            return Relationship.builder().catenaXId(GlobalAssetIdentification.of((String)catenaXId)).linkedItem(linkedItem.build()).bpn(this.businessPartner).aspectType(AspectType.SINGLE_LEVEL_BOM_AS_PLANNED.toString()).build();
        }

        private boolean thereIsQuantity() {
            return this.quantity != null;
        }

        @Generated
        public static ChildDataBuilder builder() {
            return new ChildDataBuilder();
        }

        @Generated
        public ZonedDateTime getCreatedOn() {
            return this.createdOn;
        }

        @Generated
        public Quantity getQuantity() {
            return this.quantity;
        }

        @Generated
        public ZonedDateTime getLastModifiedOn() {
            return this.lastModifiedOn;
        }

        @Generated
        public String getCatenaXId() {
            return this.catenaXId;
        }

        @Generated
        public String getBusinessPartner() {
            return this.businessPartner;
        }

        @Generated
        public void setCreatedOn(ZonedDateTime createdOn) {
            this.createdOn = createdOn;
        }

        @Generated
        public void setQuantity(Quantity quantity) {
            this.quantity = quantity;
        }

        @Generated
        public void setLastModifiedOn(ZonedDateTime lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        @Generated
        public void setCatenaXId(String catenaXId) {
            this.catenaXId = catenaXId;
        }

        @Generated
        public void setBusinessPartner(String businessPartner) {
            this.businessPartner = businessPartner;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChildData)) {
                return false;
            }
            ChildData other = (ChildData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ZonedDateTime this$createdOn = this.getCreatedOn();
            ZonedDateTime other$createdOn = other.getCreatedOn();
            if (this$createdOn == null ? other$createdOn != null : !((Object)this$createdOn).equals(other$createdOn)) {
                return false;
            }
            Quantity this$quantity = this.getQuantity();
            Quantity other$quantity = other.getQuantity();
            if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
                return false;
            }
            ZonedDateTime this$lastModifiedOn = this.getLastModifiedOn();
            ZonedDateTime other$lastModifiedOn = other.getLastModifiedOn();
            if (this$lastModifiedOn == null ? other$lastModifiedOn != null : !((Object)this$lastModifiedOn).equals(other$lastModifiedOn)) {
                return false;
            }
            String this$catenaXId = this.getCatenaXId();
            String other$catenaXId = other.getCatenaXId();
            if (this$catenaXId == null ? other$catenaXId != null : !this$catenaXId.equals(other$catenaXId)) {
                return false;
            }
            String this$businessPartner = this.getBusinessPartner();
            String other$businessPartner = other.getBusinessPartner();
            return !(this$businessPartner == null ? other$businessPartner != null : !this$businessPartner.equals(other$businessPartner));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ChildData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ZonedDateTime $createdOn = this.getCreatedOn();
            result = result * 59 + ($createdOn == null ? 43 : ((Object)$createdOn).hashCode());
            Quantity $quantity = this.getQuantity();
            result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
            ZonedDateTime $lastModifiedOn = this.getLastModifiedOn();
            result = result * 59 + ($lastModifiedOn == null ? 43 : ((Object)$lastModifiedOn).hashCode());
            String $catenaXId = this.getCatenaXId();
            result = result * 59 + ($catenaXId == null ? 43 : $catenaXId.hashCode());
            String $businessPartner = this.getBusinessPartner();
            result = result * 59 + ($businessPartner == null ? 43 : $businessPartner.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SingleLevelBomAsPlanned.ChildData(createdOn=" + String.valueOf(this.getCreatedOn()) + ", quantity=" + String.valueOf(this.getQuantity()) + ", lastModifiedOn=" + String.valueOf(this.getLastModifiedOn()) + ", catenaXId=" + this.getCatenaXId() + ", businessPartner=" + this.getBusinessPartner() + ")";
        }

        @Generated
        public ChildData(ZonedDateTime createdOn, Quantity quantity, ZonedDateTime lastModifiedOn, String catenaXId, String businessPartner) {
            this.createdOn = createdOn;
            this.quantity = quantity;
            this.lastModifiedOn = lastModifiedOn;
            this.catenaXId = catenaXId;
            this.businessPartner = businessPartner;
        }

        @Generated
        public ChildData() {
        }

        @JsonDeserialize(builder=QuantityBuilder.class)
        static class Quantity {
            @JsonAlias(value={"quantityNumber", "value"})
            private Double quantityNumber;
            @JsonAlias(value={"measurementUnit", "unit"})
            private String measurementUnit;

            @Generated
            Quantity(Double quantityNumber, String measurementUnit) {
                this.quantityNumber = quantityNumber;
                this.measurementUnit = measurementUnit;
            }

            @Generated
            public static QuantityBuilder builder() {
                return new QuantityBuilder();
            }

            @Generated
            public Double getQuantityNumber() {
                return this.quantityNumber;
            }

            @Generated
            public String getMeasurementUnit() {
                return this.measurementUnit;
            }

            @JsonAlias(value={"quantityNumber", "value"})
            @Generated
            public void setQuantityNumber(Double quantityNumber) {
                this.quantityNumber = quantityNumber;
            }

            @JsonAlias(value={"measurementUnit", "unit"})
            @Generated
            public void setMeasurementUnit(String measurementUnit) {
                this.measurementUnit = measurementUnit;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Quantity)) {
                    return false;
                }
                Quantity other = (Quantity)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Double this$quantityNumber = this.getQuantityNumber();
                Double other$quantityNumber = other.getQuantityNumber();
                if (this$quantityNumber == null ? other$quantityNumber != null : !((Object)this$quantityNumber).equals(other$quantityNumber)) {
                    return false;
                }
                String this$measurementUnit = this.getMeasurementUnit();
                String other$measurementUnit = other.getMeasurementUnit();
                return !(this$measurementUnit == null ? other$measurementUnit != null : !this$measurementUnit.equals(other$measurementUnit));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Quantity;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Double $quantityNumber = this.getQuantityNumber();
                result = result * 59 + ($quantityNumber == null ? 43 : ((Object)$quantityNumber).hashCode());
                String $measurementUnit = this.getMeasurementUnit();
                result = result * 59 + ($measurementUnit == null ? 43 : $measurementUnit.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "SingleLevelBomAsPlanned.ChildData.Quantity(quantityNumber=" + this.getQuantityNumber() + ", measurementUnit=" + this.getMeasurementUnit() + ")";
            }

            @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
            @Generated
            public static class QuantityBuilder {
                @Generated
                private Double quantityNumber;
                @Generated
                private String measurementUnit;

                @Generated
                QuantityBuilder() {
                }

                @JsonAlias(value={"quantityNumber", "value"})
                @Generated
                public QuantityBuilder quantityNumber(Double quantityNumber) {
                    this.quantityNumber = quantityNumber;
                    return this;
                }

                @JsonAlias(value={"measurementUnit", "unit"})
                @Generated
                public QuantityBuilder measurementUnit(String measurementUnit) {
                    this.measurementUnit = measurementUnit;
                    return this;
                }

                @Generated
                public Quantity build() {
                    return new Quantity(this.quantityNumber, this.measurementUnit);
                }

                @Generated
                public String toString() {
                    return "SingleLevelBomAsPlanned.ChildData.Quantity.QuantityBuilder(quantityNumber=" + this.quantityNumber + ", measurementUnit=" + this.measurementUnit + ")";
                }
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class ChildDataBuilder {
            @Generated
            private ZonedDateTime createdOn;
            @Generated
            private Quantity quantity;
            @Generated
            private ZonedDateTime lastModifiedOn;
            @Generated
            private String catenaXId;
            @Generated
            private String businessPartner;

            @Generated
            ChildDataBuilder() {
            }

            @Generated
            public ChildDataBuilder createdOn(ZonedDateTime createdOn) {
                this.createdOn = createdOn;
                return this;
            }

            @Generated
            public ChildDataBuilder quantity(Quantity quantity) {
                this.quantity = quantity;
                return this;
            }

            @Generated
            public ChildDataBuilder lastModifiedOn(ZonedDateTime lastModifiedOn) {
                this.lastModifiedOn = lastModifiedOn;
                return this;
            }

            @Generated
            public ChildDataBuilder catenaXId(String catenaXId) {
                this.catenaXId = catenaXId;
                return this;
            }

            @Generated
            public ChildDataBuilder businessPartner(String businessPartner) {
                this.businessPartner = businessPartner;
                return this;
            }

            @Generated
            public ChildData build() {
                return new ChildData(this.createdOn, this.quantity, this.lastModifiedOn, this.catenaXId, this.businessPartner);
            }

            @Generated
            public String toString() {
                return "SingleLevelBomAsPlanned.ChildData.ChildDataBuilder(createdOn=" + String.valueOf(this.createdOn) + ", quantity=" + String.valueOf(this.quantity) + ", lastModifiedOn=" + String.valueOf(this.lastModifiedOn) + ", catenaXId=" + this.catenaXId + ", businessPartner=" + this.businessPartner + ")";
            }
        }
    }
}

