/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.relationships;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.eclipse.tractusx.irs.component.GlobalAssetIdentification;
import org.eclipse.tractusx.irs.component.LinkedItem;
import org.eclipse.tractusx.irs.component.MeasurementUnit;
import org.eclipse.tractusx.irs.component.Quantity;
import org.eclipse.tractusx.irs.component.Relationship;
import org.eclipse.tractusx.irs.component.enums.AspectType;
import org.eclipse.tractusx.irs.component.enums.BomLifecycle;
import org.eclipse.tractusx.irs.edc.client.RelationshipSubmodel;

@JsonDeserialize(builder=SingleLevelBomAsSpecifiedBuilder.class)
public class SingleLevelBomAsSpecified
implements RelationshipSubmodel {
    @JsonAlias(value={"catenaXId", "assetId"})
    private String catenaXId;
    @JsonAlias(value={"childParts", "childItems"})
    private Set<ChildData> childParts;

    @Override
    public List<Relationship> asRelationships() {
        return Optional.ofNullable(this.childParts).stream().flatMap(Collection::stream).map(childData -> childData.toRelationship(this.catenaXId)).toList();
    }

    @Generated
    public static SingleLevelBomAsSpecifiedBuilder builder() {
        return new SingleLevelBomAsSpecifiedBuilder();
    }

    @Generated
    public String getCatenaXId() {
        return this.catenaXId;
    }

    @Generated
    public Set<ChildData> getChildParts() {
        return this.childParts;
    }

    @JsonAlias(value={"catenaXId", "assetId"})
    @Generated
    public void setCatenaXId(String catenaXId) {
        this.catenaXId = catenaXId;
    }

    @JsonAlias(value={"childParts", "childItems"})
    @Generated
    public void setChildParts(Set<ChildData> childParts) {
        this.childParts = childParts;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleLevelBomAsSpecified)) {
            return false;
        }
        SingleLevelBomAsSpecified other = (SingleLevelBomAsSpecified)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$catenaXId = this.getCatenaXId();
        String other$catenaXId = other.getCatenaXId();
        if (this$catenaXId == null ? other$catenaXId != null : !this$catenaXId.equals(other$catenaXId)) {
            return false;
        }
        Set<ChildData> this$childParts = this.getChildParts();
        Set<ChildData> other$childParts = other.getChildParts();
        return !(this$childParts == null ? other$childParts != null : !((Object)this$childParts).equals(other$childParts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SingleLevelBomAsSpecified;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $catenaXId = this.getCatenaXId();
        result = result * 59 + ($catenaXId == null ? 43 : $catenaXId.hashCode());
        Set<ChildData> $childParts = this.getChildParts();
        result = result * 59 + ($childParts == null ? 43 : ((Object)$childParts).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SingleLevelBomAsSpecified(catenaXId=" + this.getCatenaXId() + ", childParts=" + String.valueOf(this.getChildParts()) + ")";
    }

    @Generated
    public SingleLevelBomAsSpecified(String catenaXId, Set<ChildData> childParts) {
        this.catenaXId = catenaXId;
        this.childParts = childParts;
    }

    @Generated
    public SingleLevelBomAsSpecified() {
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class SingleLevelBomAsSpecifiedBuilder {
        @Generated
        private String catenaXId;
        @Generated
        private Set<ChildData> childParts;

        @Generated
        SingleLevelBomAsSpecifiedBuilder() {
        }

        @JsonAlias(value={"catenaXId", "assetId"})
        @Generated
        public SingleLevelBomAsSpecifiedBuilder catenaXId(String catenaXId) {
            this.catenaXId = catenaXId;
            return this;
        }

        @JsonAlias(value={"childParts", "childItems"})
        @Generated
        public SingleLevelBomAsSpecifiedBuilder childParts(Set<ChildData> childParts) {
            this.childParts = childParts;
            return this;
        }

        @Generated
        public SingleLevelBomAsSpecified build() {
            return new SingleLevelBomAsSpecified(this.catenaXId, this.childParts);
        }

        @Generated
        public String toString() {
            return "SingleLevelBomAsSpecified.SingleLevelBomAsSpecifiedBuilder(catenaXId=" + this.catenaXId + ", childParts=" + String.valueOf(this.childParts) + ")";
        }
    }

    @JsonDeserialize(builder=ChildDataBuilder.class)
    static class ChildData {
        @JsonAlias(value={"childPartsCategory", "childItemCategory"})
        private String childPartsCategory;
        @JsonAlias(value={"part", "item"})
        private Set<Part> part;
        @JsonAlias(value={"childCatenaXId", "childassetId"})
        private String childCatenaXId;
        private String businessPartner;

        public Relationship toRelationship(String catenaXId) {
            Part childPart = this.part.stream().findFirst().orElse(Part.builder().build());
            LinkedItem.LinkedItemBuilder linkedItem = LinkedItem.builder().childCatenaXId(GlobalAssetIdentification.of((String)this.childCatenaXId)).lifecycleContext(BomLifecycle.AS_SPECIFIED).hasAlternatives(Boolean.FALSE.booleanValue()).assembledOn(childPart.getCreatedOn()).lastModifiedOn(childPart.getLastModifiedOn());
            if (childPart.getPartQuantity() != null) {
                linkedItem.quantity(Quantity.builder().quantityNumber(childPart.getPartQuantity().getQuantityNumber()).measurementUnit(MeasurementUnit.builder().lexicalValue(childPart.getPartQuantity().getMeasurementUnit()).build()).build());
            }
            return Relationship.builder().catenaXId(GlobalAssetIdentification.of((String)catenaXId)).linkedItem(linkedItem.build()).bpn(this.businessPartner).aspectType(AspectType.SINGLE_LEVEL_BOM_AS_SPECIFIED.toString()).build();
        }

        @Generated
        public static ChildDataBuilder builder() {
            return new ChildDataBuilder();
        }

        @Generated
        public String getChildPartsCategory() {
            return this.childPartsCategory;
        }

        @Generated
        public Set<Part> getPart() {
            return this.part;
        }

        @Generated
        public String getChildCatenaXId() {
            return this.childCatenaXId;
        }

        @Generated
        public String getBusinessPartner() {
            return this.businessPartner;
        }

        @JsonAlias(value={"childPartsCategory", "childItemCategory"})
        @Generated
        public void setChildPartsCategory(String childPartsCategory) {
            this.childPartsCategory = childPartsCategory;
        }

        @JsonAlias(value={"part", "item"})
        @Generated
        public void setPart(Set<Part> part) {
            this.part = part;
        }

        @JsonAlias(value={"childCatenaXId", "childassetId"})
        @Generated
        public void setChildCatenaXId(String childCatenaXId) {
            this.childCatenaXId = childCatenaXId;
        }

        @Generated
        public void setBusinessPartner(String businessPartner) {
            this.businessPartner = businessPartner;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChildData)) {
                return false;
            }
            ChildData other = (ChildData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$childPartsCategory = this.getChildPartsCategory();
            String other$childPartsCategory = other.getChildPartsCategory();
            if (this$childPartsCategory == null ? other$childPartsCategory != null : !this$childPartsCategory.equals(other$childPartsCategory)) {
                return false;
            }
            Set<Part> this$part = this.getPart();
            Set<Part> other$part = other.getPart();
            if (this$part == null ? other$part != null : !((Object)this$part).equals(other$part)) {
                return false;
            }
            String this$childCatenaXId = this.getChildCatenaXId();
            String other$childCatenaXId = other.getChildCatenaXId();
            if (this$childCatenaXId == null ? other$childCatenaXId != null : !this$childCatenaXId.equals(other$childCatenaXId)) {
                return false;
            }
            String this$businessPartner = this.getBusinessPartner();
            String other$businessPartner = other.getBusinessPartner();
            return !(this$businessPartner == null ? other$businessPartner != null : !this$businessPartner.equals(other$businessPartner));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ChildData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $childPartsCategory = this.getChildPartsCategory();
            result = result * 59 + ($childPartsCategory == null ? 43 : $childPartsCategory.hashCode());
            Set<Part> $part = this.getPart();
            result = result * 59 + ($part == null ? 43 : ((Object)$part).hashCode());
            String $childCatenaXId = this.getChildCatenaXId();
            result = result * 59 + ($childCatenaXId == null ? 43 : $childCatenaXId.hashCode());
            String $businessPartner = this.getBusinessPartner();
            result = result * 59 + ($businessPartner == null ? 43 : $businessPartner.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SingleLevelBomAsSpecified.ChildData(childPartsCategory=" + this.getChildPartsCategory() + ", part=" + String.valueOf(this.getPart()) + ", childCatenaXId=" + this.getChildCatenaXId() + ", businessPartner=" + this.getBusinessPartner() + ")";
        }

        @Generated
        public ChildData(String childPartsCategory, Set<Part> part, String childCatenaXId, String businessPartner) {
            this.childPartsCategory = childPartsCategory;
            this.part = part;
            this.childCatenaXId = childCatenaXId;
            this.businessPartner = businessPartner;
        }

        @Generated
        public ChildData() {
        }

        @JsonDeserialize(builder=PartBuilder.class)
        static class Part {
            @JsonAlias(value={"ownerPartId", "ownerItemId"})
            private String ownerPartId;
            @JsonAlias(value={"partVersion", "itemVersion"})
            private String partVersion;
            @JsonAlias(value={"partQuantity", "itemQuantity"})
            private PartQuantity partQuantity;
            @JsonAlias(value={"partDescription", "itemDescription"})
            private String partDescription;
            private ZonedDateTime createdOn;
            private ZonedDateTime lastModifiedOn;

            @Generated
            Part(String ownerPartId, String partVersion, PartQuantity partQuantity, String partDescription, ZonedDateTime createdOn, ZonedDateTime lastModifiedOn) {
                this.ownerPartId = ownerPartId;
                this.partVersion = partVersion;
                this.partQuantity = partQuantity;
                this.partDescription = partDescription;
                this.createdOn = createdOn;
                this.lastModifiedOn = lastModifiedOn;
            }

            @Generated
            public static PartBuilder builder() {
                return new PartBuilder();
            }

            @Generated
            public String getOwnerPartId() {
                return this.ownerPartId;
            }

            @Generated
            public String getPartVersion() {
                return this.partVersion;
            }

            @Generated
            public PartQuantity getPartQuantity() {
                return this.partQuantity;
            }

            @Generated
            public String getPartDescription() {
                return this.partDescription;
            }

            @Generated
            public ZonedDateTime getCreatedOn() {
                return this.createdOn;
            }

            @Generated
            public ZonedDateTime getLastModifiedOn() {
                return this.lastModifiedOn;
            }

            @JsonAlias(value={"ownerPartId", "ownerItemId"})
            @Generated
            public void setOwnerPartId(String ownerPartId) {
                this.ownerPartId = ownerPartId;
            }

            @JsonAlias(value={"partVersion", "itemVersion"})
            @Generated
            public void setPartVersion(String partVersion) {
                this.partVersion = partVersion;
            }

            @JsonAlias(value={"partQuantity", "itemQuantity"})
            @Generated
            public void setPartQuantity(PartQuantity partQuantity) {
                this.partQuantity = partQuantity;
            }

            @JsonAlias(value={"partDescription", "itemDescription"})
            @Generated
            public void setPartDescription(String partDescription) {
                this.partDescription = partDescription;
            }

            @Generated
            public void setCreatedOn(ZonedDateTime createdOn) {
                this.createdOn = createdOn;
            }

            @Generated
            public void setLastModifiedOn(ZonedDateTime lastModifiedOn) {
                this.lastModifiedOn = lastModifiedOn;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Part)) {
                    return false;
                }
                Part other = (Part)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$ownerPartId = this.getOwnerPartId();
                String other$ownerPartId = other.getOwnerPartId();
                if (this$ownerPartId == null ? other$ownerPartId != null : !this$ownerPartId.equals(other$ownerPartId)) {
                    return false;
                }
                String this$partVersion = this.getPartVersion();
                String other$partVersion = other.getPartVersion();
                if (this$partVersion == null ? other$partVersion != null : !this$partVersion.equals(other$partVersion)) {
                    return false;
                }
                PartQuantity this$partQuantity = this.getPartQuantity();
                PartQuantity other$partQuantity = other.getPartQuantity();
                if (this$partQuantity == null ? other$partQuantity != null : !((Object)this$partQuantity).equals(other$partQuantity)) {
                    return false;
                }
                String this$partDescription = this.getPartDescription();
                String other$partDescription = other.getPartDescription();
                if (this$partDescription == null ? other$partDescription != null : !this$partDescription.equals(other$partDescription)) {
                    return false;
                }
                ZonedDateTime this$createdOn = this.getCreatedOn();
                ZonedDateTime other$createdOn = other.getCreatedOn();
                if (this$createdOn == null ? other$createdOn != null : !((Object)this$createdOn).equals(other$createdOn)) {
                    return false;
                }
                ZonedDateTime this$lastModifiedOn = this.getLastModifiedOn();
                ZonedDateTime other$lastModifiedOn = other.getLastModifiedOn();
                return !(this$lastModifiedOn == null ? other$lastModifiedOn != null : !((Object)this$lastModifiedOn).equals(other$lastModifiedOn));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Part;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $ownerPartId = this.getOwnerPartId();
                result = result * 59 + ($ownerPartId == null ? 43 : $ownerPartId.hashCode());
                String $partVersion = this.getPartVersion();
                result = result * 59 + ($partVersion == null ? 43 : $partVersion.hashCode());
                PartQuantity $partQuantity = this.getPartQuantity();
                result = result * 59 + ($partQuantity == null ? 43 : ((Object)$partQuantity).hashCode());
                String $partDescription = this.getPartDescription();
                result = result * 59 + ($partDescription == null ? 43 : $partDescription.hashCode());
                ZonedDateTime $createdOn = this.getCreatedOn();
                result = result * 59 + ($createdOn == null ? 43 : ((Object)$createdOn).hashCode());
                ZonedDateTime $lastModifiedOn = this.getLastModifiedOn();
                result = result * 59 + ($lastModifiedOn == null ? 43 : ((Object)$lastModifiedOn).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "SingleLevelBomAsSpecified.ChildData.Part(ownerPartId=" + this.getOwnerPartId() + ", partVersion=" + this.getPartVersion() + ", partQuantity=" + String.valueOf(this.getPartQuantity()) + ", partDescription=" + this.getPartDescription() + ", createdOn=" + String.valueOf(this.getCreatedOn()) + ", lastModifiedOn=" + String.valueOf(this.getLastModifiedOn()) + ")";
            }

            @JsonDeserialize(builder=PartQuantityBuilder.class)
            static class PartQuantity {
                @JsonAlias(value={"quantityNumber", "value"})
                private Double quantityNumber;
                @JsonAlias(value={"measurementUnit", "unit"})
                private String measurementUnit;

                @Generated
                PartQuantity(Double quantityNumber, String measurementUnit) {
                    this.quantityNumber = quantityNumber;
                    this.measurementUnit = measurementUnit;
                }

                @Generated
                public static PartQuantityBuilder builder() {
                    return new PartQuantityBuilder();
                }

                @Generated
                public Double getQuantityNumber() {
                    return this.quantityNumber;
                }

                @Generated
                public String getMeasurementUnit() {
                    return this.measurementUnit;
                }

                @JsonAlias(value={"quantityNumber", "value"})
                @Generated
                public void setQuantityNumber(Double quantityNumber) {
                    this.quantityNumber = quantityNumber;
                }

                @JsonAlias(value={"measurementUnit", "unit"})
                @Generated
                public void setMeasurementUnit(String measurementUnit) {
                    this.measurementUnit = measurementUnit;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof PartQuantity)) {
                        return false;
                    }
                    PartQuantity other = (PartQuantity)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Double this$quantityNumber = this.getQuantityNumber();
                    Double other$quantityNumber = other.getQuantityNumber();
                    if (this$quantityNumber == null ? other$quantityNumber != null : !((Object)this$quantityNumber).equals(other$quantityNumber)) {
                        return false;
                    }
                    String this$measurementUnit = this.getMeasurementUnit();
                    String other$measurementUnit = other.getMeasurementUnit();
                    return !(this$measurementUnit == null ? other$measurementUnit != null : !this$measurementUnit.equals(other$measurementUnit));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof PartQuantity;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Double $quantityNumber = this.getQuantityNumber();
                    result = result * 59 + ($quantityNumber == null ? 43 : ((Object)$quantityNumber).hashCode());
                    String $measurementUnit = this.getMeasurementUnit();
                    result = result * 59 + ($measurementUnit == null ? 43 : $measurementUnit.hashCode());
                    return result;
                }

                @Generated
                public String toString() {
                    return "SingleLevelBomAsSpecified.ChildData.Part.PartQuantity(quantityNumber=" + this.getQuantityNumber() + ", measurementUnit=" + this.getMeasurementUnit() + ")";
                }

                @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
                @Generated
                public static class PartQuantityBuilder {
                    @Generated
                    private Double quantityNumber;
                    @Generated
                    private String measurementUnit;

                    @Generated
                    PartQuantityBuilder() {
                    }

                    @JsonAlias(value={"quantityNumber", "value"})
                    @Generated
                    public PartQuantityBuilder quantityNumber(Double quantityNumber) {
                        this.quantityNumber = quantityNumber;
                        return this;
                    }

                    @JsonAlias(value={"measurementUnit", "unit"})
                    @Generated
                    public PartQuantityBuilder measurementUnit(String measurementUnit) {
                        this.measurementUnit = measurementUnit;
                        return this;
                    }

                    @Generated
                    public PartQuantity build() {
                        return new PartQuantity(this.quantityNumber, this.measurementUnit);
                    }

                    @Generated
                    public String toString() {
                        return "SingleLevelBomAsSpecified.ChildData.Part.PartQuantity.PartQuantityBuilder(quantityNumber=" + this.quantityNumber + ", measurementUnit=" + this.measurementUnit + ")";
                    }
                }
            }

            @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
            @Generated
            public static class PartBuilder {
                @Generated
                private String ownerPartId;
                @Generated
                private String partVersion;
                @Generated
                private PartQuantity partQuantity;
                @Generated
                private String partDescription;
                @Generated
                private ZonedDateTime createdOn;
                @Generated
                private ZonedDateTime lastModifiedOn;

                @Generated
                PartBuilder() {
                }

                @JsonAlias(value={"ownerPartId", "ownerItemId"})
                @Generated
                public PartBuilder ownerPartId(String ownerPartId) {
                    this.ownerPartId = ownerPartId;
                    return this;
                }

                @JsonAlias(value={"partVersion", "itemVersion"})
                @Generated
                public PartBuilder partVersion(String partVersion) {
                    this.partVersion = partVersion;
                    return this;
                }

                @JsonAlias(value={"partQuantity", "itemQuantity"})
                @Generated
                public PartBuilder partQuantity(PartQuantity partQuantity) {
                    this.partQuantity = partQuantity;
                    return this;
                }

                @JsonAlias(value={"partDescription", "itemDescription"})
                @Generated
                public PartBuilder partDescription(String partDescription) {
                    this.partDescription = partDescription;
                    return this;
                }

                @Generated
                public PartBuilder createdOn(ZonedDateTime createdOn) {
                    this.createdOn = createdOn;
                    return this;
                }

                @Generated
                public PartBuilder lastModifiedOn(ZonedDateTime lastModifiedOn) {
                    this.lastModifiedOn = lastModifiedOn;
                    return this;
                }

                @Generated
                public Part build() {
                    return new Part(this.ownerPartId, this.partVersion, this.partQuantity, this.partDescription, this.createdOn, this.lastModifiedOn);
                }

                @Generated
                public String toString() {
                    return "SingleLevelBomAsSpecified.ChildData.Part.PartBuilder(ownerPartId=" + this.ownerPartId + ", partVersion=" + this.partVersion + ", partQuantity=" + String.valueOf(this.partQuantity) + ", partDescription=" + this.partDescription + ", createdOn=" + String.valueOf(this.createdOn) + ", lastModifiedOn=" + String.valueOf(this.lastModifiedOn) + ")";
                }
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class ChildDataBuilder {
            @Generated
            private String childPartsCategory;
            @Generated
            private Set<Part> part;
            @Generated
            private String childCatenaXId;
            @Generated
            private String businessPartner;

            @Generated
            ChildDataBuilder() {
            }

            @JsonAlias(value={"childPartsCategory", "childItemCategory"})
            @Generated
            public ChildDataBuilder childPartsCategory(String childPartsCategory) {
                this.childPartsCategory = childPartsCategory;
                return this;
            }

            @JsonAlias(value={"part", "item"})
            @Generated
            public ChildDataBuilder part(Set<Part> part) {
                this.part = part;
                return this;
            }

            @JsonAlias(value={"childCatenaXId", "childassetId"})
            @Generated
            public ChildDataBuilder childCatenaXId(String childCatenaXId) {
                this.childCatenaXId = childCatenaXId;
                return this;
            }

            @Generated
            public ChildDataBuilder businessPartner(String businessPartner) {
                this.businessPartner = businessPartner;
                return this;
            }

            @Generated
            public ChildData build() {
                return new ChildData(this.childPartsCategory, this.part, this.childCatenaXId, this.businessPartner);
            }

            @Generated
            public String toString() {
                return "SingleLevelBomAsSpecified.ChildData.ChildDataBuilder(childPartsCategory=" + this.childPartsCategory + ", part=" + String.valueOf(this.part) + ", childCatenaXId=" + this.childCatenaXId + ", businessPartner=" + this.businessPartner + ")";
            }
        }
    }
}

