/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.relationships;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.tractusx.irs.data.CxTestDataContainer;

public class SubmodelTestdataCreator {
    private final CxTestDataContainer cxTestDataContainer;
    private final ObjectMapper objectMapper;

    public SubmodelTestdataCreator(CxTestDataContainer cxTestDataContainer) {
        this.cxTestDataContainer = cxTestDataContainer;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new Jdk8Module());
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public Map<String, Object> createSubmodelForId(String endpointAddress) {
        String catenaXId = StringUtils.substringBefore((String)endpointAddress, (String)"_");
        if (endpointAddress.contains("singleLevelBomAsBuilt")) {
            return this.cxTestDataContainer.getByCatenaXId(catenaXId).flatMap(CxTestDataContainer.CxTestData::getSingleLevelBomAsBuilt).orElse(Map.of());
        }
        if (endpointAddress.contains("singleLevelUsageAsBuilt")) {
            return this.cxTestDataContainer.getByCatenaXId(catenaXId).flatMap(CxTestDataContainer.CxTestData::getSingleLevelUsageAsBuilt).orElse(Map.of());
        }
        if (endpointAddress.contains("singleLevelBomAsSpecified")) {
            return this.cxTestDataContainer.getByCatenaXId(catenaXId).flatMap(CxTestDataContainer.CxTestData::getSingleLevelBomAsSpecified).orElse(Map.of());
        }
        if (endpointAddress.contains("serialPart")) {
            return this.cxTestDataContainer.getByCatenaXId(catenaXId).flatMap(CxTestDataContainer.CxTestData::getSerialPart).orElse(Map.of());
        }
        if (endpointAddress.contains("singleLevelBomAsPlanned")) {
            return this.cxTestDataContainer.getByCatenaXId(catenaXId).flatMap(CxTestDataContainer.CxTestData::getSingleLevelBomAsPlanned).orElse(Map.of());
        }
        if (endpointAddress.contains("singleLevelUsageAsPlanned")) {
            return this.cxTestDataContainer.getByCatenaXId(catenaXId).flatMap(CxTestDataContainer.CxTestData::getSingleLevelUsageAsPlanned).orElse(Map.of());
        }
        if (endpointAddress.contains("partAsPlanned")) {
            return this.cxTestDataContainer.getByCatenaXId(catenaXId).flatMap(CxTestDataContainer.CxTestData::getPartAsPlanned).orElse(Map.of());
        }
        if (endpointAddress.contains("batch")) {
            return this.cxTestDataContainer.getByCatenaXId(catenaXId).flatMap(CxTestDataContainer.CxTestData::getBatch).orElse(Map.of());
        }
        if (endpointAddress.contains("materialForRecycling")) {
            return this.cxTestDataContainer.getByCatenaXId(catenaXId).flatMap(CxTestDataContainer.CxTestData::getMaterialForRecycling).orElse(Map.of());
        }
        if (endpointAddress.contains("productDescription")) {
            return this.cxTestDataContainer.getByCatenaXId(catenaXId).flatMap(CxTestDataContainer.CxTestData::getProductDescription).orElse(Map.of());
        }
        if (endpointAddress.contains("physicalDimension")) {
            return this.cxTestDataContainer.getByCatenaXId(catenaXId).flatMap(CxTestDataContainer.CxTestData::getPhysicalDimension).orElse(Map.of());
        }
        if (endpointAddress.contains("partAsSpecified")) {
            return this.cxTestDataContainer.getByCatenaXId(catenaXId).flatMap(CxTestDataContainer.CxTestData::getPartAsSpecified).orElse(Map.of());
        }
        return Map.of();
    }

    public <T> T createSubmodelForId(String catenaXId, Class<T> submodelClass) {
        Map<String, Object> submodelForId = this.createSubmodelForId(catenaXId);
        return (T)this.objectMapper.convertValue(submodelForId, submodelClass);
    }
}

