/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.transformer;

import com.apicatalog.jsonld.document.JsonDocument;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonStructure;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import org.eclipse.edc.api.transformer.JsonObjectFromCallbackAddressTransformer;
import org.eclipse.edc.api.transformer.JsonObjectToCallbackAddressTransformer;
import org.eclipse.edc.catalog.spi.Catalog;
import org.eclipse.edc.catalog.spi.CatalogRequest;
import org.eclipse.edc.connector.api.management.contractnegotiation.transform.JsonObjectToContractRequestTransformer;
import org.eclipse.edc.connector.core.base.agent.NoOpParticipantIdMapper;
import org.eclipse.edc.core.transform.TransformerContextImpl;
import org.eclipse.edc.core.transform.transformer.dcat.from.JsonObjectFromCatalogTransformer;
import org.eclipse.edc.core.transform.transformer.dcat.from.JsonObjectFromDataServiceTransformer;
import org.eclipse.edc.core.transform.transformer.dcat.from.JsonObjectFromDatasetTransformer;
import org.eclipse.edc.core.transform.transformer.dcat.from.JsonObjectFromDistributionTransformer;
import org.eclipse.edc.core.transform.transformer.edc.from.JsonObjectFromAssetTransformer;
import org.eclipse.edc.core.transform.transformer.edc.from.JsonObjectFromCriterionTransformer;
import org.eclipse.edc.core.transform.transformer.edc.from.JsonObjectFromDataAddressTransformer;
import org.eclipse.edc.core.transform.transformer.edc.from.JsonObjectFromQuerySpecTransformer;
import org.eclipse.edc.core.transform.transformer.edc.to.JsonObjectToActionTransformer;
import org.eclipse.edc.core.transform.transformer.edc.to.JsonObjectToAssetTransformer;
import org.eclipse.edc.core.transform.transformer.edc.to.JsonObjectToCriterionTransformer;
import org.eclipse.edc.core.transform.transformer.edc.to.JsonObjectToQuerySpecTransformer;
import org.eclipse.edc.core.transform.transformer.edc.to.JsonValueToGenericTypeTransformer;
import org.eclipse.edc.core.transform.transformer.odrl.to.JsonObjectToConstraintTransformer;
import org.eclipse.edc.core.transform.transformer.odrl.to.JsonObjectToDutyTransformer;
import org.eclipse.edc.core.transform.transformer.odrl.to.JsonObjectToOperatorTransformer;
import org.eclipse.edc.core.transform.transformer.odrl.to.JsonObjectToPermissionTransformer;
import org.eclipse.edc.core.transform.transformer.odrl.to.JsonObjectToPolicyTransformer;
import org.eclipse.edc.core.transform.transformer.odrl.to.JsonObjectToProhibitionTransformer;
import org.eclipse.edc.jsonld.TitaniumJsonLd;
import org.eclipse.edc.protocol.dsp.negotiation.transform.from.JsonObjectFromContractNegotiationTransformer;
import org.eclipse.edc.spi.agent.ParticipantIdMapper;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.domain.asset.Asset;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.tractusx.irs.edc.client.model.ContractOfferDescription;
import org.eclipse.tractusx.irs.edc.client.model.NegotiationRequest;
import org.eclipse.tractusx.irs.edc.client.model.TransferProcessRequest;
import org.eclipse.tractusx.irs.edc.client.policy.Policy;
import org.eclipse.tractusx.irs.edc.client.transformer.JsonObjectFromCatalogRequestTransformer;
import org.eclipse.tractusx.irs.edc.client.transformer.JsonObjectFromContractOfferDescriptionTransformer;
import org.eclipse.tractusx.irs.edc.client.transformer.JsonObjectFromContractOfferTransformer;
import org.eclipse.tractusx.irs.edc.client.transformer.JsonObjectFromNegotiationInitiateDtoTransformer;
import org.eclipse.tractusx.irs.edc.client.transformer.JsonObjectFromPolicyTransformer;
import org.eclipse.tractusx.irs.edc.client.transformer.JsonObjectFromTransferProcessRequestTransformer;
import org.eclipse.tractusx.irs.edc.client.transformer.JsonObjectToCatalogTransformer;
import org.eclipse.tractusx.irs.edc.client.transformer.JsonObjectToDataServiceTransformer;
import org.eclipse.tractusx.irs.edc.client.transformer.JsonObjectToDatasetTransformer;
import org.eclipse.tractusx.irs.edc.client.transformer.JsonObjectToDistributionTransformer;
import org.eclipse.tractusx.irs.edc.client.transformer.JsonObjectToIrsPolicyTransformer;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="irsEdcClientEdcTransformer")
public class EdcTransformer {
    private final JsonObjectToCatalogTransformer jsonObjectToCatalogTransformer;
    private final JsonObjectFromNegotiationInitiateDtoTransformer jsonObjectFromNegotiationInitiateDtoTransformer;
    private final JsonObjectFromTransferProcessRequestTransformer jsonObjectFromTransferProcessRequestTransformer;
    private final JsonObjectFromContractOfferDescriptionTransformer jsonObjectFromContractOfferDescriptionTransformer;
    private final JsonObjectFromCatalogRequestTransformer jsonObjectFromCatalogRequestTransformer;
    private final TitaniumJsonLd titaniumJsonLd;
    private final TransformerContext transformerContext;
    private final JsonObjectFromAssetTransformer jsonObjectFromAssetTransformer;
    private final JsonObjectToIrsPolicyTransformer jsonObjectToIrsPolicyTransformer;

    public EdcTransformer(@Qualifier(value="jsonLdObjectMapper") ObjectMapper objectMapper, TitaniumJsonLd titaniumJsonLd, TypeTransformerRegistry typeTransformerRegistry) {
        this.titaniumJsonLd = titaniumJsonLd;
        this.transformerContext = new TransformerContextImpl(typeTransformerRegistry);
        NoOpParticipantIdMapper participantIdMapper = new NoOpParticipantIdMapper();
        JsonBuilderFactory jsonBuilderFactory = Json.createBuilderFactory(Map.of());
        this.jsonObjectToCatalogTransformer = new JsonObjectToCatalogTransformer();
        this.jsonObjectToIrsPolicyTransformer = new JsonObjectToIrsPolicyTransformer(objectMapper);
        this.jsonObjectFromNegotiationInitiateDtoTransformer = new JsonObjectFromNegotiationInitiateDtoTransformer(jsonBuilderFactory);
        this.jsonObjectFromTransferProcessRequestTransformer = new JsonObjectFromTransferProcessRequestTransformer(jsonBuilderFactory);
        this.jsonObjectFromContractOfferDescriptionTransformer = new JsonObjectFromContractOfferDescriptionTransformer(jsonBuilderFactory);
        this.jsonObjectFromCatalogRequestTransformer = new JsonObjectFromCatalogRequestTransformer(jsonBuilderFactory);
        this.jsonObjectFromAssetTransformer = new JsonObjectFromAssetTransformer(jsonBuilderFactory, objectMapper);
        typeTransformerRegistry.register((TypeTransformer)this.jsonObjectToCatalogTransformer);
        typeTransformerRegistry.register((TypeTransformer)this.jsonObjectToIrsPolicyTransformer);
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectToPolicyTransformer((ParticipantIdMapper)participantIdMapper));
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractOfferTransformer((ParticipantIdMapper)participantIdMapper, jsonBuilderFactory));
        typeTransformerRegistry.register((TypeTransformer)new JsonValueToGenericTypeTransformer(objectMapper));
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectToDataServiceTransformer());
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectToConstraintTransformer());
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectToDatasetTransformer());
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectToContractRequestTransformer());
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectToPermissionTransformer());
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectToActionTransformer());
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectToDistributionTransformer());
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectToProhibitionTransformer());
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectToDutyTransformer());
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectToAssetTransformer());
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectToQuerySpecTransformer());
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectToCriterionTransformer());
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectToOperatorTransformer());
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectToCallbackAddressTransformer());
        typeTransformerRegistry.register((TypeTransformer)this.jsonObjectFromNegotiationInitiateDtoTransformer);
        typeTransformerRegistry.register((TypeTransformer)this.jsonObjectFromCatalogRequestTransformer);
        typeTransformerRegistry.register((TypeTransformer)this.jsonObjectFromTransferProcessRequestTransformer);
        typeTransformerRegistry.register((TypeTransformer)this.jsonObjectFromContractOfferDescriptionTransformer);
        typeTransformerRegistry.register((TypeTransformer)this.jsonObjectFromAssetTransformer);
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectFromContractNegotiationTransformer(jsonBuilderFactory));
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectFromQuerySpecTransformer(jsonBuilderFactory));
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectFromCatalogTransformer(jsonBuilderFactory, objectMapper, (ParticipantIdMapper)participantIdMapper));
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectFromDatasetTransformer(jsonBuilderFactory, objectMapper));
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectFromPolicyTransformer(jsonBuilderFactory, (ParticipantIdMapper)participantIdMapper));
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectFromDistributionTransformer(jsonBuilderFactory));
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectFromDataServiceTransformer(jsonBuilderFactory));
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectFromCriterionTransformer(jsonBuilderFactory, objectMapper));
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectFromDataAddressTransformer(jsonBuilderFactory));
        typeTransformerRegistry.register((TypeTransformer)new JsonObjectFromCallbackAddressTransformer(jsonBuilderFactory));
    }

    public Catalog transformCatalog(String jsonString, Charset charset) {
        Result<JsonObject> expand = this.expandJsonLd(jsonString, charset);
        return this.jsonObjectToCatalogTransformer.transform((JsonObject)expand.getContent(), this.transformerContext);
    }

    public Result<JsonObject> expandJsonLd(String jsonString, Charset charset) {
        Result expand;
        try (JsonReader reader = Json.createReader((InputStream)new ByteArrayInputStream(jsonString.getBytes(charset)));){
            expand = this.titaniumJsonLd.expand(((JsonStructure)JsonDocument.of((JsonStructure)reader.read()).getJsonContent().orElseThrow()).asJsonObject());
        }
        return expand;
    }

    public JsonObject transformNegotiationRequestToJson(NegotiationRequest negotiationRequest) {
        JsonObject transform = this.jsonObjectFromNegotiationInitiateDtoTransformer.transform(negotiationRequest, this.transformerContext);
        return (JsonObject)this.titaniumJsonLd.compact(transform).asOptional().orElseThrow();
    }

    public JsonObject transformTransferProcessRequestToJson(TransferProcessRequest transferProcessRequest) {
        JsonObject transform = this.jsonObjectFromTransferProcessRequestTransformer.transform(transferProcessRequest, this.transformerContext);
        return (JsonObject)this.titaniumJsonLd.compact(transform).asOptional().orElseThrow();
    }

    public JsonObject transformContractOfferDescriptionToJson(ContractOfferDescription contractOfferDescription) {
        JsonObject transform = this.jsonObjectFromContractOfferDescriptionTransformer.transform(contractOfferDescription, this.transformerContext);
        return (JsonObject)this.titaniumJsonLd.compact(transform).asOptional().orElseThrow();
    }

    public JsonObject transformCatalogRequestToJson(CatalogRequest catalogRequest) {
        JsonObject transform = this.jsonObjectFromCatalogRequestTransformer.transform(catalogRequest, this.transformerContext);
        return (JsonObject)this.titaniumJsonLd.compact(transform).asOptional().orElseThrow();
    }

    public JsonObject transformAssetToJson(Asset assetRequest) {
        JsonObject transform = this.jsonObjectFromAssetTransformer.transform(assetRequest, this.transformerContext);
        return (JsonObject)this.titaniumJsonLd.compact(transform).asOptional().orElseThrow();
    }

    public @Nullable Policy transformToIrsPolicy(JsonObject body) {
        return this.jsonObjectToIrsPolicyTransformer.transform(body, this.transformerContext);
    }
}

