/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.transformer;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.Optional;
import org.eclipse.edc.catalog.spi.CatalogRequest;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromCatalogRequestTransformer
extends AbstractJsonLdTransformer<CatalogRequest, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromCatalogRequestTransformer(JsonBuilderFactory jsonFactory) {
        super(CatalogRequest.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull CatalogRequest dto, @NotNull TransformerContext context) {
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder();
        builder.add("@type", "https://w3id.org/edc/v0.0.1/ns/CatalogRequest").add("https://w3id.org/edc/v0.0.1/ns/counterPartyAddress", dto.getCounterPartyAddress()).add("https://w3id.org/edc/v0.0.1/ns/counterPartyId", dto.getCounterPartyId()).add("https://w3id.org/edc/v0.0.1/ns/protocol", dto.getProtocol());
        Optional.ofNullable(dto.getQuerySpec()).ifPresent(s -> builder.add("https://w3id.org/edc/v0.0.1/ns/querySpec", (JsonValue)context.transform((Object)dto.getQuerySpec(), JsonObject.class)));
        return builder.build();
    }
}

