/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.transformer;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.Optional;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.spi.agent.ParticipantIdMapper;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.eclipse.tractusx.irs.edc.client.model.ContractOffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromContractOfferTransformer
extends AbstractJsonLdTransformer<ContractOffer, JsonObject> {
    private final ParticipantIdMapper participantIdMapper;
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromContractOfferTransformer(ParticipantIdMapper participantIdMapper, JsonBuilderFactory jsonFactory) {
        super(ContractOffer.class, JsonObject.class);
        this.participantIdMapper = participantIdMapper;
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull ContractOffer contractOffer, @NotNull TransformerContext context) {
        Policy policy = Policy.Builder.newInstance().duties(contractOffer.getObligations()).prohibitions(contractOffer.getProhibitions()).permissions(contractOffer.getPermissions()).build();
        JsonObject transform = (JsonObject)context.transform((Object)policy, JsonObject.class);
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder().add("@id", contractOffer.getOfferId()).add("@type", contractOffer.getType());
        if (Optional.ofNullable(transform).isPresent()) {
            builder.add("http://www.w3.org/ns/odrl/2/permission", (JsonValue)transform.getJsonArray("http://www.w3.org/ns/odrl/2/permission")).add("http://www.w3.org/ns/odrl/2/prohibition", (JsonValue)transform.getJsonArray("http://www.w3.org/ns/odrl/2/prohibition")).add("http://www.w3.org/ns/odrl/2/obligation", (JsonValue)transform.getJsonArray("http://www.w3.org/ns/odrl/2/obligation"));
        }
        this.addIfPresent(Optional.ofNullable(contractOffer.getAssignee()).map(arg_0 -> ((ParticipantIdMapper)this.participantIdMapper).toIri(arg_0)), builder, "http://www.w3.org/ns/odrl/2/assignee");
        this.addIfPresent(Optional.ofNullable(contractOffer.getAssigner()).map(arg_0 -> ((ParticipantIdMapper)this.participantIdMapper).toIri(arg_0)), builder, "http://www.w3.org/ns/odrl/2/assigner");
        this.addIfPresent(Optional.ofNullable(contractOffer.getTarget()), builder, "http://www.w3.org/ns/odrl/2/target");
        return builder.build();
    }

    private void addIfPresent(Optional<String> property, JsonObjectBuilder builder, String attribute) {
        property.ifPresent(target -> builder.add(attribute, this.jsonFactory.createArrayBuilder().add(this.jsonFactory.createObjectBuilder().add("@id", target))));
    }
}

