/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.transformer;

import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.domain.callback.CallbackAddress;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.eclipse.tractusx.irs.edc.client.model.NegotiationRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromNegotiationInitiateDtoTransformer
extends AbstractJsonLdTransformer<NegotiationRequest, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromNegotiationInitiateDtoTransformer(JsonBuilderFactory jsonFactory) {
        super(NegotiationRequest.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull NegotiationRequest dto, @NotNull TransformerContext context) {
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder();
        builder.add("https://w3id.org/edc/v0.0.1/ns/counterPartyAddress", dto.getCounterPartyAddress()).add("https://w3id.org/edc/v0.0.1/ns/counterPartyId", dto.getCounterPartyId()).add("https://w3id.org/edc/v0.0.1/ns/policy", (JsonValue)context.transform((Object)dto.getContractOffer(), JsonObject.class)).add("https://w3id.org/edc/v0.0.1/ns/protocol", dto.getProtocol());
        Optional.ofNullable(dto.getCallbackAddresses()).ifPresent(s -> builder.add("https://w3id.org/edc/v0.0.1/ns/callbackAddresses", this.asArray(dto.getCallbackAddresses(), context)));
        return builder.build();
    }

    private JsonArrayBuilder asArray(List<CallbackAddress> callbackAddresses, TransformerContext context) {
        JsonArrayBuilder builder = Objects.requireNonNull(this.jsonFactory.createArrayBuilder());
        callbackAddresses.stream().map(callbackAddress -> (JsonObject)context.transform(callbackAddress, JsonObject.class)).forEach(arg_0 -> ((JsonArrayBuilder)builder).add(arg_0));
        return builder;
    }
}

