/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.transformer;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.policy.model.Action;
import org.eclipse.edc.policy.model.AndConstraint;
import org.eclipse.edc.policy.model.AtomicConstraint;
import org.eclipse.edc.policy.model.Constraint;
import org.eclipse.edc.policy.model.Duty;
import org.eclipse.edc.policy.model.Expression;
import org.eclipse.edc.policy.model.LiteralExpression;
import org.eclipse.edc.policy.model.MultiplicityConstraint;
import org.eclipse.edc.policy.model.OrConstraint;
import org.eclipse.edc.policy.model.Permission;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.policy.model.PolicyType;
import org.eclipse.edc.policy.model.Prohibition;
import org.eclipse.edc.policy.model.Rule;
import org.eclipse.edc.policy.model.XoneConstraint;
import org.eclipse.edc.spi.agent.ParticipantIdMapper;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromPolicyTransformer
extends AbstractJsonLdTransformer<Policy, JsonObject> {
    private final JsonBuilderFactory jsonFactory;
    private final ParticipantIdMapper participantIdMapper;

    public JsonObjectFromPolicyTransformer(JsonBuilderFactory jsonFactory, ParticipantIdMapper participantIdMapper) {
        super(Policy.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
        this.participantIdMapper = participantIdMapper;
    }

    @Nullable
    public JsonObject transform(@NotNull Policy policy, @NotNull TransformerContext context) {
        return (JsonObject)policy.accept((Policy.Visitor)new Visitor(this.jsonFactory, this.participantIdMapper));
    }

    private static class Visitor
    implements Policy.Visitor<JsonObject>,
    Rule.Visitor<JsonObject>,
    Constraint.Visitor<JsonObject>,
    Expression.Visitor<JsonObject> {
        private final JsonBuilderFactory jsonFactory;
        private final ParticipantIdMapper participantIdMapper;

        Visitor(JsonBuilderFactory jsonFactory, ParticipantIdMapper participantIdMapper) {
            this.jsonFactory = jsonFactory;
            this.participantIdMapper = participantIdMapper;
        }

        public JsonObject visitAndConstraint(AndConstraint andConstraint) {
            return this.visitMultiplicityConstraint("http://www.w3.org/ns/odrl/2/and", (MultiplicityConstraint)andConstraint);
        }

        public JsonObject visitOrConstraint(OrConstraint orConstraint) {
            return this.visitMultiplicityConstraint("http://www.w3.org/ns/odrl/2/or", (MultiplicityConstraint)orConstraint);
        }

        public JsonObject visitXoneConstraint(XoneConstraint xoneConstraint) {
            return this.visitMultiplicityConstraint("http://www.w3.org/ns/odrl/2/xone", (MultiplicityConstraint)xoneConstraint);
        }

        private JsonObject visitMultiplicityConstraint(String operandType, MultiplicityConstraint multiplicityConstraint) {
            JsonArrayBuilder constraintsBuilder = this.jsonFactory.createArrayBuilder();
            for (Constraint constraint : multiplicityConstraint.getConstraints()) {
                Optional.of(constraint).map(c -> (JsonObject)c.accept((Constraint.Visitor)this)).ifPresent(arg_0 -> ((JsonArrayBuilder)constraintsBuilder).add(arg_0));
            }
            return this.jsonFactory.createObjectBuilder().add(operandType, (JsonValue)constraintsBuilder.build()).build();
        }

        public JsonObject visitAtomicConstraint(AtomicConstraint atomicConstraint) {
            JsonObjectBuilder constraintBuilder = this.jsonFactory.createObjectBuilder();
            constraintBuilder.add("http://www.w3.org/ns/odrl/2/leftOperand", (JsonValue)atomicConstraint.getLeftExpression().accept((Expression.Visitor)this));
            String operator = atomicConstraint.getOperator().getOdrlRepresentation();
            constraintBuilder.add("http://www.w3.org/ns/odrl/2/operator", this.jsonFactory.createArrayBuilder().add(this.jsonFactory.createObjectBuilder().add("@id", operator)));
            constraintBuilder.add("http://www.w3.org/ns/odrl/2/rightOperand", (JsonValue)atomicConstraint.getRightExpression().accept((Expression.Visitor)this));
            return constraintBuilder.build();
        }

        public JsonObject visitLiteralExpression(LiteralExpression expression) {
            return this.jsonFactory.createObjectBuilder().add("@value", (JsonValue)Json.createValue((String)expression.getValue().toString())).build();
        }

        public JsonObject visitPolicy(Policy policy) {
            JsonArrayBuilder permissionsBuilder = this.jsonFactory.createArrayBuilder();
            policy.getPermissions().forEach(permission -> permissionsBuilder.add((JsonValue)permission.accept((Rule.Visitor)this)));
            JsonArrayBuilder prohibitionsBuilder = this.jsonFactory.createArrayBuilder();
            policy.getProhibitions().forEach(prohibition -> prohibitionsBuilder.add((JsonValue)prohibition.accept((Rule.Visitor)this)));
            JsonArrayBuilder obligationsBuilder = this.jsonFactory.createArrayBuilder();
            policy.getObligations().forEach(duty -> obligationsBuilder.add((JsonValue)duty.accept((Rule.Visitor)this)));
            JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder().add("@id", UUID.randomUUID().toString()).add("@type", this.getTypeAsString(policy.getType())).add("http://www.w3.org/ns/odrl/2/permission", permissionsBuilder).add("http://www.w3.org/ns/odrl/2/prohibition", prohibitionsBuilder).add("http://www.w3.org/ns/odrl/2/obligation", obligationsBuilder);
            Optional.ofNullable(policy.getAssignee()).map(arg_0 -> ((ParticipantIdMapper)this.participantIdMapper).toIri(arg_0)).ifPresent(target -> builder.add("http://www.w3.org/ns/odrl/2/assignee", this.jsonFactory.createArrayBuilder().add(this.jsonFactory.createObjectBuilder().add("@id", target))));
            Optional.ofNullable(policy.getAssigner()).map(arg_0 -> ((ParticipantIdMapper)this.participantIdMapper).toIri(arg_0)).ifPresent(target -> builder.add("http://www.w3.org/ns/odrl/2/assigner", this.jsonFactory.createArrayBuilder().add(this.jsonFactory.createObjectBuilder().add("@id", target))));
            Optional.ofNullable(policy.getTarget()).ifPresent(target -> builder.add("http://www.w3.org/ns/odrl/2/target", this.jsonFactory.createArrayBuilder().add(this.jsonFactory.createObjectBuilder().add("@id", target))));
            return builder.build();
        }

        public JsonObject visitPermission(Permission permission) {
            JsonObjectBuilder permissionBuilder = this.visitRule((Rule)permission);
            if (permission.getDuties() != null && !permission.getDuties().isEmpty()) {
                JsonArrayBuilder dutiesBuilder = this.jsonFactory.createArrayBuilder();
                for (Duty duty : permission.getDuties()) {
                    dutiesBuilder.add((JsonValue)this.visitDuty(duty));
                }
                permissionBuilder.add("http://www.w3.org/ns/odrl/2/duty", (JsonValue)dutiesBuilder.build());
            }
            return permissionBuilder.build();
        }

        public JsonObject visitProhibition(Prohibition prohibition) {
            JsonObjectBuilder prohibitionBuilder = this.visitRule((Rule)prohibition);
            return prohibitionBuilder.build();
        }

        public JsonObject visitDuty(Duty duty) {
            JsonObjectBuilder obligationBuilder = this.visitRule((Rule)duty);
            if (duty.getConsequence() != null) {
                JsonObject consequence = this.visitDuty(duty.getConsequence());
                obligationBuilder.add("http://www.w3.org/ns/odrl/2/consequence", (JsonValue)consequence);
            }
            return obligationBuilder.build();
        }

        private JsonObjectBuilder visitRule(Rule rule) {
            JsonObjectBuilder ruleBuilder = this.jsonFactory.createObjectBuilder();
            ruleBuilder.add("http://www.w3.org/ns/odrl/2/action", (JsonValue)this.visitAction(rule.getAction()));
            if (rule.getConstraints() != null && !rule.getConstraints().isEmpty()) {
                ruleBuilder.add("http://www.w3.org/ns/odrl/2/constraint", (JsonValue)this.visitConstraints(rule));
            }
            return ruleBuilder;
        }

        private JsonArray visitConstraints(Rule rule) {
            JsonArrayBuilder constraintsBuilder = this.jsonFactory.createArrayBuilder();
            for (Constraint constraint : rule.getConstraints()) {
                Optional.of(constraint).map(c -> (JsonObject)c.accept((Constraint.Visitor)this)).ifPresent(arg_0 -> ((JsonArrayBuilder)constraintsBuilder).add(arg_0));
            }
            return constraintsBuilder.build();
        }

        private JsonObject visitAction(@Nullable Action action) {
            JsonObjectBuilder actionBuilder = this.jsonFactory.createObjectBuilder();
            if (action == null) {
                return actionBuilder.build();
            }
            actionBuilder.add("http://www.w3.org/ns/odrl/2/type", action.getType());
            if (action.getIncludedIn() != null) {
                actionBuilder.add("http://www.w3.org/ns/odrl/2/includedIn", action.getIncludedIn());
            }
            if (action.getConstraint() != null) {
                actionBuilder.add("http://www.w3.org/ns/odrl/2/refinement", (JsonValue)action.getConstraint().accept((Constraint.Visitor)this));
            }
            return actionBuilder.build();
        }

        private String getTypeAsString(PolicyType type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case PolicyType.SET -> "http://www.w3.org/ns/odrl/2/Set";
                case PolicyType.OFFER -> "http://www.w3.org/ns/odrl/2/Offer";
                case PolicyType.CONTRACT -> "http://www.w3.org/ns/odrl/2/Agreement";
            };
        }
    }
}

