/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.transformer;

import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.domain.callback.CallbackAddress;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.eclipse.tractusx.irs.edc.client.model.TransferProcessRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromTransferProcessRequestTransformer
extends AbstractJsonLdTransformer<TransferProcessRequest, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromTransferProcessRequestTransformer(JsonBuilderFactory jsonFactory) {
        super(TransferProcessRequest.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull TransferProcessRequest dto, @NotNull TransformerContext context) {
        JsonObjectBuilder objectBuilder;
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder();
        builder.add("https://w3id.org/edc/v0.0.1/ns/assetId", dto.getAssetId()).add("https://w3id.org/edc/v0.0.1/ns/counterPartyAddress", dto.getCounterPartyAddress()).add("https://w3id.org/edc/v0.0.1/ns/contractId", dto.getContractId()).add("https://w3id.org/edc/v0.0.1/ns/dataDestination", (JsonValue)context.transform((Object)dto.getDataDestination(), JsonObject.class)).add("https://w3id.org/edc/v0.0.1/ns/protocol", dto.getProtocol()).add("https://w3id.org/edc/v0.0.1/ns/managedResources", dto.isManagedResources());
        Optional.ofNullable(dto.getConnectorId()).ifPresent(s -> builder.add("https://w3id.org/edc/v0.0.1/ns/connectorId", dto.getConnectorId()));
        Optional.ofNullable(dto.getTransferType()).ifPresent(s -> builder.add("https://w3id.org/edc/v0.0.1/ns/transferType", dto.getTransferType()));
        Optional.ofNullable(dto.getCallbackAddresses()).ifPresent(s -> builder.add("https://w3id.org/edc/v0.0.1/ns/callbackAddresses", this.asArray(dto.getCallbackAddresses(), context)));
        if (dto.getProperties() != null && !dto.getProperties().isEmpty()) {
            objectBuilder = this.jsonFactory.createObjectBuilder();
            dto.getProperties().forEach((s, s1) -> objectBuilder.add("https://w3id.org/edc/v0.0.1/ns/" + s, s1));
            builder.add("https://w3id.org/edc/v0.0.1/ns/properties", objectBuilder);
        }
        if (dto.getPrivateProperties() != null && !dto.getPrivateProperties().isEmpty()) {
            objectBuilder = this.jsonFactory.createObjectBuilder();
            dto.getPrivateProperties().forEach((s, s1) -> objectBuilder.add("https://w3id.org/edc/v0.0.1/ns/" + s, s1));
            builder.add("https://w3id.org/edc/v0.0.1/ns/privateProperties", objectBuilder);
        }
        return builder.build();
    }

    private JsonArrayBuilder asArray(List<CallbackAddress> callbackAddresses, TransformerContext context) {
        JsonArrayBuilder arrayBuilder = Objects.requireNonNull(this.jsonFactory.createArrayBuilder());
        callbackAddresses.stream().map(callbackAddress -> (JsonObject)context.transform(callbackAddress, JsonObject.class)).forEach(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
        return arrayBuilder;
    }
}

