/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.transformer;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import org.eclipse.edc.catalog.spi.Catalog;
import org.eclipse.edc.catalog.spi.DataService;
import org.eclipse.edc.catalog.spi.Dataset;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToCatalogTransformer
extends AbstractJsonLdTransformer<JsonObject, Catalog> {
    public JsonObjectToCatalogTransformer() {
        super(JsonObject.class, Catalog.class);
    }

    @Nullable
    public Catalog transform(@NotNull JsonObject object, @NotNull TransformerContext context) {
        Catalog.Builder builder = Catalog.Builder.newInstance();
        builder.id(this.nodeId((JsonValue)object));
        this.visitProperties(object, (key, value) -> this.transformProperties((String)key, (JsonValue)value, builder, context));
        return (Catalog)this.builderResult(() -> ((Catalog.Builder)builder).build(), context);
    }

    private void transformProperties(String key, JsonValue value, Catalog.Builder builder, TransformerContext context) {
        if ("http://www.w3.org/ns/dcat#dataset".equals(key)) {
            this.transformArrayOrObject(value, Dataset.class, arg_0 -> ((Catalog.Builder)builder).dataset(arg_0), context);
        } else if ("http://www.w3.org/ns/dcat#service".equals(key)) {
            this.transformArrayOrObject(value, DataService.class, arg_0 -> ((Catalog.Builder)builder).dataService(arg_0), context);
        } else {
            builder.property(key, this.transformGenericProperty(value, context));
        }
    }
}

