/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.transformer;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import org.eclipse.edc.catalog.spi.DataService;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToDataServiceTransformer
extends AbstractJsonLdTransformer<JsonObject, DataService> {
    public JsonObjectToDataServiceTransformer() {
        super(JsonObject.class, DataService.class);
    }

    @Nullable
    public DataService transform(@NotNull JsonObject object, @NotNull TransformerContext context) {
        DataService.Builder builder = DataService.Builder.newInstance();
        builder.id(this.nodeId((JsonValue)object));
        this.visitProperties(object, (key, value) -> this.transformProperties((String)key, (JsonValue)value, builder, context));
        return (DataService)this.builderResult(() -> ((DataService.Builder)builder).build(), context);
    }

    private void transformProperties(String key, JsonValue value, DataService.Builder builder, TransformerContext context) {
        if ("http://purl.org/dc/terms/terms".equals(key)) {
            this.transformString(value, arg_0 -> ((DataService.Builder)builder).terms(arg_0), context);
        } else if ("http://purl.org/dc/terms/endpointUrl".equals(key)) {
            this.transformString(value, arg_0 -> ((DataService.Builder)builder).endpointUrl(arg_0), context);
        }
    }
}

