/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.transformer;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import org.eclipse.edc.catalog.spi.Dataset;
import org.eclipse.edc.catalog.spi.Distribution;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.eclipse.edc.transform.spi.UnexpectedTypeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToDatasetTransformer
extends AbstractJsonLdTransformer<JsonObject, Dataset> {
    public JsonObjectToDatasetTransformer() {
        super(JsonObject.class, Dataset.class);
    }

    @Nullable
    public Dataset transform(@NotNull JsonObject object, @NotNull TransformerContext context) {
        Dataset.Builder builder = Dataset.Builder.newInstance();
        builder.id(this.nodeId((JsonValue)object));
        this.visitProperties(object, (key, value) -> this.transformProperties((String)key, (JsonValue)value, builder, context));
        return (Dataset)this.builderResult(() -> ((Dataset.Builder)builder).build(), context);
    }

    private void transformProperties(String key, JsonValue value, Dataset.Builder builder, TransformerContext context) {
        switch (key) {
            case "http://www.w3.org/ns/odrl/2/hasPolicy": {
                this.transformPolicies(value, builder, context);
                break;
            }
            case "http://www.w3.org/ns/dcat#distribution": {
                this.transformArrayOrObject(value, Distribution.class, arg_0 -> ((Dataset.Builder)builder).distribution(arg_0), context);
                break;
            }
            default: {
                builder.property(key, this.transformGenericProperty(value, context));
            }
        }
    }

    private void transformPolicies(JsonValue value, Dataset.Builder builder, TransformerContext context) {
        if (value instanceof JsonObject) {
            JsonObject object = (JsonObject)value;
            String offerId = this.nodeId((JsonValue)object);
            Policy policy = (Policy)context.transform((Object)object, Policy.class);
            builder.offer(offerId, policy);
        } else if (value instanceof JsonArray) {
            JsonArray array = (JsonArray)value;
            array.forEach(entry -> this.transformPolicies((JsonValue)entry, builder, context));
        } else {
            ((UnexpectedTypeBuilder)((UnexpectedTypeBuilder)context.problem().unexpectedType().type("http://www.w3.org/ns/dcat#Dataset")).property("http://www.w3.org/ns/odrl/2/hasPolicy")).actual(value == null ? "null" : value.getValueType().toString()).expected((Enum)JsonValue.ValueType.OBJECT).expected((Enum)JsonValue.ValueType.ARRAY).report();
        }
    }
}

