/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.transformer;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import org.eclipse.edc.catalog.spi.DataService;
import org.eclipse.edc.catalog.spi.Distribution;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToDistributionTransformer
extends AbstractJsonLdTransformer<JsonObject, Distribution> {
    public JsonObjectToDistributionTransformer() {
        super(JsonObject.class, Distribution.class);
    }

    @Nullable
    public Distribution transform(@NotNull JsonObject object, @NotNull TransformerContext context) {
        Distribution.Builder builder = Distribution.Builder.newInstance();
        this.visitProperties(object, (key, value) -> this.transformProperties((String)key, (JsonValue)value, builder, context));
        return (Distribution)this.builderResult(() -> ((Distribution.Builder)builder).build(), context);
    }

    private void transformProperties(String key, JsonValue value, Distribution.Builder builder, TransformerContext context) {
        if ("http://www.w3.org/ns/dcat#accessService".equals(key)) {
            DataService.Builder dataServiceBuilder = DataService.Builder.newInstance();
            this.transformString(value, arg_0 -> ((DataService.Builder)dataServiceBuilder).id(arg_0), context);
            builder.dataService(dataServiceBuilder.build());
        } else if ("http://purl.org/dc/terms/format".equals(key)) {
            this.transformString(value, arg_0 -> ((Distribution.Builder)builder).format(arg_0), context);
        }
    }
}

