/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.transformer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.JsonObject;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.eclipse.tractusx.irs.data.JsonParseException;
import org.eclipse.tractusx.irs.edc.client.policy.Policy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToIrsPolicyTransformer
extends AbstractJsonLdTransformer<JsonObject, Policy> {
    private final ObjectMapper objectMapper;

    protected JsonObjectToIrsPolicyTransformer(ObjectMapper objectMapper) {
        super(JsonObject.class, Policy.class);
        this.objectMapper = objectMapper;
    }

    @Nullable
    public Policy transform(@NotNull JsonObject jsonObject, @NotNull TransformerContext transformerContext) {
        Policy.PolicyBuilder builder = Policy.builder();
        builder.policyId(this.getId(jsonObject));
        this.visitProperties(jsonObject, key -> v -> {
            try {
                Object result = this.objectMapper.readerFor(Policy.class).readValue(v.asJsonObject().toString());
                builder.permissions(((Policy)result).getPermissions());
            }
            catch (JsonProcessingException | ClassCastException e) {
                throw new JsonParseException("Invalid policy", e);
            }
        });
        return builder.build();
    }

    private String getId(JsonObject jsonObject) {
        try {
            JsonNode jsonNode = this.objectMapper.readTree(jsonObject.toString());
            return jsonNode.path("@id").asText();
        }
        catch (JsonProcessingException e) {
            throw new JsonParseException((Throwable)e);
        }
    }
}

