/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.component;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.eclipse.tractusx.irs.component.enums.ProcessingState;

@Schema(description="BatchOrderAck Payload Response.", example="{\"batchChecksum\"=1, \"batches\"=[{\"batchId\"=\"f253718e-a270-4367-901b-9d50d9bd8462\", \"batchNumber\"=1, \"batchProcessingState\"=\"PARTIAL\", \"batchUrl\"=\"https://../irs/orders/f253718e-a270-4367-901b-9d50d9bd8462/batches/f253718e-a270-4367-901b-9d50d9bd8462\", \"jobsInBatchChecksum\"=1}], \"orderId\"=\"f253718e-a270-4367-901b-9d50d9bd8462\", \"state\"=\"COMPLETED\"}")
@JsonDeserialize(builder=BatchOrderResponseBuilder.class)
public final class BatchOrderResponse {
    public static final String EXAMPLE = "{\"batchChecksum\"=1, \"batches\"=[{\"batchId\"=\"f253718e-a270-4367-901b-9d50d9bd8462\", \"batchNumber\"=1, \"batchProcessingState\"=\"PARTIAL\", \"batchUrl\"=\"https://../irs/orders/f253718e-a270-4367-901b-9d50d9bd8462/batches/f253718e-a270-4367-901b-9d50d9bd8462\", \"jobsInBatchChecksum\"=1}], \"orderId\"=\"f253718e-a270-4367-901b-9d50d9bd8462\", \"state\"=\"COMPLETED\"}";
    private static final int UUID_LENGTH = 36;
    @Schema(description="Id of the order.", minLength=36, maxLength=36, implementation=UUID.class, pattern="/^[0-9a-f]{8}-[0-9a-f]{4}-[0-5][0-9a-f]{3}-[089ab][0-9a-f]{3}-[0-9a-f]{12}$/i")
    private final UUID orderId;
    @Schema(implementation=ProcessingState.class, description="The state of the order.")
    private final ProcessingState state;
    @Schema(implementation=Integer.class, description="Expected number of batches in order.")
    private final Integer batchChecksum;
    @ArraySchema(arraySchema=@Schema(description="Array of batches."), maxItems=0x7FFFFFFF)
    private final List<BatchResponse> batches;

    @Generated
    public static BatchOrderResponseBuilder builder() {
        return new BatchOrderResponseBuilder();
    }

    @Generated
    public UUID getOrderId() {
        return this.orderId;
    }

    @Generated
    public ProcessingState getState() {
        return this.state;
    }

    @Generated
    public Integer getBatchChecksum() {
        return this.batchChecksum;
    }

    @Generated
    public List<BatchResponse> getBatches() {
        return this.batches;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BatchOrderResponse)) {
            return false;
        }
        BatchOrderResponse other = (BatchOrderResponse)o;
        Integer this$batchChecksum = this.getBatchChecksum();
        Integer other$batchChecksum = other.getBatchChecksum();
        if (this$batchChecksum == null ? other$batchChecksum != null : !((Object)this$batchChecksum).equals(other$batchChecksum)) {
            return false;
        }
        UUID this$orderId = this.getOrderId();
        UUID other$orderId = other.getOrderId();
        if (this$orderId == null ? other$orderId != null : !((Object)this$orderId).equals(other$orderId)) {
            return false;
        }
        ProcessingState this$state = this.getState();
        ProcessingState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        List<BatchResponse> this$batches = this.getBatches();
        List<BatchResponse> other$batches = other.getBatches();
        return !(this$batches == null ? other$batches != null : !((Object)this$batches).equals(other$batches));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $batchChecksum = this.getBatchChecksum();
        result = result * 59 + ($batchChecksum == null ? 43 : ((Object)$batchChecksum).hashCode());
        UUID $orderId = this.getOrderId();
        result = result * 59 + ($orderId == null ? 43 : ((Object)$orderId).hashCode());
        ProcessingState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        List<BatchResponse> $batches = this.getBatches();
        result = result * 59 + ($batches == null ? 43 : ((Object)$batches).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BatchOrderResponse(orderId=" + String.valueOf(this.getOrderId()) + ", state=" + String.valueOf((Object)this.getState()) + ", batchChecksum=" + this.getBatchChecksum() + ", batches=" + String.valueOf(this.getBatches()) + ")";
    }

    @Generated
    public BatchOrderResponse(UUID orderId, ProcessingState state, Integer batchChecksum, List<BatchResponse> batches) {
        this.orderId = orderId;
        this.state = state;
        this.batchChecksum = batchChecksum;
        this.batches = batches;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class BatchOrderResponseBuilder {
        @Generated
        private UUID orderId;
        @Generated
        private ProcessingState state;
        @Generated
        private Integer batchChecksum;
        @Generated
        private List<BatchResponse> batches;

        @Generated
        BatchOrderResponseBuilder() {
        }

        @Generated
        public BatchOrderResponseBuilder orderId(UUID orderId) {
            this.orderId = orderId;
            return this;
        }

        @Generated
        public BatchOrderResponseBuilder state(ProcessingState state) {
            this.state = state;
            return this;
        }

        @Generated
        public BatchOrderResponseBuilder batchChecksum(Integer batchChecksum) {
            this.batchChecksum = batchChecksum;
            return this;
        }

        @Generated
        public BatchOrderResponseBuilder batches(List<BatchResponse> batches) {
            this.batches = batches;
            return this;
        }

        @Generated
        public BatchOrderResponse build() {
            return new BatchOrderResponse(this.orderId, this.state, this.batchChecksum, this.batches);
        }

        @Generated
        public String toString() {
            return "BatchOrderResponse.BatchOrderResponseBuilder(orderId=" + String.valueOf(this.orderId) + ", state=" + String.valueOf((Object)this.state) + ", batchChecksum=" + this.batchChecksum + ", batches=" + String.valueOf(this.batches) + ")";
        }
    }

    @Schema(description="Batch model.")
    @JsonDeserialize(builder=BatchResponseBuilder.class)
    public static final class BatchResponse {
        @Schema(description="Id of the batch.", minLength=36, maxLength=36, implementation=UUID.class, pattern="/^[0-9a-f]{8}-[0-9a-f]{4}-[0-5][0-9a-f]{3}-[089ab][0-9a-f]{3}-[0-9a-f]{12}$/i")
        private final UUID batchId;
        @Schema(implementation=Integer.class, description="Sequence of the current batch.")
        private final Integer batchNumber;
        @Schema(implementation=Integer.class, description="The expected amount of jobs in the batch..")
        private final Integer jobsInBatchChecksum;
        @Schema(implementation=String.class, description="Url pointing to batch result.")
        private final String batchUrl;
        @Schema(implementation=ProcessingState.class, description="The state of the batch.")
        private final ProcessingState batchProcessingState;
        private final Object error;

        @Generated
        public static BatchResponseBuilder builder() {
            return new BatchResponseBuilder();
        }

        @Generated
        public UUID getBatchId() {
            return this.batchId;
        }

        @Generated
        public Integer getBatchNumber() {
            return this.batchNumber;
        }

        @Generated
        public Integer getJobsInBatchChecksum() {
            return this.jobsInBatchChecksum;
        }

        @Generated
        public String getBatchUrl() {
            return this.batchUrl;
        }

        @Generated
        public ProcessingState getBatchProcessingState() {
            return this.batchProcessingState;
        }

        @Generated
        public Object getError() {
            return this.error;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BatchResponse)) {
                return false;
            }
            BatchResponse other = (BatchResponse)o;
            Integer this$batchNumber = this.getBatchNumber();
            Integer other$batchNumber = other.getBatchNumber();
            if (this$batchNumber == null ? other$batchNumber != null : !((Object)this$batchNumber).equals(other$batchNumber)) {
                return false;
            }
            Integer this$jobsInBatchChecksum = this.getJobsInBatchChecksum();
            Integer other$jobsInBatchChecksum = other.getJobsInBatchChecksum();
            if (this$jobsInBatchChecksum == null ? other$jobsInBatchChecksum != null : !((Object)this$jobsInBatchChecksum).equals(other$jobsInBatchChecksum)) {
                return false;
            }
            UUID this$batchId = this.getBatchId();
            UUID other$batchId = other.getBatchId();
            if (this$batchId == null ? other$batchId != null : !((Object)this$batchId).equals(other$batchId)) {
                return false;
            }
            String this$batchUrl = this.getBatchUrl();
            String other$batchUrl = other.getBatchUrl();
            if (this$batchUrl == null ? other$batchUrl != null : !this$batchUrl.equals(other$batchUrl)) {
                return false;
            }
            ProcessingState this$batchProcessingState = this.getBatchProcessingState();
            ProcessingState other$batchProcessingState = other.getBatchProcessingState();
            if (this$batchProcessingState == null ? other$batchProcessingState != null : !((Object)((Object)this$batchProcessingState)).equals((Object)other$batchProcessingState)) {
                return false;
            }
            Object this$error = this.getError();
            Object other$error = other.getError();
            return !(this$error == null ? other$error != null : !this$error.equals(other$error));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $batchNumber = this.getBatchNumber();
            result = result * 59 + ($batchNumber == null ? 43 : ((Object)$batchNumber).hashCode());
            Integer $jobsInBatchChecksum = this.getJobsInBatchChecksum();
            result = result * 59 + ($jobsInBatchChecksum == null ? 43 : ((Object)$jobsInBatchChecksum).hashCode());
            UUID $batchId = this.getBatchId();
            result = result * 59 + ($batchId == null ? 43 : ((Object)$batchId).hashCode());
            String $batchUrl = this.getBatchUrl();
            result = result * 59 + ($batchUrl == null ? 43 : $batchUrl.hashCode());
            ProcessingState $batchProcessingState = this.getBatchProcessingState();
            result = result * 59 + ($batchProcessingState == null ? 43 : ((Object)((Object)$batchProcessingState)).hashCode());
            Object $error = this.getError();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BatchOrderResponse.BatchResponse(batchId=" + String.valueOf(this.getBatchId()) + ", batchNumber=" + this.getBatchNumber() + ", jobsInBatchChecksum=" + this.getJobsInBatchChecksum() + ", batchUrl=" + this.getBatchUrl() + ", batchProcessingState=" + String.valueOf((Object)this.getBatchProcessingState()) + ", error=" + String.valueOf(this.getError()) + ")";
        }

        @Generated
        public BatchResponse(UUID batchId, Integer batchNumber, Integer jobsInBatchChecksum, String batchUrl, ProcessingState batchProcessingState, Object error) {
            this.batchId = batchId;
            this.batchNumber = batchNumber;
            this.jobsInBatchChecksum = jobsInBatchChecksum;
            this.batchUrl = batchUrl;
            this.batchProcessingState = batchProcessingState;
            this.error = error;
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class BatchResponseBuilder {
            @Generated
            private UUID batchId;
            @Generated
            private Integer batchNumber;
            @Generated
            private Integer jobsInBatchChecksum;
            @Generated
            private String batchUrl;
            @Generated
            private ProcessingState batchProcessingState;
            @Generated
            private Object error;

            @Generated
            BatchResponseBuilder() {
            }

            @Generated
            public BatchResponseBuilder batchId(UUID batchId) {
                this.batchId = batchId;
                return this;
            }

            @Generated
            public BatchResponseBuilder batchNumber(Integer batchNumber) {
                this.batchNumber = batchNumber;
                return this;
            }

            @Generated
            public BatchResponseBuilder jobsInBatchChecksum(Integer jobsInBatchChecksum) {
                this.jobsInBatchChecksum = jobsInBatchChecksum;
                return this;
            }

            @Generated
            public BatchResponseBuilder batchUrl(String batchUrl) {
                this.batchUrl = batchUrl;
                return this;
            }

            @Generated
            public BatchResponseBuilder batchProcessingState(ProcessingState batchProcessingState) {
                this.batchProcessingState = batchProcessingState;
                return this;
            }

            @Generated
            public BatchResponseBuilder error(Object error) {
                this.error = error;
                return this;
            }

            @Generated
            public BatchResponse build() {
                return new BatchResponse(this.batchId, this.batchNumber, this.jobsInBatchChecksum, this.batchUrl, this.batchProcessingState, this.error);
            }

            @Generated
            public String toString() {
                return "BatchOrderResponse.BatchResponse.BatchResponseBuilder(batchId=" + String.valueOf(this.batchId) + ", batchNumber=" + this.batchNumber + ", jobsInBatchChecksum=" + this.jobsInBatchChecksum + ", batchUrl=" + this.batchUrl + ", batchProcessingState=" + String.valueOf((Object)this.batchProcessingState) + ", error=" + String.valueOf(this.error) + ")";
            }
        }
    }
}

