/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.component;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.eclipse.tractusx.irs.component.JobStatusResult;
import org.eclipse.tractusx.irs.component.enums.ProcessingState;

@Schema(description="Batch model.", example="{\"batchId\"=\"f253718e-a270-4367-901b-9d50d9bd8462\", \"batchNumber\"=1, \"batchProcessingState\"=\"COMPLETED\", \"batchTotal\"=1, \"completedOn\"=\"2022-02-03T14:48:54.709Z\", \"jobs\"=[{\"completedOn\"=\"2022-02-03T14:48:54.709Z\", \"id\"=\"6c311d29-5753-46d4-b32c-19b918ea93b0\", \"startedOn\"=\"2022-02-03T14:48:54.709Z\", \"state\"=\"COMPLETED\"}], \"jobsInBatchChecksum\"=1, \"orderId\"=\"f253718e-a270-4367-901b-9d50d9bd8462\", \"startedOn\"=\"2022-02-03T14:48:54.709Z\", \"totalJobs\"=1}")
@JsonDeserialize(builder=BatchResponseBuilder.class)
public final class BatchResponse {
    private static final int UUID_LENGTH = 36;
    public static final String EXAMPLE = "{\"batchId\"=\"f253718e-a270-4367-901b-9d50d9bd8462\", \"batchNumber\"=1, \"batchProcessingState\"=\"COMPLETED\", \"batchTotal\"=1, \"completedOn\"=\"2022-02-03T14:48:54.709Z\", \"jobs\"=[{\"completedOn\"=\"2022-02-03T14:48:54.709Z\", \"id\"=\"6c311d29-5753-46d4-b32c-19b918ea93b0\", \"startedOn\"=\"2022-02-03T14:48:54.709Z\", \"state\"=\"COMPLETED\"}], \"jobsInBatchChecksum\"=1, \"orderId\"=\"f253718e-a270-4367-901b-9d50d9bd8462\", \"startedOn\"=\"2022-02-03T14:48:54.709Z\", \"totalJobs\"=1}";
    @Schema(description="Id of the order.", minLength=36, maxLength=36, implementation=UUID.class, pattern="/^[0-9a-f]{8}-[0-9a-f]{4}-[0-5][0-9a-f]{3}-[089ab][0-9a-f]{3}-[0-9a-f]{12}$/i")
    private final UUID orderId;
    @Schema(description="Id of the batch.", minLength=36, maxLength=36, implementation=UUID.class, pattern="/^[0-9a-f]{8}-[0-9a-f]{4}-[0-5][0-9a-f]{3}-[089ab][0-9a-f]{3}-[0-9a-f]{12}$/i")
    private final UUID batchId;
    @Schema(implementation=Integer.class, description="Sequential number begins with first (1.) batch.")
    private final Integer batchNumber;
    @Schema(implementation=Integer.class, description="The total number of batches.")
    private final Integer batchTotal;
    @Schema(implementation=Integer.class, description="Total amount of jobs inside the order.")
    private final Integer totalJobs;
    @Schema(implementation=ZonedDateTime.class)
    private final ZonedDateTime startedOn;
    @Schema(implementation=ZonedDateTime.class)
    private final ZonedDateTime completedOn;
    @ArraySchema(arraySchema=@Schema(description="Array of jobs."), maxItems=0x7FFFFFFF)
    private final List<JobStatusResult> jobs;
    @Schema(implementation=Integer.class, description="Expected number of jobs in batch.")
    private final Integer jobsInBatchChecksum;
    @Schema(implementation=ProcessingState.class, description="The state of the batch.")
    private final ProcessingState batchProcessingState;

    @Generated
    public static BatchResponseBuilder builder() {
        return new BatchResponseBuilder();
    }

    @Generated
    public UUID getOrderId() {
        return this.orderId;
    }

    @Generated
    public UUID getBatchId() {
        return this.batchId;
    }

    @Generated
    public Integer getBatchNumber() {
        return this.batchNumber;
    }

    @Generated
    public Integer getBatchTotal() {
        return this.batchTotal;
    }

    @Generated
    public Integer getTotalJobs() {
        return this.totalJobs;
    }

    @Generated
    public ZonedDateTime getStartedOn() {
        return this.startedOn;
    }

    @Generated
    public ZonedDateTime getCompletedOn() {
        return this.completedOn;
    }

    @Generated
    public List<JobStatusResult> getJobs() {
        return this.jobs;
    }

    @Generated
    public Integer getJobsInBatchChecksum() {
        return this.jobsInBatchChecksum;
    }

    @Generated
    public ProcessingState getBatchProcessingState() {
        return this.batchProcessingState;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BatchResponse)) {
            return false;
        }
        BatchResponse other = (BatchResponse)o;
        Integer this$batchNumber = this.getBatchNumber();
        Integer other$batchNumber = other.getBatchNumber();
        if (this$batchNumber == null ? other$batchNumber != null : !((Object)this$batchNumber).equals(other$batchNumber)) {
            return false;
        }
        Integer this$batchTotal = this.getBatchTotal();
        Integer other$batchTotal = other.getBatchTotal();
        if (this$batchTotal == null ? other$batchTotal != null : !((Object)this$batchTotal).equals(other$batchTotal)) {
            return false;
        }
        Integer this$totalJobs = this.getTotalJobs();
        Integer other$totalJobs = other.getTotalJobs();
        if (this$totalJobs == null ? other$totalJobs != null : !((Object)this$totalJobs).equals(other$totalJobs)) {
            return false;
        }
        Integer this$jobsInBatchChecksum = this.getJobsInBatchChecksum();
        Integer other$jobsInBatchChecksum = other.getJobsInBatchChecksum();
        if (this$jobsInBatchChecksum == null ? other$jobsInBatchChecksum != null : !((Object)this$jobsInBatchChecksum).equals(other$jobsInBatchChecksum)) {
            return false;
        }
        UUID this$orderId = this.getOrderId();
        UUID other$orderId = other.getOrderId();
        if (this$orderId == null ? other$orderId != null : !((Object)this$orderId).equals(other$orderId)) {
            return false;
        }
        UUID this$batchId = this.getBatchId();
        UUID other$batchId = other.getBatchId();
        if (this$batchId == null ? other$batchId != null : !((Object)this$batchId).equals(other$batchId)) {
            return false;
        }
        ZonedDateTime this$startedOn = this.getStartedOn();
        ZonedDateTime other$startedOn = other.getStartedOn();
        if (this$startedOn == null ? other$startedOn != null : !((Object)this$startedOn).equals(other$startedOn)) {
            return false;
        }
        ZonedDateTime this$completedOn = this.getCompletedOn();
        ZonedDateTime other$completedOn = other.getCompletedOn();
        if (this$completedOn == null ? other$completedOn != null : !((Object)this$completedOn).equals(other$completedOn)) {
            return false;
        }
        List<JobStatusResult> this$jobs = this.getJobs();
        List<JobStatusResult> other$jobs = other.getJobs();
        if (this$jobs == null ? other$jobs != null : !((Object)this$jobs).equals(other$jobs)) {
            return false;
        }
        ProcessingState this$batchProcessingState = this.getBatchProcessingState();
        ProcessingState other$batchProcessingState = other.getBatchProcessingState();
        return !(this$batchProcessingState == null ? other$batchProcessingState != null : !((Object)((Object)this$batchProcessingState)).equals((Object)other$batchProcessingState));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $batchNumber = this.getBatchNumber();
        result = result * 59 + ($batchNumber == null ? 43 : ((Object)$batchNumber).hashCode());
        Integer $batchTotal = this.getBatchTotal();
        result = result * 59 + ($batchTotal == null ? 43 : ((Object)$batchTotal).hashCode());
        Integer $totalJobs = this.getTotalJobs();
        result = result * 59 + ($totalJobs == null ? 43 : ((Object)$totalJobs).hashCode());
        Integer $jobsInBatchChecksum = this.getJobsInBatchChecksum();
        result = result * 59 + ($jobsInBatchChecksum == null ? 43 : ((Object)$jobsInBatchChecksum).hashCode());
        UUID $orderId = this.getOrderId();
        result = result * 59 + ($orderId == null ? 43 : ((Object)$orderId).hashCode());
        UUID $batchId = this.getBatchId();
        result = result * 59 + ($batchId == null ? 43 : ((Object)$batchId).hashCode());
        ZonedDateTime $startedOn = this.getStartedOn();
        result = result * 59 + ($startedOn == null ? 43 : ((Object)$startedOn).hashCode());
        ZonedDateTime $completedOn = this.getCompletedOn();
        result = result * 59 + ($completedOn == null ? 43 : ((Object)$completedOn).hashCode());
        List<JobStatusResult> $jobs = this.getJobs();
        result = result * 59 + ($jobs == null ? 43 : ((Object)$jobs).hashCode());
        ProcessingState $batchProcessingState = this.getBatchProcessingState();
        result = result * 59 + ($batchProcessingState == null ? 43 : ((Object)((Object)$batchProcessingState)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BatchResponse(orderId=" + String.valueOf(this.getOrderId()) + ", batchId=" + String.valueOf(this.getBatchId()) + ", batchNumber=" + this.getBatchNumber() + ", batchTotal=" + this.getBatchTotal() + ", totalJobs=" + this.getTotalJobs() + ", startedOn=" + String.valueOf(this.getStartedOn()) + ", completedOn=" + String.valueOf(this.getCompletedOn()) + ", jobs=" + String.valueOf(this.getJobs()) + ", jobsInBatchChecksum=" + this.getJobsInBatchChecksum() + ", batchProcessingState=" + String.valueOf((Object)this.getBatchProcessingState()) + ")";
    }

    @Generated
    public BatchResponse(UUID orderId, UUID batchId, Integer batchNumber, Integer batchTotal, Integer totalJobs, ZonedDateTime startedOn, ZonedDateTime completedOn, List<JobStatusResult> jobs, Integer jobsInBatchChecksum, ProcessingState batchProcessingState) {
        this.orderId = orderId;
        this.batchId = batchId;
        this.batchNumber = batchNumber;
        this.batchTotal = batchTotal;
        this.totalJobs = totalJobs;
        this.startedOn = startedOn;
        this.completedOn = completedOn;
        this.jobs = jobs;
        this.jobsInBatchChecksum = jobsInBatchChecksum;
        this.batchProcessingState = batchProcessingState;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class BatchResponseBuilder {
        @Generated
        private UUID orderId;
        @Generated
        private UUID batchId;
        @Generated
        private Integer batchNumber;
        @Generated
        private Integer batchTotal;
        @Generated
        private Integer totalJobs;
        @Generated
        private ZonedDateTime startedOn;
        @Generated
        private ZonedDateTime completedOn;
        @Generated
        private List<JobStatusResult> jobs;
        @Generated
        private Integer jobsInBatchChecksum;
        @Generated
        private ProcessingState batchProcessingState;

        @Generated
        BatchResponseBuilder() {
        }

        @Generated
        public BatchResponseBuilder orderId(UUID orderId) {
            this.orderId = orderId;
            return this;
        }

        @Generated
        public BatchResponseBuilder batchId(UUID batchId) {
            this.batchId = batchId;
            return this;
        }

        @Generated
        public BatchResponseBuilder batchNumber(Integer batchNumber) {
            this.batchNumber = batchNumber;
            return this;
        }

        @Generated
        public BatchResponseBuilder batchTotal(Integer batchTotal) {
            this.batchTotal = batchTotal;
            return this;
        }

        @Generated
        public BatchResponseBuilder totalJobs(Integer totalJobs) {
            this.totalJobs = totalJobs;
            return this;
        }

        @Generated
        public BatchResponseBuilder startedOn(ZonedDateTime startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        @Generated
        public BatchResponseBuilder completedOn(ZonedDateTime completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        @Generated
        public BatchResponseBuilder jobs(List<JobStatusResult> jobs) {
            this.jobs = jobs;
            return this;
        }

        @Generated
        public BatchResponseBuilder jobsInBatchChecksum(Integer jobsInBatchChecksum) {
            this.jobsInBatchChecksum = jobsInBatchChecksum;
            return this;
        }

        @Generated
        public BatchResponseBuilder batchProcessingState(ProcessingState batchProcessingState) {
            this.batchProcessingState = batchProcessingState;
            return this;
        }

        @Generated
        public BatchResponse build() {
            return new BatchResponse(this.orderId, this.batchId, this.batchNumber, this.batchTotal, this.totalJobs, this.startedOn, this.completedOn, this.jobs, this.jobsInBatchChecksum, this.batchProcessingState);
        }

        @Generated
        public String toString() {
            return "BatchResponse.BatchResponseBuilder(orderId=" + String.valueOf(this.orderId) + ", batchId=" + String.valueOf(this.batchId) + ", batchNumber=" + this.batchNumber + ", batchTotal=" + this.batchTotal + ", totalJobs=" + this.totalJobs + ", startedOn=" + String.valueOf(this.startedOn) + ", completedOn=" + String.valueOf(this.completedOn) + ", jobs=" + String.valueOf(this.jobs) + ", jobsInBatchChecksum=" + this.jobsInBatchChecksum + ", batchProcessingState=" + String.valueOf((Object)this.batchProcessingState) + ")";
        }
    }
}

