/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.component;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.eclipse.tractusx.irs.component.RegisterJob;
import org.eclipse.tractusx.irs.component.enums.BomLifecycle;
import org.eclipse.tractusx.irs.component.enums.Direction;

@Schema(description="Job parameter of job processing.")
@JsonDeserialize(builder=JobParameterBuilder.class)
public final class JobParameter {
    @Schema(implementation=BomLifecycle.class, example="asBuilt")
    private final BomLifecycle bomLifecycle;
    @Schema(implementation=String.class, example="SerialPart")
    private final List<String> aspects;
    @Schema(implementation=Integer.class, example="1")
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    private final @Min(value=0L) @Max(value=0x7FFFFFFFL) Integer depth;
    @Schema(implementation=String.class, example="BPNL00000003AYRE")
    private final String bpn;
    @Schema(implementation=Direction.class, example="upward")
    private final Direction direction;
    @Schema(implementation=Boolean.class, example="false")
    private final boolean collectAspects;
    @Schema(implementation=Boolean.class, example="false")
    private final boolean lookupBPNs;
    @Schema(implementation=Boolean.class, example="false")
    private final boolean auditContractNegotiation;
    @Schema(implementation=String.class, example="https://hostname.com/callback?id={id}&state={state}")
    private final String callbackUrl;

    public static JobParameter create(@NonNull RegisterJob request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        BomLifecycle bomLifecycle = Optional.ofNullable(request.getBomLifecycle()).orElse(BomLifecycle.AS_BUILT);
        List aspectTypeValues = Optional.ofNullable(request.getAspects()).orElse(List.of());
        Direction direction = Optional.ofNullable(request.getDirection()).orElse(Direction.DOWNWARD);
        return JobParameter.builder().depth(request.getDepth()).bomLifecycle(bomLifecycle).bpn(request.getKey().getBpn()).direction(direction).aspects(aspectTypeValues.isEmpty() ? List.of() : aspectTypeValues).collectAspects(request.isCollectAspects()).lookupBPNs(request.isLookupBPNs()).auditContractNegotiation(request.isAuditContractNegotiation()).callbackUrl(request.getCallbackUrl()).build();
    }

    @Generated
    public static JobParameterBuilder builder() {
        return new JobParameterBuilder();
    }

    @Generated
    public JobParameterBuilder toBuilder() {
        JobParameterBuilder builder = new JobParameterBuilder().bomLifecycle(this.bomLifecycle).depth(this.depth).bpn(this.bpn).direction(this.direction).collectAspects(this.collectAspects).lookupBPNs(this.lookupBPNs).auditContractNegotiation(this.auditContractNegotiation).callbackUrl(this.callbackUrl);
        if (this.aspects != null) {
            builder.aspects(this.aspects);
        }
        return builder;
    }

    @Generated
    public BomLifecycle getBomLifecycle() {
        return this.bomLifecycle;
    }

    @Generated
    public List<String> getAspects() {
        return this.aspects;
    }

    @Generated
    public Integer getDepth() {
        return this.depth;
    }

    @Generated
    public String getBpn() {
        return this.bpn;
    }

    @Generated
    public Direction getDirection() {
        return this.direction;
    }

    @Generated
    public boolean isCollectAspects() {
        return this.collectAspects;
    }

    @Generated
    public boolean isLookupBPNs() {
        return this.lookupBPNs;
    }

    @Generated
    public boolean isAuditContractNegotiation() {
        return this.auditContractNegotiation;
    }

    @Generated
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobParameter)) {
            return false;
        }
        JobParameter other = (JobParameter)o;
        if (this.isCollectAspects() != other.isCollectAspects()) {
            return false;
        }
        if (this.isLookupBPNs() != other.isLookupBPNs()) {
            return false;
        }
        if (this.isAuditContractNegotiation() != other.isAuditContractNegotiation()) {
            return false;
        }
        Integer this$depth = this.getDepth();
        Integer other$depth = other.getDepth();
        if (this$depth == null ? other$depth != null : !((Object)this$depth).equals(other$depth)) {
            return false;
        }
        BomLifecycle this$bomLifecycle = this.getBomLifecycle();
        BomLifecycle other$bomLifecycle = other.getBomLifecycle();
        if (this$bomLifecycle == null ? other$bomLifecycle != null : !((Object)((Object)this$bomLifecycle)).equals((Object)other$bomLifecycle)) {
            return false;
        }
        List<String> this$aspects = this.getAspects();
        List<String> other$aspects = other.getAspects();
        if (this$aspects == null ? other$aspects != null : !((Object)this$aspects).equals(other$aspects)) {
            return false;
        }
        String this$bpn = this.getBpn();
        String other$bpn = other.getBpn();
        if (this$bpn == null ? other$bpn != null : !this$bpn.equals(other$bpn)) {
            return false;
        }
        Direction this$direction = this.getDirection();
        Direction other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !((Object)((Object)this$direction)).equals((Object)other$direction)) {
            return false;
        }
        String this$callbackUrl = this.getCallbackUrl();
        String other$callbackUrl = other.getCallbackUrl();
        return !(this$callbackUrl == null ? other$callbackUrl != null : !this$callbackUrl.equals(other$callbackUrl));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCollectAspects() ? 79 : 97);
        result = result * 59 + (this.isLookupBPNs() ? 79 : 97);
        result = result * 59 + (this.isAuditContractNegotiation() ? 79 : 97);
        Integer $depth = this.getDepth();
        result = result * 59 + ($depth == null ? 43 : ((Object)$depth).hashCode());
        BomLifecycle $bomLifecycle = this.getBomLifecycle();
        result = result * 59 + ($bomLifecycle == null ? 43 : ((Object)((Object)$bomLifecycle)).hashCode());
        List<String> $aspects = this.getAspects();
        result = result * 59 + ($aspects == null ? 43 : ((Object)$aspects).hashCode());
        String $bpn = this.getBpn();
        result = result * 59 + ($bpn == null ? 43 : $bpn.hashCode());
        Direction $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : ((Object)((Object)$direction)).hashCode());
        String $callbackUrl = this.getCallbackUrl();
        result = result * 59 + ($callbackUrl == null ? 43 : $callbackUrl.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JobParameter(bomLifecycle=" + String.valueOf((Object)this.getBomLifecycle()) + ", aspects=" + String.valueOf(this.getAspects()) + ", depth=" + this.getDepth() + ", bpn=" + this.getBpn() + ", direction=" + String.valueOf((Object)this.getDirection()) + ", collectAspects=" + this.isCollectAspects() + ", lookupBPNs=" + this.isLookupBPNs() + ", auditContractNegotiation=" + this.isAuditContractNegotiation() + ", callbackUrl=" + this.getCallbackUrl() + ")";
    }

    @Generated
    public JobParameter(BomLifecycle bomLifecycle, List<String> aspects, Integer depth, String bpn, Direction direction, boolean collectAspects, boolean lookupBPNs, boolean auditContractNegotiation, String callbackUrl) {
        this.bomLifecycle = bomLifecycle;
        this.aspects = aspects;
        this.depth = depth;
        this.bpn = bpn;
        this.direction = direction;
        this.collectAspects = collectAspects;
        this.lookupBPNs = lookupBPNs;
        this.auditContractNegotiation = auditContractNegotiation;
        this.callbackUrl = callbackUrl;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class JobParameterBuilder {
        @Generated
        private BomLifecycle bomLifecycle;
        @Generated
        private ArrayList<String> aspects;
        @Generated
        private Integer depth;
        @Generated
        private String bpn;
        @Generated
        private Direction direction;
        @Generated
        private boolean collectAspects;
        @Generated
        private boolean lookupBPNs;
        @Generated
        private boolean auditContractNegotiation;
        @Generated
        private String callbackUrl;

        @Generated
        JobParameterBuilder() {
        }

        @Generated
        public JobParameterBuilder bomLifecycle(BomLifecycle bomLifecycle) {
            this.bomLifecycle = bomLifecycle;
            return this;
        }

        @Generated
        public JobParameterBuilder aspect(String aspect) {
            if (this.aspects == null) {
                this.aspects = new ArrayList();
            }
            this.aspects.add(aspect);
            return this;
        }

        @Generated
        public JobParameterBuilder aspects(Collection<? extends String> aspects) {
            if (aspects == null) {
                throw new NullPointerException("aspects cannot be null");
            }
            if (this.aspects == null) {
                this.aspects = new ArrayList();
            }
            this.aspects.addAll(aspects);
            return this;
        }

        @Generated
        public JobParameterBuilder clearAspects() {
            if (this.aspects != null) {
                this.aspects.clear();
            }
            return this;
        }

        @Generated
        public JobParameterBuilder depth(Integer depth) {
            this.depth = depth;
            return this;
        }

        @Generated
        public JobParameterBuilder bpn(String bpn) {
            this.bpn = bpn;
            return this;
        }

        @Generated
        public JobParameterBuilder direction(Direction direction) {
            this.direction = direction;
            return this;
        }

        @Generated
        public JobParameterBuilder collectAspects(boolean collectAspects) {
            this.collectAspects = collectAspects;
            return this;
        }

        @Generated
        public JobParameterBuilder lookupBPNs(boolean lookupBPNs) {
            this.lookupBPNs = lookupBPNs;
            return this;
        }

        @Generated
        public JobParameterBuilder auditContractNegotiation(boolean auditContractNegotiation) {
            this.auditContractNegotiation = auditContractNegotiation;
            return this;
        }

        @Generated
        public JobParameterBuilder callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        @Generated
        public JobParameter build() {
            return new JobParameter(this.bomLifecycle, switch (this.aspects == null ? 0 : this.aspects.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.aspects.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(this.aspects));
            }, this.depth, this.bpn, this.direction, this.collectAspects, this.lookupBPNs, this.auditContractNegotiation, this.callbackUrl);
        }

        @Generated
        public String toString() {
            return "JobParameter.JobParameterBuilder(bomLifecycle=" + String.valueOf((Object)this.bomLifecycle) + ", aspects=" + String.valueOf(this.aspects) + ", depth=" + this.depth + ", bpn=" + this.bpn + ", direction=" + String.valueOf((Object)this.direction) + ", collectAspects=" + this.collectAspects + ", lookupBPNs=" + this.lookupBPNs + ", auditContractNegotiation=" + this.auditContractNegotiation + ", callbackUrl=" + this.callbackUrl + ")";
        }
    }
}

