/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.component;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.eclipse.tractusx.irs.component.Bpn;
import org.eclipse.tractusx.irs.component.Job;
import org.eclipse.tractusx.irs.component.Relationship;
import org.eclipse.tractusx.irs.component.Shell;
import org.eclipse.tractusx.irs.component.Submodel;
import org.eclipse.tractusx.irs.component.Tombstone;

@Schema(description="Container for a job with item graph.", example="{\"bpns\"=[{\"manufacturerId\"=\"BPNL00000003AAXX\", \"manufacturerName\"=\"AB CD\"}], \"job\"={\"completedOn\"=\"2022-02-03T14:48:54.709Z\", \"createdOn\"=\"2022-02-03T14:48:54.709Z\", \"exception\"={\"errorDetail\"=\"Timeout while requesting Digital Registry\", \"exception\"=\"IrsTimeoutException\", \"exceptionDate\"=\"2022-02-03T14:48:54.709Z\"}, \"globalAssetId\"=\"urn:uuid:6c311d29-5753-46d4-b32c-19b918ea93b0\", \"id\"=\"e5347c88-a921-11ec-b909-0242ac120002\", \"lastModifiedOn\"=\"2022-02-03T14:48:54.709Z\", \"parameter\"={\"aspects\"=[\"SerialPart\", \"AddressAspect\"], \"auditContractNegotiation\"=false, \"bomLifecycle\"=\"asBuilt\", \"collectAspects\"=false, \"depth\"=1, \"direction\"=\"downward\", \"lookupBPNs\"=false}, \"startedOn\"=\"2022-02-03T14:48:54.709Z\", \"state\"=\"COMPLETED\", \"summary\"={\"asyncFetchedItems\"={\"completed\"=3, \"failed\"=0, \"running\"=0}}}, \"relationships\"=[{\"catenaXId\"=\"urn:uuid:d9bec1c6-e47c-4d18-ba41-0a5fe8b7f447\", \"linkedItem\"={\"assembledOn\"=\"2022-02-03T14:48:54.709Z\", \"childCatenaXId\"=\"urn:uuid:a45a2246-f6e1-42da-b47d-5c3b58ed62e9\", \"hasAlternatives\"=false, \"lastModifiedOn\"=\"2022-02-03T14:48:54.709Z\", \"lifecycleContext\"=\"asBuilt\", \"quantity\"={\"measurementUnit\"={\"datatypeURI\"=\"urn:bamm:io.openmanufacturing:meta-model:1.0.0#piece\", \"lexicalValue\"=\"piece\"}, \"quantityNumber\"=1}}}], \"shells\"=[{\"contractAgreementId\"=\"f253718e-a270-4367-901b-9d50d9bd8462\", \"payload\"={\"description\"=[{\"language\"=\"en\", \"text\"=\"The shell for a vehicle\"}], \"globalAssetId\"=\"urn:uuid:a45a2246-f6e1-42da-b47d-5c3b58ed62e9\", \"id\"=\"urn:uuid:882fc530-b69b-4707-95f6-5dbc5e9baaa8\", \"idShort\"=\"future concept x\", \"specificAssetIds\"=[{\"name\"=\"engineserialid\", \"value\"=\"12309481209312\"}], \"submodelDescriptors\"=[{\"description\"=[{\"language\"=\"en\", \"text\"=\"Provides base vehicle information\"}], \"endpoints\"=[{\"interface\"=\"HTTP\", \"protocolInformation\"={\"endpointProtocol\"=\"HTTPS\", \"endpointProtocolVersion\"=[\"1.0\"], \"href\"=\"https://catena-x.net/vehicle/basedetails/\", \"subprotocol\"=\"DSP\", \"subprotocolBody\"=\"id=urn:uuid:c8159379-4613-48b8-ad52-6baed7afe923;dspEndpoint=https://irs-provider-controlplane3.dev.demo.catena-x.net\", \"subprotocolBodyEncoding\"=\"plain\"}}], \"id\"=\"urn:uuid:5d25a897-6571-4800-b98c-a3352fbf996d\", \"idShort\"=\"SingleLevelBomAsPlanned\", \"semanticId\"={\"keys\"=[{\"type\"=\"ExternalReference\", \"value\"=\"urn:bamm:io.catenax.single_level_bom_as_planned:2.0.0#SingleLevelBomAsPlanned\"}], \"type\"=\"ModelReference\"}},\n    {\"description\"=[{\"language\"=\"en\", \"text\"=\"Provides base vehicle information\"}], \"endpoints\"=[{\"interface\"=\"HTTP\", \"protocolInformation\"={\"endpointProtocol\"=\"HTTPS\", \"endpointProtocolVersion\"=[\"1.0\"], \"href\"=\"https://catena-x.net/vehicle/partdetails/\", \"subprotocol\"=\"DSP\", \"subprotocolBody\"=\"id=urn:uuid:c8159379-4613-48b8-ad52-6baed7afe923;dspEndpoint=https://irs-provider-controlplane3.dev.demo.catena-x.net\", \"subprotocolBodyEncoding\"=\"plain\"}}], \"id\"=\"urn:uuid:dae4d249-6d66-4818-b576-bf52f3b9ae90\", \"idShort\"=\"vehicle part details\", \"semanticId\"={\"keys\"=[{\"type\"=\"Submodel\", \"value\"=\"urn:bamm:com.catenax.vehicle:0.1.1#PartDetails\"}], \"type\"=\"ModelReference\"}}]}}], \"submodels\"=[{\"aspectType\"=\"supply_chain_impacted\", \"contractAgreementId\"=\"f253718e-a270-4367-901b-9d50d9bd8462\", \"identification\"=\"urn:uuid:fc784d2a-5506-4e61-8e34-21600f8cdeff\", \"payload\"={\"supplyChainImpacted\"=\"YES\"}}], \"tombstones\"=[{\"catenaXId\"=\"urn:uuid:6c311d29-5753-46d4-b32c-19b918ea93b0\", \"endpointURL\"=\"https://catena-x.net/vehicle/partdetails/\", \"processingError\"={\"errorDetail\"=\"Details to reason of failure\", \"lastAttempt\"=\"2022-02-03T14:48:54.709Z\", \"processStep\"=\"SchemaValidation\", \"retryCounter\"=0}}]}")
@JsonDeserialize(builder=JobsBuilder.class)
public final class Jobs {
    @Schema(description="Executable unit with meta information and item graph result.", implementation=Job.class)
    private final Job job;
    @ArraySchema(arraySchema=@Schema(description="Relationships between parent and child items."), maxItems=0x7FFFFFFF)
    private final List<Relationship> relationships;
    @ArraySchema(arraySchema=@Schema(description="AAS shells."), maxItems=0x7FFFFFFF)
    private final List<Shell> shells;
    @ArraySchema(arraySchema=@Schema(description="Collection of not resolvable endpoints as tombstones. Including cause of error and endpoint URL."), maxItems=0x7FFFFFFF)
    private final List<Tombstone> tombstones;
    @ArraySchema(arraySchema=@Schema(description="Collection of requested Submodels"), maxItems=0x7FFFFFFF)
    private final List<Submodel> submodels;
    @ArraySchema(arraySchema=@Schema(description="Collection of bpn mappings"), maxItems=0x7FFFFFFF)
    private final Set<Bpn> bpns;
    static final String EXAMPLE = "{\"bpns\"=[{\"manufacturerId\"=\"BPNL00000003AAXX\", \"manufacturerName\"=\"AB CD\"}], \"job\"={\"completedOn\"=\"2022-02-03T14:48:54.709Z\", \"createdOn\"=\"2022-02-03T14:48:54.709Z\", \"exception\"={\"errorDetail\"=\"Timeout while requesting Digital Registry\", \"exception\"=\"IrsTimeoutException\", \"exceptionDate\"=\"2022-02-03T14:48:54.709Z\"}, \"globalAssetId\"=\"urn:uuid:6c311d29-5753-46d4-b32c-19b918ea93b0\", \"id\"=\"e5347c88-a921-11ec-b909-0242ac120002\", \"lastModifiedOn\"=\"2022-02-03T14:48:54.709Z\", \"parameter\"={\"aspects\"=[\"SerialPart\", \"AddressAspect\"], \"auditContractNegotiation\"=false, \"bomLifecycle\"=\"asBuilt\", \"collectAspects\"=false, \"depth\"=1, \"direction\"=\"downward\", \"lookupBPNs\"=false}, \"startedOn\"=\"2022-02-03T14:48:54.709Z\", \"state\"=\"COMPLETED\", \"summary\"={\"asyncFetchedItems\"={\"completed\"=3, \"failed\"=0, \"running\"=0}}}, \"relationships\"=[{\"catenaXId\"=\"urn:uuid:d9bec1c6-e47c-4d18-ba41-0a5fe8b7f447\", \"linkedItem\"={\"assembledOn\"=\"2022-02-03T14:48:54.709Z\", \"childCatenaXId\"=\"urn:uuid:a45a2246-f6e1-42da-b47d-5c3b58ed62e9\", \"hasAlternatives\"=false, \"lastModifiedOn\"=\"2022-02-03T14:48:54.709Z\", \"lifecycleContext\"=\"asBuilt\", \"quantity\"={\"measurementUnit\"={\"datatypeURI\"=\"urn:bamm:io.openmanufacturing:meta-model:1.0.0#piece\", \"lexicalValue\"=\"piece\"}, \"quantityNumber\"=1}}}], \"shells\"=[{\"contractAgreementId\"=\"f253718e-a270-4367-901b-9d50d9bd8462\", \"payload\"={\"description\"=[{\"language\"=\"en\", \"text\"=\"The shell for a vehicle\"}], \"globalAssetId\"=\"urn:uuid:a45a2246-f6e1-42da-b47d-5c3b58ed62e9\", \"id\"=\"urn:uuid:882fc530-b69b-4707-95f6-5dbc5e9baaa8\", \"idShort\"=\"future concept x\", \"specificAssetIds\"=[{\"name\"=\"engineserialid\", \"value\"=\"12309481209312\"}], \"submodelDescriptors\"=[{\"description\"=[{\"language\"=\"en\", \"text\"=\"Provides base vehicle information\"}], \"endpoints\"=[{\"interface\"=\"HTTP\", \"protocolInformation\"={\"endpointProtocol\"=\"HTTPS\", \"endpointProtocolVersion\"=[\"1.0\"], \"href\"=\"https://catena-x.net/vehicle/basedetails/\", \"subprotocol\"=\"DSP\", \"subprotocolBody\"=\"id=urn:uuid:c8159379-4613-48b8-ad52-6baed7afe923;dspEndpoint=https://irs-provider-controlplane3.dev.demo.catena-x.net\", \"subprotocolBodyEncoding\"=\"plain\"}}], \"id\"=\"urn:uuid:5d25a897-6571-4800-b98c-a3352fbf996d\", \"idShort\"=\"SingleLevelBomAsPlanned\", \"semanticId\"={\"keys\"=[{\"type\"=\"ExternalReference\", \"value\"=\"urn:bamm:io.catenax.single_level_bom_as_planned:2.0.0#SingleLevelBomAsPlanned\"}], \"type\"=\"ModelReference\"}},\n    {\"description\"=[{\"language\"=\"en\", \"text\"=\"Provides base vehicle information\"}], \"endpoints\"=[{\"interface\"=\"HTTP\", \"protocolInformation\"={\"endpointProtocol\"=\"HTTPS\", \"endpointProtocolVersion\"=[\"1.0\"], \"href\"=\"https://catena-x.net/vehicle/partdetails/\", \"subprotocol\"=\"DSP\", \"subprotocolBody\"=\"id=urn:uuid:c8159379-4613-48b8-ad52-6baed7afe923;dspEndpoint=https://irs-provider-controlplane3.dev.demo.catena-x.net\", \"subprotocolBodyEncoding\"=\"plain\"}}], \"id\"=\"urn:uuid:dae4d249-6d66-4818-b576-bf52f3b9ae90\", \"idShort\"=\"vehicle part details\", \"semanticId\"={\"keys\"=[{\"type\"=\"Submodel\", \"value\"=\"urn:bamm:com.catenax.vehicle:0.1.1#PartDetails\"}], \"type\"=\"ModelReference\"}}]}}], \"submodels\"=[{\"aspectType\"=\"supply_chain_impacted\", \"contractAgreementId\"=\"f253718e-a270-4367-901b-9d50d9bd8462\", \"identification\"=\"urn:uuid:fc784d2a-5506-4e61-8e34-21600f8cdeff\", \"payload\"={\"supplyChainImpacted\"=\"YES\"}}], \"tombstones\"=[{\"catenaXId\"=\"urn:uuid:6c311d29-5753-46d4-b32c-19b918ea93b0\", \"endpointURL\"=\"https://catena-x.net/vehicle/partdetails/\", \"processingError\"={\"errorDetail\"=\"Details to reason of failure\", \"lastAttempt\"=\"2022-02-03T14:48:54.709Z\", \"processStep\"=\"SchemaValidation\", \"retryCounter\"=0}}]}";

    @Generated
    public static JobsBuilder builder() {
        return new JobsBuilder();
    }

    @Generated
    public JobsBuilder toBuilder() {
        JobsBuilder builder = new JobsBuilder().job(this.job).shells(this.shells);
        if (this.relationships != null) {
            builder.relationships(this.relationships);
        }
        if (this.tombstones != null) {
            builder.tombstones(this.tombstones);
        }
        if (this.submodels != null) {
            builder.submodels(this.submodels);
        }
        if (this.bpns != null) {
            builder.bpns(this.bpns);
        }
        return builder;
    }

    @Generated
    public Job getJob() {
        return this.job;
    }

    @Generated
    public List<Relationship> getRelationships() {
        return this.relationships;
    }

    @Generated
    public List<Shell> getShells() {
        return this.shells;
    }

    @Generated
    public List<Tombstone> getTombstones() {
        return this.tombstones;
    }

    @Generated
    public List<Submodel> getSubmodels() {
        return this.submodels;
    }

    @Generated
    public Set<Bpn> getBpns() {
        return this.bpns;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Jobs)) {
            return false;
        }
        Jobs other = (Jobs)o;
        Job this$job = this.getJob();
        Job other$job = other.getJob();
        if (this$job == null ? other$job != null : !((Object)this$job).equals(other$job)) {
            return false;
        }
        List<Relationship> this$relationships = this.getRelationships();
        List<Relationship> other$relationships = other.getRelationships();
        if (this$relationships == null ? other$relationships != null : !((Object)this$relationships).equals(other$relationships)) {
            return false;
        }
        List<Shell> this$shells = this.getShells();
        List<Shell> other$shells = other.getShells();
        if (this$shells == null ? other$shells != null : !((Object)this$shells).equals(other$shells)) {
            return false;
        }
        List<Tombstone> this$tombstones = this.getTombstones();
        List<Tombstone> other$tombstones = other.getTombstones();
        if (this$tombstones == null ? other$tombstones != null : !((Object)this$tombstones).equals(other$tombstones)) {
            return false;
        }
        List<Submodel> this$submodels = this.getSubmodels();
        List<Submodel> other$submodels = other.getSubmodels();
        if (this$submodels == null ? other$submodels != null : !((Object)this$submodels).equals(other$submodels)) {
            return false;
        }
        Set<Bpn> this$bpns = this.getBpns();
        Set<Bpn> other$bpns = other.getBpns();
        return !(this$bpns == null ? other$bpns != null : !((Object)this$bpns).equals(other$bpns));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Job $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : ((Object)$job).hashCode());
        List<Relationship> $relationships = this.getRelationships();
        result = result * 59 + ($relationships == null ? 43 : ((Object)$relationships).hashCode());
        List<Shell> $shells = this.getShells();
        result = result * 59 + ($shells == null ? 43 : ((Object)$shells).hashCode());
        List<Tombstone> $tombstones = this.getTombstones();
        result = result * 59 + ($tombstones == null ? 43 : ((Object)$tombstones).hashCode());
        List<Submodel> $submodels = this.getSubmodels();
        result = result * 59 + ($submodels == null ? 43 : ((Object)$submodels).hashCode());
        Set<Bpn> $bpns = this.getBpns();
        result = result * 59 + ($bpns == null ? 43 : ((Object)$bpns).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Jobs(job=" + String.valueOf(this.getJob()) + ", relationships=" + String.valueOf(this.getRelationships()) + ", shells=" + String.valueOf(this.getShells()) + ", tombstones=" + String.valueOf(this.getTombstones()) + ", submodels=" + String.valueOf(this.getSubmodels()) + ", bpns=" + String.valueOf(this.getBpns()) + ")";
    }

    @Generated
    public Jobs(Job job, List<Relationship> relationships, List<Shell> shells, List<Tombstone> tombstones, List<Submodel> submodels, Set<Bpn> bpns) {
        this.job = job;
        this.relationships = relationships;
        this.shells = shells;
        this.tombstones = tombstones;
        this.submodels = submodels;
        this.bpns = bpns;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class JobsBuilder {
        @Generated
        private Job job;
        @Generated
        private ArrayList<Relationship> relationships;
        @Generated
        private List<Shell> shells;
        @Generated
        private ArrayList<Tombstone> tombstones;
        @Generated
        private ArrayList<Submodel> submodels;
        @Generated
        private ArrayList<Bpn> bpns;

        @Generated
        JobsBuilder() {
        }

        @Generated
        public JobsBuilder job(Job job) {
            this.job = job;
            return this;
        }

        @Generated
        public JobsBuilder relationship(Relationship relationship) {
            if (this.relationships == null) {
                this.relationships = new ArrayList();
            }
            this.relationships.add(relationship);
            return this;
        }

        @Generated
        public JobsBuilder relationships(Collection<? extends Relationship> relationships) {
            if (relationships == null) {
                throw new NullPointerException("relationships cannot be null");
            }
            if (this.relationships == null) {
                this.relationships = new ArrayList();
            }
            this.relationships.addAll(relationships);
            return this;
        }

        @Generated
        public JobsBuilder clearRelationships() {
            if (this.relationships != null) {
                this.relationships.clear();
            }
            return this;
        }

        @Generated
        public JobsBuilder shells(List<Shell> shells) {
            this.shells = shells;
            return this;
        }

        @Generated
        public JobsBuilder tombstone(Tombstone tombstone) {
            if (this.tombstones == null) {
                this.tombstones = new ArrayList();
            }
            this.tombstones.add(tombstone);
            return this;
        }

        @Generated
        public JobsBuilder tombstones(Collection<? extends Tombstone> tombstones) {
            if (tombstones == null) {
                throw new NullPointerException("tombstones cannot be null");
            }
            if (this.tombstones == null) {
                this.tombstones = new ArrayList();
            }
            this.tombstones.addAll(tombstones);
            return this;
        }

        @Generated
        public JobsBuilder clearTombstones() {
            if (this.tombstones != null) {
                this.tombstones.clear();
            }
            return this;
        }

        @Generated
        public JobsBuilder submodel(Submodel submodel) {
            if (this.submodels == null) {
                this.submodels = new ArrayList();
            }
            this.submodels.add(submodel);
            return this;
        }

        @Generated
        public JobsBuilder submodels(Collection<? extends Submodel> submodels) {
            if (submodels == null) {
                throw new NullPointerException("submodels cannot be null");
            }
            if (this.submodels == null) {
                this.submodels = new ArrayList();
            }
            this.submodels.addAll(submodels);
            return this;
        }

        @Generated
        public JobsBuilder clearSubmodels() {
            if (this.submodels != null) {
                this.submodels.clear();
            }
            return this;
        }

        @Generated
        public JobsBuilder bpn(Bpn bpn) {
            if (this.bpns == null) {
                this.bpns = new ArrayList();
            }
            this.bpns.add(bpn);
            return this;
        }

        @Generated
        public JobsBuilder bpns(Collection<? extends Bpn> bpns) {
            if (bpns == null) {
                throw new NullPointerException("bpns cannot be null");
            }
            if (this.bpns == null) {
                this.bpns = new ArrayList();
            }
            this.bpns.addAll(bpns);
            return this;
        }

        @Generated
        public JobsBuilder clearBpns() {
            if (this.bpns != null) {
                this.bpns.clear();
            }
            return this;
        }

        @Generated
        public Jobs build() {
            Set<Bpn> bpns;
            List<Relationship> relationships = switch (this.relationships == null ? 0 : this.relationships.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.relationships.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Relationship>(this.relationships));
            };
            List<Tombstone> tombstones = switch (this.tombstones == null ? 0 : this.tombstones.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.tombstones.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Tombstone>(this.tombstones));
            };
            List<Submodel> submodels = switch (this.submodels == null ? 0 : this.submodels.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.submodels.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Submodel>(this.submodels));
            };
            switch (this.bpns == null ? 0 : this.bpns.size()) {
                case 0: {
                    bpns = Collections.emptySet();
                    break;
                }
                case 1: {
                    bpns = Collections.singleton(this.bpns.get(0));
                    break;
                }
                default: {
                    bpns = new LinkedHashSet(this.bpns.size() < 0x40000000 ? 1 + this.bpns.size() + (this.bpns.size() - 3) / 3 : Integer.MAX_VALUE);
                    bpns.addAll(this.bpns);
                    bpns = Collections.unmodifiableSet(bpns);
                }
            }
            return new Jobs(this.job, relationships, this.shells, tombstones, submodels, bpns);
        }

        @Generated
        public String toString() {
            return "Jobs.JobsBuilder(job=" + String.valueOf(this.job) + ", relationships=" + String.valueOf(this.relationships) + ", shells=" + String.valueOf(this.shells) + ", tombstones=" + String.valueOf(this.tombstones) + ", submodels=" + String.valueOf(this.submodels) + ", bpns=" + String.valueOf(this.bpns) + ")";
        }
    }
}

