/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.component;

import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.eclipse.tractusx.irs.component.PartChainIdentificationKey;
import org.eclipse.tractusx.irs.component.enums.BatchStrategy;
import org.eclipse.tractusx.irs.component.enums.BomLifecycle;
import org.eclipse.tractusx.irs.component.enums.Direction;
import org.eclipse.tractusx.irs.validators.Mod10;
import org.hibernate.validator.constraints.URL;

@Schema(description="Request body for registering a new Batch Order.")
public class RegisterBatchOrder {
    private static final String ASPECT_MODEL_REGEX = "^(urn:[bs]amm:.*\\d\\.\\d\\.\\d)?(#)?(\\w+)?$";
    @NotEmpty
    @Valid
    @ArraySchema(schema=@Schema(description="Keys array contains required attributes for identify part chain entry node ", implementation=PartChainIdentificationKey.class), maxItems=0x7FFFFFFF)
    private Set<PartChainIdentificationKey> keys;
    @Schema(description="BoM Lifecycle of the result tree.", implementation=BomLifecycle.class)
    private BomLifecycle bomLifecycle;
    @ArraySchema(arraySchema=@Schema(description="List of aspect names that will be collected if \\<collectAspects\\> flag is set to true.", example="[\"urn:samm:io.catenax.single_level_bom_as_built:3.0.0#SingleLevelBomAsBuilt\"]", implementation=String.class, pattern="^(urn:[bs]amm:.*\\d\\.\\d\\.\\d)?(#)?(\\w+)?$"), maxItems=0x7FFFFFFF)
    private List<@Pattern(regexp="^(urn:[bs]amm:.*\\d\\.\\d\\.\\d)?(#)?(\\w+)?$") String> aspects;
    @Schema(implementation=Integer.class, minimum="1", maximum="100", description="Max depth of the item graph returned. If no depth is set item graph with max depth is returned.")
    @Min(value=1L)
    @Max(value=100L)
    private @Min(value=1L) @Max(value=100L) Integer depth;
    @Schema(implementation=Direction.class, defaultValue="downward")
    private Direction direction;
    @Schema(description="Flag to specify whether aspects should be requested and collected. Default is false.")
    private boolean collectAspects;
    @Schema(description="Flag to specify whether BPNs should be collected and resolved via the configured BPDM URL. Default is false.", deprecated=true)
    private boolean lookupBPNs;
    @URL
    @Schema(description="Callback url to notify requestor when job processing is finished. There are four uri variable placeholders that can be used: orderId, batchId, orderState and batchState.", example="https://hostname.com/callback?orderId={orderId}&batchId={batchId}&orderState={orderState}&batchState={batchState}")
    private String callbackUrl;
    @Schema(implementation=Integer.class, minimum="10", maximum="100", defaultValue="20", description="Size of the batch.")
    @Min(value=10L)
    @Max(value=100L)
    @Mod10(message="Batch size value must be mod 10 compliant")
    private @Min(value=10L) @Max(value=100L) Integer batchSize = 20;
    @Schema(implementation=Integer.class, minimum="60", maximum="86400", defaultValue="43200", description="Timeout in seconds for the complete batch order processing.")
    @Min(value=60L)
    @Max(value=86400L)
    private @Min(value=60L) @Max(value=86400L) Integer timeout = 43200;
    @Schema(implementation=Integer.class, minimum="60", maximum="7200", defaultValue="3600", description="Timeout in seconds for each job processing inside the complete order.")
    @Min(value=60L)
    @Max(value=7200L)
    private @Min(value=60L) @Max(value=7200L) Integer jobTimeout = 3600;
    @Schema(implementation=BatchStrategy.class, description="The strategy how the batch is processed internally in IRS.")
    private BatchStrategy batchStrategy;

    public int getDepth() {
        return this.depth == null ? 100 : this.depth;
    }

    @Generated
    public static RegisterBatchOrderBuilder builder() {
        return new RegisterBatchOrderBuilder();
    }

    @Generated
    public Set<PartChainIdentificationKey> getKeys() {
        return this.keys;
    }

    @Generated
    public BomLifecycle getBomLifecycle() {
        return this.bomLifecycle;
    }

    @Generated
    public List<@Pattern(regexp="^(urn:[bs]amm:.*\\d\\.\\d\\.\\d)?(#)?(\\w+)?$") String> getAspects() {
        return this.aspects;
    }

    @Generated
    public Direction getDirection() {
        return this.direction;
    }

    @Generated
    public boolean isCollectAspects() {
        return this.collectAspects;
    }

    @Generated
    public boolean isLookupBPNs() {
        return this.lookupBPNs;
    }

    @Generated
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @Generated
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public Integer getTimeout() {
        return this.timeout;
    }

    @Generated
    public Integer getJobTimeout() {
        return this.jobTimeout;
    }

    @Generated
    public BatchStrategy getBatchStrategy() {
        return this.batchStrategy;
    }

    @Generated
    public void setKeys(Set<PartChainIdentificationKey> keys) {
        this.keys = keys;
    }

    @Generated
    public void setBomLifecycle(BomLifecycle bomLifecycle) {
        this.bomLifecycle = bomLifecycle;
    }

    @Generated
    public void setAspects(List<@Pattern(regexp="^(urn:[bs]amm:.*\\d\\.\\d\\.\\d)?(#)?(\\w+)?$") String> aspects) {
        this.aspects = aspects;
    }

    @Generated
    public void setDepth(Integer depth) {
        this.depth = depth;
    }

    @Generated
    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    @Generated
    public void setCollectAspects(boolean collectAspects) {
        this.collectAspects = collectAspects;
    }

    @Generated
    public void setLookupBPNs(boolean lookupBPNs) {
        this.lookupBPNs = lookupBPNs;
    }

    @Generated
    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    @Generated
    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    @Generated
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setJobTimeout(Integer jobTimeout) {
        this.jobTimeout = jobTimeout;
    }

    @Generated
    public void setBatchStrategy(BatchStrategy batchStrategy) {
        this.batchStrategy = batchStrategy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisterBatchOrder)) {
            return false;
        }
        RegisterBatchOrder other = (RegisterBatchOrder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCollectAspects() != other.isCollectAspects()) {
            return false;
        }
        if (this.isLookupBPNs() != other.isLookupBPNs()) {
            return false;
        }
        if (this.getDepth() != other.getDepth()) {
            return false;
        }
        Integer this$batchSize = this.getBatchSize();
        Integer other$batchSize = other.getBatchSize();
        if (this$batchSize == null ? other$batchSize != null : !((Object)this$batchSize).equals(other$batchSize)) {
            return false;
        }
        Integer this$timeout = this.getTimeout();
        Integer other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        Integer this$jobTimeout = this.getJobTimeout();
        Integer other$jobTimeout = other.getJobTimeout();
        if (this$jobTimeout == null ? other$jobTimeout != null : !((Object)this$jobTimeout).equals(other$jobTimeout)) {
            return false;
        }
        Set<PartChainIdentificationKey> this$keys = this.getKeys();
        Set<PartChainIdentificationKey> other$keys = other.getKeys();
        if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
            return false;
        }
        BomLifecycle this$bomLifecycle = this.getBomLifecycle();
        BomLifecycle other$bomLifecycle = other.getBomLifecycle();
        if (this$bomLifecycle == null ? other$bomLifecycle != null : !((Object)((Object)this$bomLifecycle)).equals((Object)other$bomLifecycle)) {
            return false;
        }
        List<String> this$aspects = this.getAspects();
        List<String> other$aspects = other.getAspects();
        if (this$aspects == null ? other$aspects != null : !((Object)this$aspects).equals(other$aspects)) {
            return false;
        }
        Direction this$direction = this.getDirection();
        Direction other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !((Object)((Object)this$direction)).equals((Object)other$direction)) {
            return false;
        }
        String this$callbackUrl = this.getCallbackUrl();
        String other$callbackUrl = other.getCallbackUrl();
        if (this$callbackUrl == null ? other$callbackUrl != null : !this$callbackUrl.equals(other$callbackUrl)) {
            return false;
        }
        BatchStrategy this$batchStrategy = this.getBatchStrategy();
        BatchStrategy other$batchStrategy = other.getBatchStrategy();
        return !(this$batchStrategy == null ? other$batchStrategy != null : !((Object)((Object)this$batchStrategy)).equals((Object)other$batchStrategy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RegisterBatchOrder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCollectAspects() ? 79 : 97);
        result = result * 59 + (this.isLookupBPNs() ? 79 : 97);
        result = result * 59 + this.getDepth();
        Integer $batchSize = this.getBatchSize();
        result = result * 59 + ($batchSize == null ? 43 : ((Object)$batchSize).hashCode());
        Integer $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        Integer $jobTimeout = this.getJobTimeout();
        result = result * 59 + ($jobTimeout == null ? 43 : ((Object)$jobTimeout).hashCode());
        Set<PartChainIdentificationKey> $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        BomLifecycle $bomLifecycle = this.getBomLifecycle();
        result = result * 59 + ($bomLifecycle == null ? 43 : ((Object)((Object)$bomLifecycle)).hashCode());
        List<String> $aspects = this.getAspects();
        result = result * 59 + ($aspects == null ? 43 : ((Object)$aspects).hashCode());
        Direction $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : ((Object)((Object)$direction)).hashCode());
        String $callbackUrl = this.getCallbackUrl();
        result = result * 59 + ($callbackUrl == null ? 43 : $callbackUrl.hashCode());
        BatchStrategy $batchStrategy = this.getBatchStrategy();
        result = result * 59 + ($batchStrategy == null ? 43 : ((Object)((Object)$batchStrategy)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RegisterBatchOrder(keys=" + String.valueOf(this.getKeys()) + ", bomLifecycle=" + String.valueOf((Object)this.getBomLifecycle()) + ", aspects=" + String.valueOf(this.getAspects()) + ", depth=" + this.getDepth() + ", direction=" + String.valueOf((Object)this.getDirection()) + ", collectAspects=" + this.isCollectAspects() + ", lookupBPNs=" + this.isLookupBPNs() + ", callbackUrl=" + this.getCallbackUrl() + ", batchSize=" + this.getBatchSize() + ", timeout=" + this.getTimeout() + ", jobTimeout=" + this.getJobTimeout() + ", batchStrategy=" + String.valueOf((Object)this.getBatchStrategy()) + ")";
    }

    @Generated
    public RegisterBatchOrder() {
    }

    @Generated
    public RegisterBatchOrder(Set<PartChainIdentificationKey> keys, BomLifecycle bomLifecycle, List<@Pattern(regexp="^(urn:[bs]amm:.*\\d\\.\\d\\.\\d)?(#)?(\\w+)?$") String> aspects, Integer depth, Direction direction, boolean collectAspects, boolean lookupBPNs, String callbackUrl, Integer batchSize, Integer timeout, Integer jobTimeout, BatchStrategy batchStrategy) {
        this.keys = keys;
        this.bomLifecycle = bomLifecycle;
        this.aspects = aspects;
        this.depth = depth;
        this.direction = direction;
        this.collectAspects = collectAspects;
        this.lookupBPNs = lookupBPNs;
        this.callbackUrl = callbackUrl;
        this.batchSize = batchSize;
        this.timeout = timeout;
        this.jobTimeout = jobTimeout;
        this.batchStrategy = batchStrategy;
    }

    static final class RegisterBatchOrderConstants {
        static final String MIN_TREE_DEPTH_DESC = "1";
        static final String MAX_TREE_DEPTH_DESC = "100";
        static final int MIN_TREE_DEPTH = 1;
        static final int MAX_TREE_DEPTH = 100;
        static final String MIN_BATCH_SIZE_DESC = "10";
        static final String MAX_BATCH_SIZE_DESC = "100";
        static final String DEFAULT_BATCH_SIZE_DESC = "20";
        static final int MIN_BATCH_SIZE = 10;
        static final int MAX_BATCH_SIZE = 100;
        static final int DEFAULT_BATCH_SIZE = 20;
        static final String MIN_TIMEOUT_DESC = "60";
        static final String MAX_TIMEOUT_DESC = "86400";
        static final String DEFAULT_TIMEOUT_DESC = "43200";
        static final int MIN_TIMEOUT = 60;
        static final int MAX_TIMEOUT = 86400;
        static final int DEFAULT_TIMEOUT = 43200;
        static final String MIN_JOB_TIMEOUT_DESC = "60";
        static final String MAX_JOB_TIMEOUT_DESC = "7200";
        static final String DEFAULT_JOB_TIMEOUT_DESC = "3600";
        static final int MIN_JOB_TIMEOUT = 60;
        static final int MAX_JOB_TIMEOUT = 7200;
        static final int DEFAULT_JOB_TIMEOUT = 3600;

        @Generated
        private RegisterBatchOrderConstants() {
        }
    }

    @Generated
    public static class RegisterBatchOrderBuilder {
        @Generated
        private Set<PartChainIdentificationKey> keys;
        @Generated
        private BomLifecycle bomLifecycle;
        @Generated
        private List<@Pattern(regexp="^(urn:[bs]amm:.*\\d\\.\\d\\.\\d)?(#)?(\\w+)?$") String> aspects;
        @Generated
        private Integer depth;
        @Generated
        private Direction direction;
        @Generated
        private boolean collectAspects;
        @Generated
        private boolean lookupBPNs;
        @Generated
        private String callbackUrl;
        @Generated
        private Integer batchSize;
        @Generated
        private Integer timeout;
        @Generated
        private Integer jobTimeout;
        @Generated
        private BatchStrategy batchStrategy;

        @Generated
        RegisterBatchOrderBuilder() {
        }

        @Generated
        public RegisterBatchOrderBuilder keys(Set<PartChainIdentificationKey> keys) {
            this.keys = keys;
            return this;
        }

        @Generated
        public RegisterBatchOrderBuilder bomLifecycle(BomLifecycle bomLifecycle) {
            this.bomLifecycle = bomLifecycle;
            return this;
        }

        @Generated
        public RegisterBatchOrderBuilder aspects(List<@Pattern(regexp="^(urn:[bs]amm:.*\\d\\.\\d\\.\\d)?(#)?(\\w+)?$") String> aspects) {
            this.aspects = aspects;
            return this;
        }

        @Generated
        public RegisterBatchOrderBuilder depth(Integer depth) {
            this.depth = depth;
            return this;
        }

        @Generated
        public RegisterBatchOrderBuilder direction(Direction direction) {
            this.direction = direction;
            return this;
        }

        @Generated
        public RegisterBatchOrderBuilder collectAspects(boolean collectAspects) {
            this.collectAspects = collectAspects;
            return this;
        }

        @Generated
        public RegisterBatchOrderBuilder lookupBPNs(boolean lookupBPNs) {
            this.lookupBPNs = lookupBPNs;
            return this;
        }

        @Generated
        public RegisterBatchOrderBuilder callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        @Generated
        public RegisterBatchOrderBuilder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @Generated
        public RegisterBatchOrderBuilder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public RegisterBatchOrderBuilder jobTimeout(Integer jobTimeout) {
            this.jobTimeout = jobTimeout;
            return this;
        }

        @Generated
        public RegisterBatchOrderBuilder batchStrategy(BatchStrategy batchStrategy) {
            this.batchStrategy = batchStrategy;
            return this;
        }

        @Generated
        public RegisterBatchOrder build() {
            return new RegisterBatchOrder(this.keys, this.bomLifecycle, this.aspects, this.depth, this.direction, this.collectAspects, this.lookupBPNs, this.callbackUrl, this.batchSize, this.timeout, this.jobTimeout, this.batchStrategy);
        }

        @Generated
        public String toString() {
            return "RegisterBatchOrder.RegisterBatchOrderBuilder(keys=" + String.valueOf(this.keys) + ", bomLifecycle=" + String.valueOf((Object)this.bomLifecycle) + ", aspects=" + String.valueOf(this.aspects) + ", depth=" + this.depth + ", direction=" + String.valueOf((Object)this.direction) + ", collectAspects=" + this.collectAspects + ", lookupBPNs=" + this.lookupBPNs + ", callbackUrl=" + this.callbackUrl + ", batchSize=" + this.batchSize + ", timeout=" + this.timeout + ", jobTimeout=" + this.jobTimeout + ", batchStrategy=" + String.valueOf((Object)this.batchStrategy) + ")";
        }
    }
}

