/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.component.assetadministrationshell;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.tractusx.irs.component.assetadministrationshell.AdministrativeInformation;
import org.eclipse.tractusx.irs.component.assetadministrationshell.Endpoint;
import org.eclipse.tractusx.irs.component.assetadministrationshell.IdentifierKeyValuePair;
import org.eclipse.tractusx.irs.component.assetadministrationshell.LangString;
import org.eclipse.tractusx.irs.component.assetadministrationshell.SubmodelDescriptor;
import org.eclipse.tractusx.irs.component.enums.AspectType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Schema(description="AAS shells.")
@JsonDeserialize(builder=AssetAdministrationShellDescriptorBuilder.class)
public class AssetAdministrationShellDescriptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetAdministrationShellDescriptor.class);
    private AdministrativeInformation administration;
    @ArraySchema(maxItems=0x7FFFFFFF)
    private List<LangString> description;
    @Schema(description="Id of global asset.", example="urn:uuid:6c311d29-5753-46d4-b32c-19b918ea93b0", implementation=String.class)
    private String globalAssetId;
    @Schema(implementation=String.class, example="future concept x")
    private String idShort;
    @Schema(implementation=String.class, example="882fc530-b69b-4707-95f6-5dbc5e9baaa8")
    private String id;
    @ArraySchema(maxItems=0x7FFFFFFF)
    private List<IdentifierKeyValuePair> specificAssetIds;
    @ArraySchema(maxItems=0x7FFFFFFF)
    private List<SubmodelDescriptor> submodelDescriptors;

    public Optional<String> findManufacturerId() {
        return this.specificAssetIds.stream().filter(assetId -> "ManufacturerId".equalsIgnoreCase(assetId.getName())).map(IdentifierKeyValuePair::getValue).findFirst();
    }

    public List<Endpoint> findRelationshipEndpointAddresses(AspectType relationshipAspect) {
        List<SubmodelDescriptor> filteredSubmodelDescriptors = this.filterDescriptorsByAspectTypes(List.of(relationshipAspect.toString()));
        return filteredSubmodelDescriptors.stream().map(SubmodelDescriptor::getEndpoints).flatMap(Collection::stream).toList();
    }

    public List<SubmodelDescriptor> filterDescriptorsByAspectTypes(List<String> aspectTypes) {
        log.info("Filtering for Aspect Types '{}'", aspectTypes);
        return this.submodelDescriptors.stream().filter(submodelDescriptor -> aspectTypes.stream().anyMatch(submodelDescriptor::isAspect)).toList();
    }

    @Generated
    public static AssetAdministrationShellDescriptorBuilder builder() {
        return new AssetAdministrationShellDescriptorBuilder();
    }

    @Generated
    public AssetAdministrationShellDescriptorBuilder toBuilder() {
        return new AssetAdministrationShellDescriptorBuilder().administration(this.administration).description(this.description).globalAssetId(this.globalAssetId).idShort(this.idShort).id(this.id).specificAssetIds(this.specificAssetIds).submodelDescriptors(this.submodelDescriptors);
    }

    @Generated
    public AdministrativeInformation getAdministration() {
        return this.administration;
    }

    @Generated
    public List<LangString> getDescription() {
        return this.description;
    }

    @Generated
    public String getGlobalAssetId() {
        return this.globalAssetId;
    }

    @Generated
    public String getIdShort() {
        return this.idShort;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public List<IdentifierKeyValuePair> getSpecificAssetIds() {
        return this.specificAssetIds;
    }

    @Generated
    public List<SubmodelDescriptor> getSubmodelDescriptors() {
        return this.submodelDescriptors;
    }

    @Generated
    public void setAdministration(AdministrativeInformation administration) {
        this.administration = administration;
    }

    @Generated
    public void setDescription(List<LangString> description) {
        this.description = description;
    }

    @Generated
    public void setGlobalAssetId(String globalAssetId) {
        this.globalAssetId = globalAssetId;
    }

    @Generated
    public void setIdShort(String idShort) {
        this.idShort = idShort;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setSpecificAssetIds(List<IdentifierKeyValuePair> specificAssetIds) {
        this.specificAssetIds = specificAssetIds;
    }

    @Generated
    public void setSubmodelDescriptors(List<SubmodelDescriptor> submodelDescriptors) {
        this.submodelDescriptors = submodelDescriptors;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetAdministrationShellDescriptor)) {
            return false;
        }
        AssetAdministrationShellDescriptor other = (AssetAdministrationShellDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AdministrativeInformation this$administration = this.getAdministration();
        AdministrativeInformation other$administration = other.getAdministration();
        if (this$administration == null ? other$administration != null : !((Object)this$administration).equals(other$administration)) {
            return false;
        }
        List<LangString> this$description = this.getDescription();
        List<LangString> other$description = other.getDescription();
        if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
            return false;
        }
        String this$globalAssetId = this.getGlobalAssetId();
        String other$globalAssetId = other.getGlobalAssetId();
        if (this$globalAssetId == null ? other$globalAssetId != null : !this$globalAssetId.equals(other$globalAssetId)) {
            return false;
        }
        String this$idShort = this.getIdShort();
        String other$idShort = other.getIdShort();
        if (this$idShort == null ? other$idShort != null : !this$idShort.equals(other$idShort)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<IdentifierKeyValuePair> this$specificAssetIds = this.getSpecificAssetIds();
        List<IdentifierKeyValuePair> other$specificAssetIds = other.getSpecificAssetIds();
        if (this$specificAssetIds == null ? other$specificAssetIds != null : !((Object)this$specificAssetIds).equals(other$specificAssetIds)) {
            return false;
        }
        List<SubmodelDescriptor> this$submodelDescriptors = this.getSubmodelDescriptors();
        List<SubmodelDescriptor> other$submodelDescriptors = other.getSubmodelDescriptors();
        return !(this$submodelDescriptors == null ? other$submodelDescriptors != null : !((Object)this$submodelDescriptors).equals(other$submodelDescriptors));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssetAdministrationShellDescriptor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AdministrativeInformation $administration = this.getAdministration();
        result = result * 59 + ($administration == null ? 43 : ((Object)$administration).hashCode());
        List<LangString> $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        String $globalAssetId = this.getGlobalAssetId();
        result = result * 59 + ($globalAssetId == null ? 43 : $globalAssetId.hashCode());
        String $idShort = this.getIdShort();
        result = result * 59 + ($idShort == null ? 43 : $idShort.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<IdentifierKeyValuePair> $specificAssetIds = this.getSpecificAssetIds();
        result = result * 59 + ($specificAssetIds == null ? 43 : ((Object)$specificAssetIds).hashCode());
        List<SubmodelDescriptor> $submodelDescriptors = this.getSubmodelDescriptors();
        result = result * 59 + ($submodelDescriptors == null ? 43 : ((Object)$submodelDescriptors).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AssetAdministrationShellDescriptor(administration=" + String.valueOf(this.getAdministration()) + ", description=" + String.valueOf(this.getDescription()) + ", globalAssetId=" + this.getGlobalAssetId() + ", idShort=" + this.getIdShort() + ", id=" + this.getId() + ", specificAssetIds=" + String.valueOf(this.getSpecificAssetIds()) + ", submodelDescriptors=" + String.valueOf(this.getSubmodelDescriptors()) + ")";
    }

    @Generated
    public AssetAdministrationShellDescriptor() {
    }

    @Generated
    public AssetAdministrationShellDescriptor(AdministrativeInformation administration, List<LangString> description, String globalAssetId, String idShort, String id, List<IdentifierKeyValuePair> specificAssetIds, List<SubmodelDescriptor> submodelDescriptors) {
        this.administration = administration;
        this.description = description;
        this.globalAssetId = globalAssetId;
        this.idShort = idShort;
        this.id = id;
        this.specificAssetIds = specificAssetIds;
        this.submodelDescriptors = submodelDescriptors;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class AssetAdministrationShellDescriptorBuilder {
        @Generated
        private AdministrativeInformation administration;
        @Generated
        private List<LangString> description;
        @Generated
        private String globalAssetId;
        @Generated
        private String idShort;
        @Generated
        private String id;
        @Generated
        private List<IdentifierKeyValuePair> specificAssetIds;
        @Generated
        private List<SubmodelDescriptor> submodelDescriptors;

        @Generated
        AssetAdministrationShellDescriptorBuilder() {
        }

        @Generated
        public AssetAdministrationShellDescriptorBuilder administration(AdministrativeInformation administration) {
            this.administration = administration;
            return this;
        }

        @Generated
        public AssetAdministrationShellDescriptorBuilder description(List<LangString> description) {
            this.description = description;
            return this;
        }

        @Generated
        public AssetAdministrationShellDescriptorBuilder globalAssetId(String globalAssetId) {
            this.globalAssetId = globalAssetId;
            return this;
        }

        @Generated
        public AssetAdministrationShellDescriptorBuilder idShort(String idShort) {
            this.idShort = idShort;
            return this;
        }

        @Generated
        public AssetAdministrationShellDescriptorBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public AssetAdministrationShellDescriptorBuilder specificAssetIds(List<IdentifierKeyValuePair> specificAssetIds) {
            this.specificAssetIds = specificAssetIds;
            return this;
        }

        @Generated
        public AssetAdministrationShellDescriptorBuilder submodelDescriptors(List<SubmodelDescriptor> submodelDescriptors) {
            this.submodelDescriptors = submodelDescriptors;
            return this;
        }

        @Generated
        public AssetAdministrationShellDescriptor build() {
            return new AssetAdministrationShellDescriptor(this.administration, this.description, this.globalAssetId, this.idShort, this.id, this.specificAssetIds, this.submodelDescriptors);
        }

        @Generated
        public String toString() {
            return "AssetAdministrationShellDescriptor.AssetAdministrationShellDescriptorBuilder(administration=" + String.valueOf(this.administration) + ", description=" + String.valueOf(this.description) + ", globalAssetId=" + this.globalAssetId + ", idShort=" + this.idShort + ", id=" + this.id + ", specificAssetIds=" + String.valueOf(this.specificAssetIds) + ", submodelDescriptors=" + String.valueOf(this.submodelDescriptors) + ")";
        }
    }
}

