/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.component.assetadministrationshell;

import com.vdurmont.semver4j.Semver;

record SemanticModel(String urn, String type, String name, Semver version) {
    private static final int VALID_SEMANTIC_ID_LENGTH = 4;

    static SemanticModel parse(String semanticId) {
        String[] parts = semanticId.split(":");
        if (parts.length != 4) {
            throw new IllegalArgumentException("Invalid semanticId value, cant parse: " + semanticId);
        }
        String version = parts[3].split("#")[0];
        return new SemanticModel(parts[0], parts[1], parts[2], new Semver(version));
    }

    boolean matches(SemanticModel model) {
        return this.urn.equals(model.urn) && this.type.equals(model.type) && this.name.equals(model.name) && this.versionIsInRange(model);
    }

    private boolean versionIsInRange(SemanticModel model) {
        Semver nextMajor = model.version.nextMajor();
        Semver minMajor = new Semver(model.version.getMajor() + ".0.0");
        return this.version.isGreaterThanOrEqualTo(minMajor) && this.version.isLowerThan(nextMajor);
    }
}

