/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.component.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

@JsonSerialize(using=ToStringSerializer.class)
@Schema(description="The lifecycle context in which the child part was assembled into the parent part.")
public enum BomLifecycle {
    AS_BUILT("asBuilt"),
    AS_PLANNED("asPlanned"),
    AS_SPECIFIED("asSpecified");

    private final String name;

    private BomLifecycle(String name) {
        this.name = name;
    }

    public static BomLifecycle value(String value) {
        return BomLifecycle.valueOf(value);
    }

    @JsonCreator
    public static BomLifecycle fromValue(String value) {
        return Stream.of(BomLifecycle.values()).filter(bomLifecycle -> bomLifecycle.name.equals(value)).findFirst().orElseThrow(() -> new NoSuchElementException("Unsupported BomLifecycle: " + value + ". Must be one of: " + BomLifecycle.supportedBomLifecycles()));
    }

    private static String supportedBomLifecycles() {
        return Stream.of(BomLifecycle.values()).map(bomLifecycle -> bomLifecycle.name).collect(Collectors.joining(", "));
    }

    public String toString() {
        return this.name;
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

