/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.component.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

@JsonSerialize(using=ToStringSerializer.class)
@Schema(description="Item graph traversal direction.")
public enum Direction {
    UPWARD("upward"),
    DOWNWARD("downward");

    private final String name;

    private Direction(String name) {
        this.name = name;
    }

    public static Direction value(String value) {
        return Direction.valueOf(value);
    }

    @JsonCreator
    public static Direction fromValue(String value) {
        return Stream.of(Direction.values()).filter(direction -> direction.name.equals(value)).findFirst().orElseThrow(() -> new NoSuchElementException("Unsupported direction. Must be one of: " + Direction.supportedDirections()));
    }

    private static String supportedDirections() {
        return Stream.of(Direction.values()).map(direction -> direction.name).collect(Collectors.joining(", "));
    }

    public String toString() {
        return this.name;
    }

    public static final class DirectionConstants {
        public static final String UPWARD = "upward";
        public static final String DOWNWARD = "downward";

        @Generated
        private DirectionConstants() {
        }
    }
}

