/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.data;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import lombok.Generated;
import org.eclipse.tractusx.irs.data.JsonParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StringMapper.class);
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static String mapToString(Object value) {
        try {
            return MAPPER.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new JsonParseException(e);
        }
    }

    public static <T> T mapFromBase64String(String value, TypeReference<T> typeReference) {
        if (value == null) {
            return null;
        }
        return StringMapper.mapFromString(StringMapper.fromBase64(value), typeReference);
    }

    public static <T> T mapFromString(String value, Class<T> clazz) {
        try {
            return (T)MAPPER.readValue(value, clazz);
        }
        catch (JsonProcessingException e) {
            throw new JsonParseException(e);
        }
    }

    public static <T> T mapFromString(String value, TypeReference<T> typeReference) {
        try {
            return (T)MAPPER.readValue(value, typeReference);
        }
        catch (JsonProcessingException e) {
            throw new JsonParseException(e);
        }
    }

    public static String toBase64(String str) {
        Objects.requireNonNull(str);
        return new String(Base64.getEncoder().encode(str.trim().getBytes(CHARSET)));
    }

    public static String fromBase64(String value) {
        Objects.requireNonNull(value);
        return new String(Base64.getDecoder().decode(value.trim()), CHARSET);
    }

    @Generated
    private StringMapper() {
    }

    static {
        MAPPER.registerModule((Module)new Jdk8Module());
        MAPPER.registerModule((Module)new JavaTimeModule());
        MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

