/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.component;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.IOException;
import lombok.Generated;

@Schema(description="CATENA-X global asset id in the format urn:uuid:uuid4.")
@JsonSerialize(using=ToStringSerializer.class)
@JsonDeserialize(using=DefinitionDeserializer.class)
public final class GlobalAssetIdentification {
    private static final int GLOBAL_ASSET_ID_LENGTH = 45;
    @Valid
    @Schema(description="CATENA-X global asset id in the format urn:uuid:uuid4.", example="urn:uuid:6c311d29-5753-46d4-b32c-19b918ea93b0", minLength=45, maxLength=45, pattern="^urn:uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")
    private final String globalAssetId;

    public String toString() {
        return this.globalAssetId;
    }

    @Generated
    public String getGlobalAssetId() {
        return this.globalAssetId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalAssetIdentification)) {
            return false;
        }
        GlobalAssetIdentification other = (GlobalAssetIdentification)o;
        String this$globalAssetId = this.getGlobalAssetId();
        String other$globalAssetId = other.getGlobalAssetId();
        return !(this$globalAssetId == null ? other$globalAssetId != null : !this$globalAssetId.equals(other$globalAssetId));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $globalAssetId = this.getGlobalAssetId();
        result = result * 59 + ($globalAssetId == null ? 43 : $globalAssetId.hashCode());
        return result;
    }

    @Generated
    private GlobalAssetIdentification(String globalAssetId) {
        this.globalAssetId = globalAssetId;
    }

    @Generated
    public static GlobalAssetIdentification of(String globalAssetId) {
        return new GlobalAssetIdentification(globalAssetId);
    }

    static class DefinitionDeserializer
    extends JsonDeserializer<GlobalAssetIdentification> {
        DefinitionDeserializer() {
        }

        public GlobalAssetIdentification deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return GlobalAssetIdentification.of((String)jsonParser.readValueAs(String.class));
        }
    }
}

