/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.component;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.ZonedDateTime;
import java.util.UUID;
import lombok.Generated;
import org.eclipse.tractusx.irs.component.GlobalAssetIdentification;
import org.eclipse.tractusx.irs.component.JobErrorDetails;
import org.eclipse.tractusx.irs.component.JobParameter;
import org.eclipse.tractusx.irs.component.Summary;
import org.eclipse.tractusx.irs.component.enums.JobState;

@JsonDeserialize(builder=JobBuilder.class)
public final class Job {
    private static final int JOB_ID_FIELD_MAX_LENGTH = 36;
    private static final int GLOBAL_ASSET_ID_LENGTH = 45;
    private static final String EXAMPLE_DATE_TIME = "2022-02-03T14:48:54.709Z";
    @NotNull
    @Size(min=36, max=36)
    @Schema(description="Id of the job.", minLength=36, maxLength=36, implementation=UUID.class, pattern="/^[0-9a-f]{8}-[0-9a-f]{4}-[0-5][0-9a-f]{3}-[089ab][0-9a-f]{3}-[0-9a-f]{12}$/i", example="e5347c88-a921-11ec-b909-0242ac120002")
    @JsonAlias(value={"jobId"})
    private final @NotNull @Size(min=36, max=36) UUID id;
    @NotNull
    @Schema(implementation=String.class, description="Part global unique id in the format urn:uuid:uuid4.", example="urn:uuid:6c311d29-5753-46d4-b32c-19b918ea93b0", minLength=45, maxLength=45, pattern="^urn:uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")
    @JsonUnwrapped
    private final GlobalAssetIdentification globalAssetId;
    @NotBlank
    @JsonAlias(value={"jobState"})
    @Schema(implementation=JobState.class, example="COMPLETED")
    private final JobState state;
    @Schema(description="Job error details.", implementation=JobErrorDetails.class)
    private final JobErrorDetails exception;
    @Schema(implementation=ZonedDateTime.class, example="2022-02-03T14:48:54.709Z")
    private final ZonedDateTime createdOn;
    @Schema(implementation=ZonedDateTime.class, example="2022-02-03T14:48:54.709Z")
    private final ZonedDateTime startedOn;
    @Schema(implementation=ZonedDateTime.class, example="2022-02-03T14:48:54.709Z")
    private final ZonedDateTime lastModifiedOn;
    @Schema(implementation=ZonedDateTime.class, example="2022-02-03T14:48:54.709Z")
    @JsonAlias(value={"jobCompleted"})
    private final ZonedDateTime completedOn;
    @Schema(description="Summary of the job with statistics of the job processing.", implementation=Summary.class)
    private final Summary summary;
    @Schema(description="The passed job parameters", implementation=JobParameter.class)
    @JsonAlias(value={"jobParameter"})
    private final JobParameter parameter;

    @Generated
    public static JobBuilder builder() {
        return new JobBuilder();
    }

    @Generated
    public JobBuilder toBuilder() {
        return new JobBuilder().id(this.id).globalAssetId(this.globalAssetId).state(this.state).exception(this.exception).createdOn(this.createdOn).startedOn(this.startedOn).lastModifiedOn(this.lastModifiedOn).completedOn(this.completedOn).summary(this.summary).parameter(this.parameter);
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public GlobalAssetIdentification getGlobalAssetId() {
        return this.globalAssetId;
    }

    @Generated
    public JobState getState() {
        return this.state;
    }

    @Generated
    public JobErrorDetails getException() {
        return this.exception;
    }

    @Generated
    public ZonedDateTime getCreatedOn() {
        return this.createdOn;
    }

    @Generated
    public ZonedDateTime getStartedOn() {
        return this.startedOn;
    }

    @Generated
    public ZonedDateTime getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    @Generated
    public ZonedDateTime getCompletedOn() {
        return this.completedOn;
    }

    @Generated
    public Summary getSummary() {
        return this.summary;
    }

    @Generated
    public JobParameter getParameter() {
        return this.parameter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Job)) {
            return false;
        }
        Job other = (Job)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        GlobalAssetIdentification this$globalAssetId = this.getGlobalAssetId();
        GlobalAssetIdentification other$globalAssetId = other.getGlobalAssetId();
        if (this$globalAssetId == null ? other$globalAssetId != null : !((Object)this$globalAssetId).equals(other$globalAssetId)) {
            return false;
        }
        JobState this$state = this.getState();
        JobState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        JobErrorDetails this$exception = this.getException();
        JobErrorDetails other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !this$exception.equals(other$exception)) {
            return false;
        }
        ZonedDateTime this$createdOn = this.getCreatedOn();
        ZonedDateTime other$createdOn = other.getCreatedOn();
        if (this$createdOn == null ? other$createdOn != null : !((Object)this$createdOn).equals(other$createdOn)) {
            return false;
        }
        ZonedDateTime this$startedOn = this.getStartedOn();
        ZonedDateTime other$startedOn = other.getStartedOn();
        if (this$startedOn == null ? other$startedOn != null : !((Object)this$startedOn).equals(other$startedOn)) {
            return false;
        }
        ZonedDateTime this$lastModifiedOn = this.getLastModifiedOn();
        ZonedDateTime other$lastModifiedOn = other.getLastModifiedOn();
        if (this$lastModifiedOn == null ? other$lastModifiedOn != null : !((Object)this$lastModifiedOn).equals(other$lastModifiedOn)) {
            return false;
        }
        ZonedDateTime this$completedOn = this.getCompletedOn();
        ZonedDateTime other$completedOn = other.getCompletedOn();
        if (this$completedOn == null ? other$completedOn != null : !((Object)this$completedOn).equals(other$completedOn)) {
            return false;
        }
        Summary this$summary = this.getSummary();
        Summary other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !((Object)this$summary).equals(other$summary)) {
            return false;
        }
        JobParameter this$parameter = this.getParameter();
        JobParameter other$parameter = other.getParameter();
        return !(this$parameter == null ? other$parameter != null : !((Object)this$parameter).equals(other$parameter));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        GlobalAssetIdentification $globalAssetId = this.getGlobalAssetId();
        result = result * 59 + ($globalAssetId == null ? 43 : ((Object)$globalAssetId).hashCode());
        JobState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        JobErrorDetails $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        ZonedDateTime $createdOn = this.getCreatedOn();
        result = result * 59 + ($createdOn == null ? 43 : ((Object)$createdOn).hashCode());
        ZonedDateTime $startedOn = this.getStartedOn();
        result = result * 59 + ($startedOn == null ? 43 : ((Object)$startedOn).hashCode());
        ZonedDateTime $lastModifiedOn = this.getLastModifiedOn();
        result = result * 59 + ($lastModifiedOn == null ? 43 : ((Object)$lastModifiedOn).hashCode());
        ZonedDateTime $completedOn = this.getCompletedOn();
        result = result * 59 + ($completedOn == null ? 43 : ((Object)$completedOn).hashCode());
        Summary $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : ((Object)$summary).hashCode());
        JobParameter $parameter = this.getParameter();
        result = result * 59 + ($parameter == null ? 43 : ((Object)$parameter).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Job(id=" + this.getId() + ", globalAssetId=" + this.getGlobalAssetId() + ", state=" + this.getState() + ", exception=" + this.getException() + ", createdOn=" + this.getCreatedOn() + ", startedOn=" + this.getStartedOn() + ", lastModifiedOn=" + this.getLastModifiedOn() + ", completedOn=" + this.getCompletedOn() + ", summary=" + this.getSummary() + ", parameter=" + this.getParameter() + ")";
    }

    @Generated
    public Job(UUID id, GlobalAssetIdentification globalAssetId, JobState state, JobErrorDetails exception, ZonedDateTime createdOn, ZonedDateTime startedOn, ZonedDateTime lastModifiedOn, ZonedDateTime completedOn, Summary summary, JobParameter parameter) {
        this.id = id;
        this.globalAssetId = globalAssetId;
        this.state = state;
        this.exception = exception;
        this.createdOn = createdOn;
        this.startedOn = startedOn;
        this.lastModifiedOn = lastModifiedOn;
        this.completedOn = completedOn;
        this.summary = summary;
        this.parameter = parameter;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class JobBuilder {
        @Generated
        private UUID id;
        @Generated
        private GlobalAssetIdentification globalAssetId;
        @Generated
        private JobState state;
        @Generated
        private JobErrorDetails exception;
        @Generated
        private ZonedDateTime createdOn;
        @Generated
        private ZonedDateTime startedOn;
        @Generated
        private ZonedDateTime lastModifiedOn;
        @Generated
        private ZonedDateTime completedOn;
        @Generated
        private Summary summary;
        @Generated
        private JobParameter parameter;

        @Generated
        JobBuilder() {
        }

        @JsonAlias(value={"jobId"})
        @Generated
        public JobBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        @JsonUnwrapped
        @Generated
        public JobBuilder globalAssetId(GlobalAssetIdentification globalAssetId) {
            this.globalAssetId = globalAssetId;
            return this;
        }

        @JsonAlias(value={"jobState"})
        @Generated
        public JobBuilder state(JobState state) {
            this.state = state;
            return this;
        }

        @Generated
        public JobBuilder exception(JobErrorDetails exception) {
            this.exception = exception;
            return this;
        }

        @Generated
        public JobBuilder createdOn(ZonedDateTime createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        @Generated
        public JobBuilder startedOn(ZonedDateTime startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        @Generated
        public JobBuilder lastModifiedOn(ZonedDateTime lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        @JsonAlias(value={"jobCompleted"})
        @Generated
        public JobBuilder completedOn(ZonedDateTime completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        @Generated
        public JobBuilder summary(Summary summary) {
            this.summary = summary;
            return this;
        }

        @JsonAlias(value={"jobParameter"})
        @Generated
        public JobBuilder parameter(JobParameter parameter) {
            this.parameter = parameter;
            return this;
        }

        @Generated
        public Job build() {
            return new Job(this.id, this.globalAssetId, this.state, this.exception, this.createdOn, this.startedOn, this.lastModifiedOn, this.completedOn, this.summary, this.parameter);
        }

        @Generated
        public String toString() {
            return "Job.JobBuilder(id=" + this.id + ", globalAssetId=" + this.globalAssetId + ", state=" + this.state + ", exception=" + this.exception + ", createdOn=" + this.createdOn + ", startedOn=" + this.startedOn + ", lastModifiedOn=" + this.lastModifiedOn + ", completedOn=" + this.completedOn + ", summary=" + this.summary + ", parameter=" + this.parameter + ")";
        }
    }
}

