/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.component;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.eclipse.tractusx.irs.component.GlobalAssetIdentification;
import org.eclipse.tractusx.irs.component.Quantity;
import org.eclipse.tractusx.irs.component.enums.BomLifecycle;

@Schema(description="Set of child parts the parent object is assembled by (one structural level down).")
@JsonDeserialize(builder=LinkedItemBuilder.class)
public final class LinkedItem {
    private static final int GLOBAL_ASSET_ID_LENGTH = 45;
    @Schema(description="Quantity component.", implementation=Quantity.class)
    private final Quantity quantity;
    @Schema(description="The lifecycle context in which the child part was assembled into the parent part.", implementation=BomLifecycle.class, example="asBuilt")
    private final BomLifecycle lifecycleContext;
    @Schema(description="Datetime of assembly.", implementation=ZonedDateTime.class, example="2022-02-03T14:48:54.709Z")
    private final ZonedDateTime assembledOn;
    @Schema(description="Last datetime item was modified.", implementation=ZonedDateTime.class, example="2022-02-03T14:48:54.709Z")
    private final ZonedDateTime lastModifiedOn;
    @Schema(implementation=String.class, description="CatenaX child global asset id in the format urn:uuid:uuid4.", example="urn:uuid:6c311d29-5753-46d4-b32c-19b918ea93b0", minLength=45, maxLength=45, pattern="^urn:uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")
    @JsonUnwrapped
    private final GlobalAssetIdentification childCatenaXId;
    @Schema(description="Expresses whether the part is built-in or whether it is one of several options.", implementation=Boolean.class)
    private final boolean hasAlternatives;

    @Generated
    public static LinkedItemBuilder builder() {
        return new LinkedItemBuilder();
    }

    @Generated
    public LinkedItemBuilder toBuilder() {
        return new LinkedItemBuilder().quantity(this.quantity).lifecycleContext(this.lifecycleContext).assembledOn(this.assembledOn).lastModifiedOn(this.lastModifiedOn).childCatenaXId(this.childCatenaXId).hasAlternatives(this.hasAlternatives);
    }

    @Generated
    public Quantity getQuantity() {
        return this.quantity;
    }

    @Generated
    public BomLifecycle getLifecycleContext() {
        return this.lifecycleContext;
    }

    @Generated
    public ZonedDateTime getAssembledOn() {
        return this.assembledOn;
    }

    @Generated
    public ZonedDateTime getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    @Generated
    public GlobalAssetIdentification getChildCatenaXId() {
        return this.childCatenaXId;
    }

    @Generated
    public boolean isHasAlternatives() {
        return this.hasAlternatives;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinkedItem)) {
            return false;
        }
        LinkedItem other = (LinkedItem)o;
        if (this.isHasAlternatives() != other.isHasAlternatives()) {
            return false;
        }
        Quantity this$quantity = this.getQuantity();
        Quantity other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        BomLifecycle this$lifecycleContext = this.getLifecycleContext();
        BomLifecycle other$lifecycleContext = other.getLifecycleContext();
        if (this$lifecycleContext == null ? other$lifecycleContext != null : !((Object)((Object)this$lifecycleContext)).equals((Object)other$lifecycleContext)) {
            return false;
        }
        ZonedDateTime this$assembledOn = this.getAssembledOn();
        ZonedDateTime other$assembledOn = other.getAssembledOn();
        if (this$assembledOn == null ? other$assembledOn != null : !((Object)this$assembledOn).equals(other$assembledOn)) {
            return false;
        }
        ZonedDateTime this$lastModifiedOn = this.getLastModifiedOn();
        ZonedDateTime other$lastModifiedOn = other.getLastModifiedOn();
        if (this$lastModifiedOn == null ? other$lastModifiedOn != null : !((Object)this$lastModifiedOn).equals(other$lastModifiedOn)) {
            return false;
        }
        GlobalAssetIdentification this$childCatenaXId = this.getChildCatenaXId();
        GlobalAssetIdentification other$childCatenaXId = other.getChildCatenaXId();
        return !(this$childCatenaXId == null ? other$childCatenaXId != null : !((Object)this$childCatenaXId).equals(other$childCatenaXId));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHasAlternatives() ? 79 : 97);
        Quantity $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        BomLifecycle $lifecycleContext = this.getLifecycleContext();
        result = result * 59 + ($lifecycleContext == null ? 43 : ((Object)((Object)$lifecycleContext)).hashCode());
        ZonedDateTime $assembledOn = this.getAssembledOn();
        result = result * 59 + ($assembledOn == null ? 43 : ((Object)$assembledOn).hashCode());
        ZonedDateTime $lastModifiedOn = this.getLastModifiedOn();
        result = result * 59 + ($lastModifiedOn == null ? 43 : ((Object)$lastModifiedOn).hashCode());
        GlobalAssetIdentification $childCatenaXId = this.getChildCatenaXId();
        result = result * 59 + ($childCatenaXId == null ? 43 : ((Object)$childCatenaXId).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LinkedItem(quantity=" + this.getQuantity() + ", lifecycleContext=" + this.getLifecycleContext() + ", assembledOn=" + this.getAssembledOn() + ", lastModifiedOn=" + this.getLastModifiedOn() + ", childCatenaXId=" + this.getChildCatenaXId() + ", hasAlternatives=" + this.isHasAlternatives() + ")";
    }

    @Generated
    public LinkedItem(Quantity quantity, BomLifecycle lifecycleContext, ZonedDateTime assembledOn, ZonedDateTime lastModifiedOn, GlobalAssetIdentification childCatenaXId, boolean hasAlternatives) {
        this.quantity = quantity;
        this.lifecycleContext = lifecycleContext;
        this.assembledOn = assembledOn;
        this.lastModifiedOn = lastModifiedOn;
        this.childCatenaXId = childCatenaXId;
        this.hasAlternatives = hasAlternatives;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class LinkedItemBuilder {
        @Generated
        private Quantity quantity;
        @Generated
        private BomLifecycle lifecycleContext;
        @Generated
        private ZonedDateTime assembledOn;
        @Generated
        private ZonedDateTime lastModifiedOn;
        @Generated
        private GlobalAssetIdentification childCatenaXId;
        @Generated
        private boolean hasAlternatives;

        @Generated
        LinkedItemBuilder() {
        }

        @Generated
        public LinkedItemBuilder quantity(Quantity quantity) {
            this.quantity = quantity;
            return this;
        }

        @Generated
        public LinkedItemBuilder lifecycleContext(BomLifecycle lifecycleContext) {
            this.lifecycleContext = lifecycleContext;
            return this;
        }

        @Generated
        public LinkedItemBuilder assembledOn(ZonedDateTime assembledOn) {
            this.assembledOn = assembledOn;
            return this;
        }

        @Generated
        public LinkedItemBuilder lastModifiedOn(ZonedDateTime lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        @JsonUnwrapped
        @Generated
        public LinkedItemBuilder childCatenaXId(GlobalAssetIdentification childCatenaXId) {
            this.childCatenaXId = childCatenaXId;
            return this;
        }

        @Generated
        public LinkedItemBuilder hasAlternatives(boolean hasAlternatives) {
            this.hasAlternatives = hasAlternatives;
            return this;
        }

        @Generated
        public LinkedItem build() {
            return new LinkedItem(this.quantity, this.lifecycleContext, this.assembledOn, this.lastModifiedOn, this.childCatenaXId, this.hasAlternatives);
        }

        @Generated
        public String toString() {
            return "LinkedItem.LinkedItemBuilder(quantity=" + this.quantity + ", lifecycleContext=" + this.lifecycleContext + ", assembledOn=" + this.assembledOn + ", lastModifiedOn=" + this.lastModifiedOn + ", childCatenaXId=" + this.childCatenaXId + ", hasAlternatives=" + this.hasAlternatives + ")";
        }
    }
}

