/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.component;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import lombok.Generated;

@Schema(description="Key object contains required attributes for identify part chain entry node.")
public class PartChainIdentificationKey {
    private static final String GLOBAL_ASSET_ID_REGEX = "^urn:uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$";
    private static final int UUID_SIZE = 36;
    private static final int URN_PREFIX_SIZE = 9;
    private static final int GLOBAL_ASSET_ID_SIZE = 45;
    private static final String BPN_REGEX = "^(BPN)(L|S|A)(\\d{10})([a-zA-Z0-9]{2})$";
    private static final int BPN_SIZE = 16;
    @Pattern(regexp="^urn:uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")
    @NotBlank
    @Size(min=45, max=45)
    @Schema(description="Id of global asset.", example="urn:uuid:6c311d29-5753-46d4-b32c-19b918ea93b0", implementation=String.class, minLength=45, maxLength=45)
    private @Pattern(regexp="^urn:uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$") @NotBlank @Size(min=45, max=45) String globalAssetId;
    @Size(min=16, max=16)
    @NotBlank
    @Schema(description="BPN of partner providing the initial asset", example="BPNL0123456789XX", implementation=String.class, minLength=16, maxLength=16)
    private @Size(min=16, max=16) @NotBlank String bpn;

    @Generated
    public static PartChainIdentificationKeyBuilder builder() {
        return new PartChainIdentificationKeyBuilder();
    }

    @Generated
    public String getGlobalAssetId() {
        return this.globalAssetId;
    }

    @Generated
    public String getBpn() {
        return this.bpn;
    }

    @Generated
    public void setGlobalAssetId(String globalAssetId) {
        this.globalAssetId = globalAssetId;
    }

    @Generated
    public void setBpn(String bpn) {
        this.bpn = bpn;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartChainIdentificationKey)) {
            return false;
        }
        PartChainIdentificationKey other = (PartChainIdentificationKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$globalAssetId = this.getGlobalAssetId();
        String other$globalAssetId = other.getGlobalAssetId();
        if (this$globalAssetId == null ? other$globalAssetId != null : !this$globalAssetId.equals(other$globalAssetId)) {
            return false;
        }
        String this$bpn = this.getBpn();
        String other$bpn = other.getBpn();
        return !(this$bpn == null ? other$bpn != null : !this$bpn.equals(other$bpn));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PartChainIdentificationKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $globalAssetId = this.getGlobalAssetId();
        result = result * 59 + ($globalAssetId == null ? 43 : $globalAssetId.hashCode());
        String $bpn = this.getBpn();
        result = result * 59 + ($bpn == null ? 43 : $bpn.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PartChainIdentificationKey(globalAssetId=" + this.getGlobalAssetId() + ", bpn=" + this.getBpn() + ")";
    }

    @Generated
    public PartChainIdentificationKey() {
    }

    @Generated
    public PartChainIdentificationKey(String globalAssetId, String bpn) {
        this.globalAssetId = globalAssetId;
        this.bpn = bpn;
    }

    @Generated
    public static class PartChainIdentificationKeyBuilder {
        @Generated
        private String globalAssetId;
        @Generated
        private String bpn;

        @Generated
        PartChainIdentificationKeyBuilder() {
        }

        @Generated
        public PartChainIdentificationKeyBuilder globalAssetId(String globalAssetId) {
            this.globalAssetId = globalAssetId;
            return this;
        }

        @Generated
        public PartChainIdentificationKeyBuilder bpn(String bpn) {
            this.bpn = bpn;
            return this;
        }

        @Generated
        public PartChainIdentificationKey build() {
            return new PartChainIdentificationKey(this.globalAssetId, this.bpn);
        }

        @Generated
        public String toString() {
            return "PartChainIdentificationKey.PartChainIdentificationKeyBuilder(globalAssetId=" + this.globalAssetId + ", bpn=" + this.bpn + ")";
        }
    }
}

