/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.component;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.time.ZonedDateTime;
import java.util.List;
import lombok.Generated;
import org.eclipse.tractusx.irs.component.enums.ProcessStep;

@JsonDeserialize(builder=ProcessingErrorBuilder.class)
public final class ProcessingError {
    private final ProcessStep processStep;
    private final String errorDetail;
    private final ZonedDateTime lastAttempt;
    private final List<String> rootCauses;
    @Schema(implementation=Integer.class)
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    private final @Min(value=0L) @Max(value=0x7FFFFFFFL) int retryCounter;

    @Generated
    ProcessingError(ProcessStep processStep, String errorDetail, ZonedDateTime lastAttempt, List<String> rootCauses, int retryCounter) {
        this.processStep = processStep;
        this.errorDetail = errorDetail;
        this.lastAttempt = lastAttempt;
        this.rootCauses = rootCauses;
        this.retryCounter = retryCounter;
    }

    @Generated
    public static ProcessingErrorBuilder builder() {
        return new ProcessingErrorBuilder();
    }

    @Generated
    public ProcessingErrorBuilder toBuilder() {
        return new ProcessingErrorBuilder().withProcessStep(this.processStep).withErrorDetail(this.errorDetail).withLastAttempt(this.lastAttempt).withRootCauses(this.rootCauses).withRetryCounter(this.retryCounter);
    }

    @Generated
    public ProcessStep getProcessStep() {
        return this.processStep;
    }

    @Generated
    public String getErrorDetail() {
        return this.errorDetail;
    }

    @Generated
    public ZonedDateTime getLastAttempt() {
        return this.lastAttempt;
    }

    @Generated
    public List<String> getRootCauses() {
        return this.rootCauses;
    }

    @Generated
    public int getRetryCounter() {
        return this.retryCounter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessingError)) {
            return false;
        }
        ProcessingError other = (ProcessingError)o;
        if (this.getRetryCounter() != other.getRetryCounter()) {
            return false;
        }
        ProcessStep this$processStep = this.getProcessStep();
        ProcessStep other$processStep = other.getProcessStep();
        if (this$processStep == null ? other$processStep != null : !((Object)((Object)this$processStep)).equals((Object)other$processStep)) {
            return false;
        }
        String this$errorDetail = this.getErrorDetail();
        String other$errorDetail = other.getErrorDetail();
        if (this$errorDetail == null ? other$errorDetail != null : !this$errorDetail.equals(other$errorDetail)) {
            return false;
        }
        ZonedDateTime this$lastAttempt = this.getLastAttempt();
        ZonedDateTime other$lastAttempt = other.getLastAttempt();
        if (this$lastAttempt == null ? other$lastAttempt != null : !((Object)this$lastAttempt).equals(other$lastAttempt)) {
            return false;
        }
        List<String> this$rootCauses = this.getRootCauses();
        List<String> other$rootCauses = other.getRootCauses();
        return !(this$rootCauses == null ? other$rootCauses != null : !((Object)this$rootCauses).equals(other$rootCauses));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRetryCounter();
        ProcessStep $processStep = this.getProcessStep();
        result = result * 59 + ($processStep == null ? 43 : ((Object)((Object)$processStep)).hashCode());
        String $errorDetail = this.getErrorDetail();
        result = result * 59 + ($errorDetail == null ? 43 : $errorDetail.hashCode());
        ZonedDateTime $lastAttempt = this.getLastAttempt();
        result = result * 59 + ($lastAttempt == null ? 43 : ((Object)$lastAttempt).hashCode());
        List<String> $rootCauses = this.getRootCauses();
        result = result * 59 + ($rootCauses == null ? 43 : ((Object)$rootCauses).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProcessingError(processStep=" + this.getProcessStep() + ", errorDetail=" + this.getErrorDetail() + ", lastAttempt=" + this.getLastAttempt() + ", rootCauses=" + this.getRootCauses() + ", retryCounter=" + this.getRetryCounter() + ")";
    }

    @JsonPOJOBuilder
    public static class ProcessingErrorBuilder {
        @Generated
        private ProcessStep processStep;
        @Generated
        private String errorDetail;
        @Generated
        private ZonedDateTime lastAttempt;
        @Generated
        private List<String> rootCauses;
        @Generated
        private int retryCounter;

        @Generated
        ProcessingErrorBuilder() {
        }

        @Generated
        public ProcessingErrorBuilder withProcessStep(ProcessStep processStep) {
            this.processStep = processStep;
            return this;
        }

        @Generated
        public ProcessingErrorBuilder withErrorDetail(String errorDetail) {
            this.errorDetail = errorDetail;
            return this;
        }

        @Generated
        public ProcessingErrorBuilder withLastAttempt(ZonedDateTime lastAttempt) {
            this.lastAttempt = lastAttempt;
            return this;
        }

        @Generated
        public ProcessingErrorBuilder withRootCauses(List<String> rootCauses) {
            this.rootCauses = rootCauses;
            return this;
        }

        @Generated
        public ProcessingErrorBuilder withRetryCounter(int retryCounter) {
            this.retryCounter = retryCounter;
            return this;
        }

        @Generated
        public ProcessingError build() {
            return new ProcessingError(this.processStep, this.errorDetail, this.lastAttempt, this.rootCauses, this.retryCounter);
        }

        @Generated
        public String toString() {
            return "ProcessingError.ProcessingErrorBuilder(processStep=" + this.processStep + ", errorDetail=" + this.errorDetail + ", lastAttempt=" + this.lastAttempt + ", rootCauses=" + this.rootCauses + ", retryCounter=" + this.retryCounter + ")";
        }
    }
}

