/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.component;

import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.eclipse.tractusx.irs.component.PartChainIdentificationKey;
import org.eclipse.tractusx.irs.component.enums.BatchStrategy;
import org.eclipse.tractusx.irs.component.enums.BomLifecycle;
import org.eclipse.tractusx.irs.validators.Mod10;
import org.hibernate.validator.constraints.URL;

@Schema(description="Request body for registering a new Batch Order for ESS Investigation Job.")
public class RegisterBpnInvestigationBatchOrder {
    private static final String BPN_REGEX = "(BPN)[LSA][\\w\\d]{10}[\\w\\d]{2}";
    @NotEmpty
    @ArraySchema(schema=@Schema(description="Array of BPNS numbers.", example="BPNS000000000DDD", implementation=String.class, pattern="(BPN)[LSA][\\w\\d]{10}[\\w\\d]{2}"), maxItems=0x7FFFFFFF)
    private @NotEmpty List<@Pattern(regexp="(BPN)[LSA][\\w\\d]{10}[\\w\\d]{2}") String> incidentBPNSs;
    @NotEmpty
    @Valid
    @ArraySchema(schema=@Schema(description="Keys array contains required attributes for identify part chain entry node ", implementation=PartChainIdentificationKey.class), maxItems=0x7FFFFFFF)
    private Set<PartChainIdentificationKey> keys;
    @Schema(description="BoM Lifecycle of the result tree.", implementation=BomLifecycle.class)
    private BomLifecycle bomLifecycle;
    @URL
    @Schema(description="Callback url to notify requestor when job processing is finished. There are four uri variable placeholders that can be used: orderId, batchId, orderState and batchState.", example="https://hostname.com/callback?orderId={orderId}&batchId={batchId}&orderState={orderState}&batchState={batchState}")
    private String callbackUrl;
    @Schema(implementation=Integer.class, minimum="10", maximum="100", defaultValue="20", description="Size of the batch.")
    @Min(value=10L)
    @Max(value=100L)
    @Mod10(message="Batch size value must be mod 10 compliant")
    private @Min(value=10L) @Max(value=100L) Integer batchSize = 20;
    @Schema(implementation=Integer.class, minimum="60", maximum="86400", defaultValue="43200", description="Timeout in seconds for the complete batch order processing.")
    @Min(value=60L)
    @Max(value=86400L)
    private @Min(value=60L) @Max(value=86400L) Integer timeout = 43200;
    @Schema(implementation=Integer.class, minimum="60", maximum="7200", defaultValue="3600", description="Timeout in seconds for each job processing inside the complete order.")
    @Min(value=60L)
    @Max(value=7200L)
    private @Min(value=60L) @Max(value=7200L) Integer jobTimeout = 3600;
    @Schema(implementation=BatchStrategy.class, description="The strategy how the batch is processed internally in IRS.")
    private BatchStrategy batchStrategy;

    @Generated
    public static RegisterBpnInvestigationBatchOrderBuilder builder() {
        return new RegisterBpnInvestigationBatchOrderBuilder();
    }

    @Generated
    public List<@Pattern(regexp="(BPN)[LSA][\\w\\d]{10}[\\w\\d]{2}") String> getIncidentBPNSs() {
        return this.incidentBPNSs;
    }

    @Generated
    public Set<PartChainIdentificationKey> getKeys() {
        return this.keys;
    }

    @Generated
    public BomLifecycle getBomLifecycle() {
        return this.bomLifecycle;
    }

    @Generated
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @Generated
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public Integer getTimeout() {
        return this.timeout;
    }

    @Generated
    public Integer getJobTimeout() {
        return this.jobTimeout;
    }

    @Generated
    public BatchStrategy getBatchStrategy() {
        return this.batchStrategy;
    }

    @Generated
    public void setIncidentBPNSs(List<@Pattern(regexp="(BPN)[LSA][\\w\\d]{10}[\\w\\d]{2}") String> incidentBPNSs) {
        this.incidentBPNSs = incidentBPNSs;
    }

    @Generated
    public void setKeys(Set<PartChainIdentificationKey> keys) {
        this.keys = keys;
    }

    @Generated
    public void setBomLifecycle(BomLifecycle bomLifecycle) {
        this.bomLifecycle = bomLifecycle;
    }

    @Generated
    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    @Generated
    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    @Generated
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setJobTimeout(Integer jobTimeout) {
        this.jobTimeout = jobTimeout;
    }

    @Generated
    public void setBatchStrategy(BatchStrategy batchStrategy) {
        this.batchStrategy = batchStrategy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisterBpnInvestigationBatchOrder)) {
            return false;
        }
        RegisterBpnInvestigationBatchOrder other = (RegisterBpnInvestigationBatchOrder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$batchSize = this.getBatchSize();
        Integer other$batchSize = other.getBatchSize();
        if (this$batchSize == null ? other$batchSize != null : !((Object)this$batchSize).equals(other$batchSize)) {
            return false;
        }
        Integer this$timeout = this.getTimeout();
        Integer other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        Integer this$jobTimeout = this.getJobTimeout();
        Integer other$jobTimeout = other.getJobTimeout();
        if (this$jobTimeout == null ? other$jobTimeout != null : !((Object)this$jobTimeout).equals(other$jobTimeout)) {
            return false;
        }
        List<String> this$incidentBPNSs = this.getIncidentBPNSs();
        List<String> other$incidentBPNSs = other.getIncidentBPNSs();
        if (this$incidentBPNSs == null ? other$incidentBPNSs != null : !((Object)this$incidentBPNSs).equals(other$incidentBPNSs)) {
            return false;
        }
        Set<PartChainIdentificationKey> this$keys = this.getKeys();
        Set<PartChainIdentificationKey> other$keys = other.getKeys();
        if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
            return false;
        }
        BomLifecycle this$bomLifecycle = this.getBomLifecycle();
        BomLifecycle other$bomLifecycle = other.getBomLifecycle();
        if (this$bomLifecycle == null ? other$bomLifecycle != null : !((Object)((Object)this$bomLifecycle)).equals((Object)other$bomLifecycle)) {
            return false;
        }
        String this$callbackUrl = this.getCallbackUrl();
        String other$callbackUrl = other.getCallbackUrl();
        if (this$callbackUrl == null ? other$callbackUrl != null : !this$callbackUrl.equals(other$callbackUrl)) {
            return false;
        }
        BatchStrategy this$batchStrategy = this.getBatchStrategy();
        BatchStrategy other$batchStrategy = other.getBatchStrategy();
        return !(this$batchStrategy == null ? other$batchStrategy != null : !((Object)((Object)this$batchStrategy)).equals((Object)other$batchStrategy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RegisterBpnInvestigationBatchOrder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $batchSize = this.getBatchSize();
        result = result * 59 + ($batchSize == null ? 43 : ((Object)$batchSize).hashCode());
        Integer $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        Integer $jobTimeout = this.getJobTimeout();
        result = result * 59 + ($jobTimeout == null ? 43 : ((Object)$jobTimeout).hashCode());
        List<String> $incidentBPNSs = this.getIncidentBPNSs();
        result = result * 59 + ($incidentBPNSs == null ? 43 : ((Object)$incidentBPNSs).hashCode());
        Set<PartChainIdentificationKey> $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        BomLifecycle $bomLifecycle = this.getBomLifecycle();
        result = result * 59 + ($bomLifecycle == null ? 43 : ((Object)((Object)$bomLifecycle)).hashCode());
        String $callbackUrl = this.getCallbackUrl();
        result = result * 59 + ($callbackUrl == null ? 43 : $callbackUrl.hashCode());
        BatchStrategy $batchStrategy = this.getBatchStrategy();
        result = result * 59 + ($batchStrategy == null ? 43 : ((Object)((Object)$batchStrategy)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RegisterBpnInvestigationBatchOrder(incidentBPNSs=" + this.getIncidentBPNSs() + ", keys=" + this.getKeys() + ", bomLifecycle=" + this.getBomLifecycle() + ", callbackUrl=" + this.getCallbackUrl() + ", batchSize=" + this.getBatchSize() + ", timeout=" + this.getTimeout() + ", jobTimeout=" + this.getJobTimeout() + ", batchStrategy=" + this.getBatchStrategy() + ")";
    }

    @Generated
    public RegisterBpnInvestigationBatchOrder() {
    }

    @Generated
    public RegisterBpnInvestigationBatchOrder(List<@Pattern(regexp="(BPN)[LSA][\\w\\d]{10}[\\w\\d]{2}") String> incidentBPNSs, Set<PartChainIdentificationKey> keys, BomLifecycle bomLifecycle, String callbackUrl, Integer batchSize, Integer timeout, Integer jobTimeout, BatchStrategy batchStrategy) {
        this.incidentBPNSs = incidentBPNSs;
        this.keys = keys;
        this.bomLifecycle = bomLifecycle;
        this.callbackUrl = callbackUrl;
        this.batchSize = batchSize;
        this.timeout = timeout;
        this.jobTimeout = jobTimeout;
        this.batchStrategy = batchStrategy;
    }

    static final class RegisterBatchOrderConstants {
        static final String MIN_BATCH_SIZE_DESC = "10";
        static final String MAX_BATCH_SIZE_DESC = "100";
        static final String DEFAULT_BATCH_SIZE_DESC = "20";
        static final int MIN_BATCH_SIZE = 10;
        static final int MAX_BATCH_SIZE = 100;
        static final int DEFAULT_BATCH_SIZE = 20;
        static final String MIN_TIMEOUT_DESC = "60";
        static final String MAX_TIMEOUT_DESC = "86400";
        static final String DEFAULT_TIMEOUT_DESC = "43200";
        static final int MIN_TIMEOUT = 60;
        static final int MAX_TIMEOUT = 86400;
        static final int DEFAULT_TIMEOUT = 43200;
        static final String MIN_JOB_TIMEOUT_DESC = "60";
        static final String MAX_JOB_TIMEOUT_DESC = "7200";
        static final String DEFAULT_JOB_TIMEOUT_DESC = "3600";
        static final int MIN_JOB_TIMEOUT = 60;
        static final int MAX_JOB_TIMEOUT = 7200;
        static final int DEFAULT_JOB_TIMEOUT = 3600;
        static final String GLOBAL_ASSET_ID_REGEX = "^urn:uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$";

        @Generated
        private RegisterBatchOrderConstants() {
        }
    }

    @Generated
    public static class RegisterBpnInvestigationBatchOrderBuilder {
        @Generated
        private List<@Pattern(regexp="(BPN)[LSA][\\w\\d]{10}[\\w\\d]{2}") String> incidentBPNSs;
        @Generated
        private Set<PartChainIdentificationKey> keys;
        @Generated
        private BomLifecycle bomLifecycle;
        @Generated
        private String callbackUrl;
        @Generated
        private Integer batchSize;
        @Generated
        private Integer timeout;
        @Generated
        private Integer jobTimeout;
        @Generated
        private BatchStrategy batchStrategy;

        @Generated
        RegisterBpnInvestigationBatchOrderBuilder() {
        }

        @Generated
        public RegisterBpnInvestigationBatchOrderBuilder incidentBPNSs(List<@Pattern(regexp="(BPN)[LSA][\\w\\d]{10}[\\w\\d]{2}") String> incidentBPNSs) {
            this.incidentBPNSs = incidentBPNSs;
            return this;
        }

        @Generated
        public RegisterBpnInvestigationBatchOrderBuilder keys(Set<PartChainIdentificationKey> keys) {
            this.keys = keys;
            return this;
        }

        @Generated
        public RegisterBpnInvestigationBatchOrderBuilder bomLifecycle(BomLifecycle bomLifecycle) {
            this.bomLifecycle = bomLifecycle;
            return this;
        }

        @Generated
        public RegisterBpnInvestigationBatchOrderBuilder callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        @Generated
        public RegisterBpnInvestigationBatchOrderBuilder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @Generated
        public RegisterBpnInvestigationBatchOrderBuilder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public RegisterBpnInvestigationBatchOrderBuilder jobTimeout(Integer jobTimeout) {
            this.jobTimeout = jobTimeout;
            return this;
        }

        @Generated
        public RegisterBpnInvestigationBatchOrderBuilder batchStrategy(BatchStrategy batchStrategy) {
            this.batchStrategy = batchStrategy;
            return this;
        }

        @Generated
        public RegisterBpnInvestigationBatchOrder build() {
            return new RegisterBpnInvestigationBatchOrder(this.incidentBPNSs, this.keys, this.bomLifecycle, this.callbackUrl, this.batchSize, this.timeout, this.jobTimeout, this.batchStrategy);
        }

        @Generated
        public String toString() {
            return "RegisterBpnInvestigationBatchOrder.RegisterBpnInvestigationBatchOrderBuilder(incidentBPNSs=" + this.incidentBPNSs + ", keys=" + this.keys + ", bomLifecycle=" + this.bomLifecycle + ", callbackUrl=" + this.callbackUrl + ", batchSize=" + this.batchSize + ", timeout=" + this.timeout + ", jobTimeout=" + this.jobTimeout + ", batchStrategy=" + this.batchStrategy + ")";
        }
    }
}

