/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.component;

import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.eclipse.tractusx.irs.component.PartChainIdentificationKey;
import org.eclipse.tractusx.irs.component.enums.BomLifecycle;
import org.hibernate.validator.constraints.URL;

@Schema(description="The requested job definition.")
public class RegisterBpnInvestigationJob {
    private static final String BPN_REGEX = "(BPN)[LSA][\\w\\d]{10}[\\w\\d]{2}";
    @NotNull
    @Valid
    @Schema(description="Key object contains required attributes for identify part chain entry node.", implementation=PartChainIdentificationKey.class)
    private PartChainIdentificationKey key;
    @NotEmpty
    @ArraySchema(arraySchema=@Schema(description="Array of BPNS numbers.", example="[\"BPNS000000000DDD\"]", implementation=String.class, pattern="(BPN)[LSA][\\w\\d]{10}[\\w\\d]{2}"), maxItems=0x7FFFFFFF)
    private @NotEmpty List<@Pattern(regexp="(BPN)[LSA][\\w\\d]{10}[\\w\\d]{2}") String> incidentBPNSs;
    @Schema(description="BoM Lifecycle of the result tree.", implementation=BomLifecycle.class, example="asPlanned")
    private BomLifecycle bomLifecycle;
    @URL
    @Schema(description="Callback url to notify requestor when job processing is finished. There are two uri variable placeholders that can be used: jobId and jobState.", example="https://hostname.com/callback?jobId={jobId}&jobState={jobState}")
    private String callbackUrl;

    @Generated
    public static RegisterBpnInvestigationJobBuilder builder() {
        return new RegisterBpnInvestigationJobBuilder();
    }

    @Generated
    public PartChainIdentificationKey getKey() {
        return this.key;
    }

    @Generated
    public List<@Pattern(regexp="(BPN)[LSA][\\w\\d]{10}[\\w\\d]{2}") String> getIncidentBPNSs() {
        return this.incidentBPNSs;
    }

    @Generated
    public BomLifecycle getBomLifecycle() {
        return this.bomLifecycle;
    }

    @Generated
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @Generated
    public void setKey(PartChainIdentificationKey key) {
        this.key = key;
    }

    @Generated
    public void setIncidentBPNSs(List<@Pattern(regexp="(BPN)[LSA][\\w\\d]{10}[\\w\\d]{2}") String> incidentBPNSs) {
        this.incidentBPNSs = incidentBPNSs;
    }

    @Generated
    public void setBomLifecycle(BomLifecycle bomLifecycle) {
        this.bomLifecycle = bomLifecycle;
    }

    @Generated
    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisterBpnInvestigationJob)) {
            return false;
        }
        RegisterBpnInvestigationJob other = (RegisterBpnInvestigationJob)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PartChainIdentificationKey this$key = this.getKey();
        PartChainIdentificationKey other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        List<String> this$incidentBPNSs = this.getIncidentBPNSs();
        List<String> other$incidentBPNSs = other.getIncidentBPNSs();
        if (this$incidentBPNSs == null ? other$incidentBPNSs != null : !((Object)this$incidentBPNSs).equals(other$incidentBPNSs)) {
            return false;
        }
        BomLifecycle this$bomLifecycle = this.getBomLifecycle();
        BomLifecycle other$bomLifecycle = other.getBomLifecycle();
        if (this$bomLifecycle == null ? other$bomLifecycle != null : !((Object)((Object)this$bomLifecycle)).equals((Object)other$bomLifecycle)) {
            return false;
        }
        String this$callbackUrl = this.getCallbackUrl();
        String other$callbackUrl = other.getCallbackUrl();
        return !(this$callbackUrl == null ? other$callbackUrl != null : !this$callbackUrl.equals(other$callbackUrl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RegisterBpnInvestigationJob;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PartChainIdentificationKey $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        List<String> $incidentBPNSs = this.getIncidentBPNSs();
        result = result * 59 + ($incidentBPNSs == null ? 43 : ((Object)$incidentBPNSs).hashCode());
        BomLifecycle $bomLifecycle = this.getBomLifecycle();
        result = result * 59 + ($bomLifecycle == null ? 43 : ((Object)((Object)$bomLifecycle)).hashCode());
        String $callbackUrl = this.getCallbackUrl();
        result = result * 59 + ($callbackUrl == null ? 43 : $callbackUrl.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RegisterBpnInvestigationJob(key=" + this.getKey() + ", incidentBPNSs=" + this.getIncidentBPNSs() + ", bomLifecycle=" + this.getBomLifecycle() + ", callbackUrl=" + this.getCallbackUrl() + ")";
    }

    @Generated
    public RegisterBpnInvestigationJob() {
    }

    @Generated
    public RegisterBpnInvestigationJob(PartChainIdentificationKey key, List<@Pattern(regexp="(BPN)[LSA][\\w\\d]{10}[\\w\\d]{2}") String> incidentBPNSs, BomLifecycle bomLifecycle, String callbackUrl) {
        this.key = key;
        this.incidentBPNSs = incidentBPNSs;
        this.bomLifecycle = bomLifecycle;
        this.callbackUrl = callbackUrl;
    }

    @Generated
    public static class RegisterBpnInvestigationJobBuilder {
        @Generated
        private PartChainIdentificationKey key;
        @Generated
        private List<@Pattern(regexp="(BPN)[LSA][\\w\\d]{10}[\\w\\d]{2}") String> incidentBPNSs;
        @Generated
        private BomLifecycle bomLifecycle;
        @Generated
        private String callbackUrl;

        @Generated
        RegisterBpnInvestigationJobBuilder() {
        }

        @Generated
        public RegisterBpnInvestigationJobBuilder key(PartChainIdentificationKey key) {
            this.key = key;
            return this;
        }

        @Generated
        public RegisterBpnInvestigationJobBuilder incidentBPNSs(List<@Pattern(regexp="(BPN)[LSA][\\w\\d]{10}[\\w\\d]{2}") String> incidentBPNSs) {
            this.incidentBPNSs = incidentBPNSs;
            return this;
        }

        @Generated
        public RegisterBpnInvestigationJobBuilder bomLifecycle(BomLifecycle bomLifecycle) {
            this.bomLifecycle = bomLifecycle;
            return this;
        }

        @Generated
        public RegisterBpnInvestigationJobBuilder callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        @Generated
        public RegisterBpnInvestigationJob build() {
            return new RegisterBpnInvestigationJob(this.key, this.incidentBPNSs, this.bomLifecycle, this.callbackUrl);
        }

        @Generated
        public String toString() {
            return "RegisterBpnInvestigationJob.RegisterBpnInvestigationJobBuilder(key=" + this.key + ", incidentBPNSs=" + this.incidentBPNSs + ", bomLifecycle=" + this.bomLifecycle + ", callbackUrl=" + this.callbackUrl + ")";
        }
    }
}

