/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.component;

import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.eclipse.tractusx.irs.component.PartChainIdentificationKey;
import org.eclipse.tractusx.irs.component.enums.BomLifecycle;
import org.eclipse.tractusx.irs.component.enums.Direction;
import org.hibernate.validator.constraints.URL;

@Schema(description="The requested job definition.")
public class RegisterJob {
    private static final String MIN_TREE_DEPTH_DESC = "1";
    private static final String MAX_TREE_DEPTH_DESC = "100";
    private static final int MIN_TREE_DEPTH = 1;
    private static final int MAX_TREE_DEPTH = 100;
    private static final String ASPECT_MODEL_REGEX = "^(urn:[bs]amm:.*\\d\\.\\d\\.\\d)?(#)?(\\w+)?$";
    @NotNull
    @Valid
    @Schema(description="Key object contains required attributes for identify part chain entry node.", implementation=PartChainIdentificationKey.class)
    private PartChainIdentificationKey key;
    @Schema(description="BoM Lifecycle of the result tree.", implementation=BomLifecycle.class)
    private BomLifecycle bomLifecycle;
    @ArraySchema(arraySchema=@Schema(description="List of aspect names that will be collected if \\<collectAspects\\> flag is set to true.", example="[\"urn:samm:io.catenax.single_level_bom_as_built:3.0.0#SingleLevelBomAsBuilt\"]", implementation=String.class, pattern="^(urn:[bs]amm:.*\\d\\.\\d\\.\\d)?(#)?(\\w+)?$"), maxItems=0x7FFFFFFF)
    private List<@Pattern(regexp="^(urn:[bs]amm:.*\\d\\.\\d\\.\\d)?(#)?(\\w+)?$") String> aspects;
    @Schema(implementation=Integer.class, minimum="1", maximum="100", description="Max depth of the item graph returned. If no depth is set item graph with max depth is returned.")
    @Min(value=1L)
    @Max(value=100L)
    private @Min(value=1L) @Max(value=100L) Integer depth;
    @Schema(implementation=Direction.class, defaultValue="downward")
    private Direction direction;
    @Schema(description="Flag to specify whether aspects should be requested and collected. Default is false.")
    private boolean collectAspects;
    @Schema(description="Flag to specify whether BPNs should be collected and resolved via the configured BPDM URL. Default is false.", deprecated=true)
    private boolean lookupBPNs;
    @Schema(description="Flag enables and disables auditing, including provisioning of ContractAgreementId inside submodels and shells objects. Default is true.")
    private boolean auditContractNegotiation = true;
    @URL(regexp="^(http|https).*")
    @Schema(description="Callback url to notify requestor when job processing is finished. There are two uri variable placeholders that can be used: id and state.", example="https://hostname.com/callback?id={id}&state={state}")
    private @URL(regexp="^(http|https).*") String callbackUrl;

    public int getDepth() {
        return this.depth == null ? 100 : this.depth;
    }

    @Generated
    public static RegisterJobBuilder builder() {
        return new RegisterJobBuilder();
    }

    @Generated
    public PartChainIdentificationKey getKey() {
        return this.key;
    }

    @Generated
    public BomLifecycle getBomLifecycle() {
        return this.bomLifecycle;
    }

    @Generated
    public List<@Pattern(regexp="^(urn:[bs]amm:.*\\d\\.\\d\\.\\d)?(#)?(\\w+)?$") String> getAspects() {
        return this.aspects;
    }

    @Generated
    public Direction getDirection() {
        return this.direction;
    }

    @Generated
    public boolean isCollectAspects() {
        return this.collectAspects;
    }

    @Generated
    public boolean isLookupBPNs() {
        return this.lookupBPNs;
    }

    @Generated
    public boolean isAuditContractNegotiation() {
        return this.auditContractNegotiation;
    }

    @Generated
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @Generated
    public void setKey(PartChainIdentificationKey key) {
        this.key = key;
    }

    @Generated
    public void setBomLifecycle(BomLifecycle bomLifecycle) {
        this.bomLifecycle = bomLifecycle;
    }

    @Generated
    public void setAspects(List<@Pattern(regexp="^(urn:[bs]amm:.*\\d\\.\\d\\.\\d)?(#)?(\\w+)?$") String> aspects) {
        this.aspects = aspects;
    }

    @Generated
    public void setDepth(Integer depth) {
        this.depth = depth;
    }

    @Generated
    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    @Generated
    public void setCollectAspects(boolean collectAspects) {
        this.collectAspects = collectAspects;
    }

    @Generated
    public void setLookupBPNs(boolean lookupBPNs) {
        this.lookupBPNs = lookupBPNs;
    }

    @Generated
    public void setAuditContractNegotiation(boolean auditContractNegotiation) {
        this.auditContractNegotiation = auditContractNegotiation;
    }

    @Generated
    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisterJob)) {
            return false;
        }
        RegisterJob other = (RegisterJob)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCollectAspects() != other.isCollectAspects()) {
            return false;
        }
        if (this.isLookupBPNs() != other.isLookupBPNs()) {
            return false;
        }
        if (this.isAuditContractNegotiation() != other.isAuditContractNegotiation()) {
            return false;
        }
        if (this.getDepth() != other.getDepth()) {
            return false;
        }
        PartChainIdentificationKey this$key = this.getKey();
        PartChainIdentificationKey other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        BomLifecycle this$bomLifecycle = this.getBomLifecycle();
        BomLifecycle other$bomLifecycle = other.getBomLifecycle();
        if (this$bomLifecycle == null ? other$bomLifecycle != null : !((Object)((Object)this$bomLifecycle)).equals((Object)other$bomLifecycle)) {
            return false;
        }
        List<String> this$aspects = this.getAspects();
        List<String> other$aspects = other.getAspects();
        if (this$aspects == null ? other$aspects != null : !((Object)this$aspects).equals(other$aspects)) {
            return false;
        }
        Direction this$direction = this.getDirection();
        Direction other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !((Object)((Object)this$direction)).equals((Object)other$direction)) {
            return false;
        }
        String this$callbackUrl = this.getCallbackUrl();
        String other$callbackUrl = other.getCallbackUrl();
        return !(this$callbackUrl == null ? other$callbackUrl != null : !this$callbackUrl.equals(other$callbackUrl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RegisterJob;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCollectAspects() ? 79 : 97);
        result = result * 59 + (this.isLookupBPNs() ? 79 : 97);
        result = result * 59 + (this.isAuditContractNegotiation() ? 79 : 97);
        result = result * 59 + this.getDepth();
        PartChainIdentificationKey $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        BomLifecycle $bomLifecycle = this.getBomLifecycle();
        result = result * 59 + ($bomLifecycle == null ? 43 : ((Object)((Object)$bomLifecycle)).hashCode());
        List<String> $aspects = this.getAspects();
        result = result * 59 + ($aspects == null ? 43 : ((Object)$aspects).hashCode());
        Direction $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : ((Object)((Object)$direction)).hashCode());
        String $callbackUrl = this.getCallbackUrl();
        result = result * 59 + ($callbackUrl == null ? 43 : $callbackUrl.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RegisterJob(key=" + this.getKey() + ", bomLifecycle=" + this.getBomLifecycle() + ", aspects=" + this.getAspects() + ", depth=" + this.getDepth() + ", direction=" + this.getDirection() + ", collectAspects=" + this.isCollectAspects() + ", lookupBPNs=" + this.isLookupBPNs() + ", auditContractNegotiation=" + this.isAuditContractNegotiation() + ", callbackUrl=" + this.getCallbackUrl() + ")";
    }

    @Generated
    public RegisterJob() {
    }

    @Generated
    public RegisterJob(PartChainIdentificationKey key, BomLifecycle bomLifecycle, List<@Pattern(regexp="^(urn:[bs]amm:.*\\d\\.\\d\\.\\d)?(#)?(\\w+)?$") String> aspects, Integer depth, Direction direction, boolean collectAspects, boolean lookupBPNs, boolean auditContractNegotiation, String callbackUrl) {
        this.key = key;
        this.bomLifecycle = bomLifecycle;
        this.aspects = aspects;
        this.depth = depth;
        this.direction = direction;
        this.collectAspects = collectAspects;
        this.lookupBPNs = lookupBPNs;
        this.auditContractNegotiation = auditContractNegotiation;
        this.callbackUrl = callbackUrl;
    }

    @Generated
    public static class RegisterJobBuilder {
        @Generated
        private PartChainIdentificationKey key;
        @Generated
        private BomLifecycle bomLifecycle;
        @Generated
        private List<@Pattern(regexp="^(urn:[bs]amm:.*\\d\\.\\d\\.\\d)?(#)?(\\w+)?$") String> aspects;
        @Generated
        private Integer depth;
        @Generated
        private Direction direction;
        @Generated
        private boolean collectAspects;
        @Generated
        private boolean lookupBPNs;
        @Generated
        private boolean auditContractNegotiation;
        @Generated
        private String callbackUrl;

        @Generated
        RegisterJobBuilder() {
        }

        @Generated
        public RegisterJobBuilder key(PartChainIdentificationKey key) {
            this.key = key;
            return this;
        }

        @Generated
        public RegisterJobBuilder bomLifecycle(BomLifecycle bomLifecycle) {
            this.bomLifecycle = bomLifecycle;
            return this;
        }

        @Generated
        public RegisterJobBuilder aspects(List<@Pattern(regexp="^(urn:[bs]amm:.*\\d\\.\\d\\.\\d)?(#)?(\\w+)?$") String> aspects) {
            this.aspects = aspects;
            return this;
        }

        @Generated
        public RegisterJobBuilder depth(Integer depth) {
            this.depth = depth;
            return this;
        }

        @Generated
        public RegisterJobBuilder direction(Direction direction) {
            this.direction = direction;
            return this;
        }

        @Generated
        public RegisterJobBuilder collectAspects(boolean collectAspects) {
            this.collectAspects = collectAspects;
            return this;
        }

        @Generated
        public RegisterJobBuilder lookupBPNs(boolean lookupBPNs) {
            this.lookupBPNs = lookupBPNs;
            return this;
        }

        @Generated
        public RegisterJobBuilder auditContractNegotiation(boolean auditContractNegotiation) {
            this.auditContractNegotiation = auditContractNegotiation;
            return this;
        }

        @Generated
        public RegisterJobBuilder callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        @Generated
        public RegisterJob build() {
            return new RegisterJob(this.key, this.bomLifecycle, this.aspects, this.depth, this.direction, this.collectAspects, this.lookupBPNs, this.auditContractNegotiation, this.callbackUrl);
        }

        @Generated
        public String toString() {
            return "RegisterJob.RegisterJobBuilder(key=" + this.key + ", bomLifecycle=" + this.bomLifecycle + ", aspects=" + this.aspects + ", depth=" + this.depth + ", direction=" + this.direction + ", collectAspects=" + this.collectAspects + ", lookupBPNs=" + this.lookupBPNs + ", auditContractNegotiation=" + this.auditContractNegotiation + ", callbackUrl=" + this.callbackUrl + ")";
        }
    }
}

