/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.component;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.eclipse.tractusx.irs.component.GlobalAssetIdentification;
import org.eclipse.tractusx.irs.component.LinkedItem;

@Schema(description="Relationships between parent and child items.")
@JsonDeserialize(builder=RelationshipBuilder.class)
public final class Relationship {
    private static final int GLOBAL_ASSET_ID_LENGTH = 45;
    @Schema(implementation=String.class, description="CATENA-X global asset id in the format urn:uuid:uuid4.", example="urn:uuid:6c311d29-5753-46d4-b32c-19b918ea93b0", minLength=45, maxLength=45, pattern="^urn:uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")
    @JsonUnwrapped
    private final GlobalAssetIdentification catenaXId;
    private final LinkedItem linkedItem;
    @Schema(implementation=String.class, example="SingleLevelBomAsBuilt")
    private final String aspectType;
    @Schema(implementation=String.class, example="BPNL00000003AYRE")
    private final String bpn;

    @Generated
    public static RelationshipBuilder builder() {
        return new RelationshipBuilder();
    }

    @Generated
    public RelationshipBuilder toBuilder() {
        return new RelationshipBuilder().catenaXId(this.catenaXId).linkedItem(this.linkedItem).aspectType(this.aspectType).bpn(this.bpn);
    }

    @Generated
    public GlobalAssetIdentification getCatenaXId() {
        return this.catenaXId;
    }

    @Generated
    public LinkedItem getLinkedItem() {
        return this.linkedItem;
    }

    @Generated
    public String getAspectType() {
        return this.aspectType;
    }

    @Generated
    public String getBpn() {
        return this.bpn;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Relationship)) {
            return false;
        }
        Relationship other = (Relationship)o;
        GlobalAssetIdentification this$catenaXId = this.getCatenaXId();
        GlobalAssetIdentification other$catenaXId = other.getCatenaXId();
        if (this$catenaXId == null ? other$catenaXId != null : !((Object)this$catenaXId).equals(other$catenaXId)) {
            return false;
        }
        LinkedItem this$linkedItem = this.getLinkedItem();
        LinkedItem other$linkedItem = other.getLinkedItem();
        if (this$linkedItem == null ? other$linkedItem != null : !((Object)this$linkedItem).equals(other$linkedItem)) {
            return false;
        }
        String this$aspectType = this.getAspectType();
        String other$aspectType = other.getAspectType();
        if (this$aspectType == null ? other$aspectType != null : !this$aspectType.equals(other$aspectType)) {
            return false;
        }
        String this$bpn = this.getBpn();
        String other$bpn = other.getBpn();
        return !(this$bpn == null ? other$bpn != null : !this$bpn.equals(other$bpn));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GlobalAssetIdentification $catenaXId = this.getCatenaXId();
        result = result * 59 + ($catenaXId == null ? 43 : ((Object)$catenaXId).hashCode());
        LinkedItem $linkedItem = this.getLinkedItem();
        result = result * 59 + ($linkedItem == null ? 43 : ((Object)$linkedItem).hashCode());
        String $aspectType = this.getAspectType();
        result = result * 59 + ($aspectType == null ? 43 : $aspectType.hashCode());
        String $bpn = this.getBpn();
        result = result * 59 + ($bpn == null ? 43 : $bpn.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Relationship(catenaXId=" + this.getCatenaXId() + ", linkedItem=" + this.getLinkedItem() + ", aspectType=" + this.getAspectType() + ", bpn=" + this.getBpn() + ")";
    }

    @Generated
    public Relationship(GlobalAssetIdentification catenaXId, LinkedItem linkedItem, String aspectType, String bpn) {
        this.catenaXId = catenaXId;
        this.linkedItem = linkedItem;
        this.aspectType = aspectType;
        this.bpn = bpn;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class RelationshipBuilder {
        @Generated
        private GlobalAssetIdentification catenaXId;
        @Generated
        private LinkedItem linkedItem;
        @Generated
        private String aspectType;
        @Generated
        private String bpn;

        @Generated
        RelationshipBuilder() {
        }

        @JsonUnwrapped
        @Generated
        public RelationshipBuilder catenaXId(GlobalAssetIdentification catenaXId) {
            this.catenaXId = catenaXId;
            return this;
        }

        @Generated
        public RelationshipBuilder linkedItem(LinkedItem linkedItem) {
            this.linkedItem = linkedItem;
            return this;
        }

        @Generated
        public RelationshipBuilder aspectType(String aspectType) {
            this.aspectType = aspectType;
            return this;
        }

        @Generated
        public RelationshipBuilder bpn(String bpn) {
            this.bpn = bpn;
            return this;
        }

        @Generated
        public Relationship build() {
            return new Relationship(this.catenaXId, this.linkedItem, this.aspectType, this.bpn);
        }

        @Generated
        public String toString() {
            return "Relationship.RelationshipBuilder(catenaXId=" + this.catenaXId + ", linkedItem=" + this.linkedItem + ", aspectType=" + this.aspectType + ", bpn=" + this.bpn + ")";
        }
    }
}

