/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.component;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.tractusx.irs.component.ProcessingError;
import org.eclipse.tractusx.irs.component.enums.NodeType;
import org.eclipse.tractusx.irs.component.enums.ProcessStep;

@Schema(description="Tombstone with information about request failure")
@JsonDeserialize(builder=TombstoneBuilder.class)
public class Tombstone {
    private static final NodeType NODE_TYPE = NodeType.TOMBSTONE;
    public static final int CATENA_X_ID_LENGTH = 45;
    @Schema(description="CATENA-X global asset id in the format urn:uuid:uuid4.", example="urn:uuid:6c311d29-5753-46d4-b32c-19b918ea93b0", minLength=45, maxLength=45, pattern="^urn:uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")
    private final String catenaXId;
    private final String endpointURL;
    private final String businessPartnerNumber;
    private final ProcessingError processingError;
    private final Map<String, Object> policy;

    public static Tombstone from(String catenaXId, String endpointURL, Exception exception, int retryCount, ProcessStep processStep) {
        return Tombstone.from(catenaXId, endpointURL, exception.getMessage(), retryCount, processStep);
    }

    public static Tombstone from(String catenaXId, String endpointURL, Exception exception, int retryCount, ProcessStep processStep, String businessPartnerNumber, Map<String, Object> policy) {
        return Tombstone.builder().endpointURL(endpointURL).catenaXId(catenaXId).processingError(Tombstone.withProcessingError(processStep, retryCount, exception.getMessage())).businessPartnerNumber(businessPartnerNumber).policy(policy).build();
    }

    public static Tombstone from(String catenaXId, String endpointURL, String errorDetails, int retryCount, ProcessStep processStep) {
        return Tombstone.builder().endpointURL(endpointURL).catenaXId(catenaXId).processingError(Tombstone.withProcessingError(processStep, retryCount, errorDetails)).build();
    }

    public static Tombstone from(String globalAssetId, String endpointURL, Throwable exception, Throwable[] suppressed, int retryCount, ProcessStep processStep) {
        ProcessingError processingError = Tombstone.withProcessingError(processStep, retryCount, exception.getMessage(), suppressed);
        return Tombstone.builder().endpointURL(endpointURL).catenaXId(globalAssetId).processingError(processingError).build();
    }

    private static ProcessingError withProcessingError(ProcessStep processStep, int retryCount, String message, Throwable ... suppressed) {
        List<String> rootCauses = Arrays.stream(suppressed).map(Tombstone::getRootErrorMessages).toList();
        return ProcessingError.builder().withProcessStep(processStep).withRetryCounter(retryCount).withLastAttempt(ZonedDateTime.now(ZoneOffset.UTC)).withErrorDetail(message).withRootCauses(rootCauses).build();
    }

    private static String getRootErrorMessages(Throwable throwable) {
        Throwable cause = throwable.getCause();
        if (cause != null) {
            Throwable rootCause = cause;
            int maxDepth = 10;
            for (int depth = 0; (rootCause.getCause() != null || Tombstone.hasSuppressedExceptions(rootCause)) && depth < 10; ++depth) {
                rootCause = Tombstone.hasSuppressedExceptions(rootCause) ? rootCause.getSuppressed()[0] : rootCause.getCause();
            }
            return ExceptionUtils.getRootCauseMessage((Throwable)rootCause);
        }
        return ExceptionUtils.getRootCauseMessage((Throwable)throwable);
    }

    private static ProcessingError withProcessingError(ProcessStep processStep, int retryCount, String exception) {
        return ProcessingError.builder().withProcessStep(processStep).withRetryCounter(retryCount).withLastAttempt(ZonedDateTime.now(ZoneOffset.UTC)).withErrorDetail(exception).build();
    }

    private static boolean hasSuppressedExceptions(Throwable exception) {
        return exception.getSuppressed().length > 0;
    }

    @Generated
    Tombstone(String catenaXId, String endpointURL, String businessPartnerNumber, ProcessingError processingError, Map<String, Object> policy) {
        this.catenaXId = catenaXId;
        this.endpointURL = endpointURL;
        this.businessPartnerNumber = businessPartnerNumber;
        this.processingError = processingError;
        this.policy = policy;
    }

    @Generated
    public static TombstoneBuilder builder() {
        return new TombstoneBuilder();
    }

    @Generated
    public String getCatenaXId() {
        return this.catenaXId;
    }

    @Generated
    public String getEndpointURL() {
        return this.endpointURL;
    }

    @Generated
    public String getBusinessPartnerNumber() {
        return this.businessPartnerNumber;
    }

    @Generated
    public ProcessingError getProcessingError() {
        return this.processingError;
    }

    @Generated
    public Map<String, Object> getPolicy() {
        return this.policy;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class TombstoneBuilder {
        @Generated
        private String catenaXId;
        @Generated
        private String endpointURL;
        @Generated
        private String businessPartnerNumber;
        @Generated
        private ProcessingError processingError;
        @Generated
        private Map<String, Object> policy;

        @Generated
        TombstoneBuilder() {
        }

        @Generated
        public TombstoneBuilder catenaXId(String catenaXId) {
            this.catenaXId = catenaXId;
            return this;
        }

        @Generated
        public TombstoneBuilder endpointURL(String endpointURL) {
            this.endpointURL = endpointURL;
            return this;
        }

        @Generated
        public TombstoneBuilder businessPartnerNumber(String businessPartnerNumber) {
            this.businessPartnerNumber = businessPartnerNumber;
            return this;
        }

        @Generated
        public TombstoneBuilder processingError(ProcessingError processingError) {
            this.processingError = processingError;
            return this;
        }

        @Generated
        public TombstoneBuilder policy(Map<String, Object> policy) {
            this.policy = policy;
            return this;
        }

        @Generated
        public Tombstone build() {
            return new Tombstone(this.catenaXId, this.endpointURL, this.businessPartnerNumber, this.processingError, this.policy);
        }

        @Generated
        public String toString() {
            return "Tombstone.TombstoneBuilder(catenaXId=" + this.catenaXId + ", endpointURL=" + this.endpointURL + ", businessPartnerNumber=" + this.businessPartnerNumber + ", processingError=" + this.processingError + ", policy=" + this.policy + ")";
        }
    }
}

