/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.component.assetadministrationshell;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.vdurmont.semver4j.SemverException;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.tractusx.irs.component.assetadministrationshell.AdministrativeInformation;
import org.eclipse.tractusx.irs.component.assetadministrationshell.Endpoint;
import org.eclipse.tractusx.irs.component.assetadministrationshell.LangString;
import org.eclipse.tractusx.irs.component.assetadministrationshell.Reference;
import org.eclipse.tractusx.irs.component.assetadministrationshell.SemanticId;
import org.eclipse.tractusx.irs.component.assetadministrationshell.SemanticModel;
import org.springframework.util.StringUtils;

@JsonDeserialize(builder=SubmodelDescriptorBuilder.class)
public class SubmodelDescriptor {
    private AdministrativeInformation administration;
    @ArraySchema(maxItems=0x7FFFFFFF)
    private List<LangString> description;
    private String idShort;
    private String id;
    private Reference semanticId;
    @ArraySchema(maxItems=0x7FFFFFFF)
    private List<Endpoint> endpoints;

    @JsonIgnore
    public String getAspectType() {
        return this.getSemanticId().getKeys().stream().findFirst().map(SemanticId::getValue).orElse(null);
    }

    boolean isAspect(String filterSemanticId) {
        return Optional.ofNullable(this.getAspectType()).filter(aspect -> StringUtils.hasLength((String)filterSemanticId)).map(aspect -> aspect.contains(this.lowerCaseNameWithUnderscores(filterSemanticId)) || this.semanticModelNamesMatchAndVersionIsInRange((String)aspect, filterSemanticId)).orElse(false);
    }

    private String lowerCaseNameWithUnderscores(String filterSemanticId) {
        return String.join((CharSequence)"_", filterSemanticId.split("(?=[A-Z])")).toLowerCase(Locale.ROOT);
    }

    private boolean semanticModelNamesMatchAndVersionIsInRange(String semanticId, String filterSemanticId) {
        try {
            SemanticModel submodel = SemanticModel.parse(semanticId);
            SemanticModel filter = SemanticModel.parse(filterSemanticId);
            return filter.matches(submodel);
        }
        catch (SemverException | IllegalArgumentException e) {
            return false;
        }
    }

    @Generated
    SubmodelDescriptor(AdministrativeInformation administration, List<LangString> description, String idShort, String id, Reference semanticId, List<Endpoint> endpoints) {
        this.administration = administration;
        this.description = description;
        this.idShort = idShort;
        this.id = id;
        this.semanticId = semanticId;
        this.endpoints = endpoints;
    }

    @Generated
    public static SubmodelDescriptorBuilder builder() {
        return new SubmodelDescriptorBuilder();
    }

    @Generated
    public AdministrativeInformation getAdministration() {
        return this.administration;
    }

    @Generated
    public List<LangString> getDescription() {
        return this.description;
    }

    @Generated
    public String getIdShort() {
        return this.idShort;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Reference getSemanticId() {
        return this.semanticId;
    }

    @Generated
    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    @Generated
    public void setAdministration(AdministrativeInformation administration) {
        this.administration = administration;
    }

    @Generated
    public void setDescription(List<LangString> description) {
        this.description = description;
    }

    @Generated
    public void setIdShort(String idShort) {
        this.idShort = idShort;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setSemanticId(Reference semanticId) {
        this.semanticId = semanticId;
    }

    @Generated
    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubmodelDescriptor)) {
            return false;
        }
        SubmodelDescriptor other = (SubmodelDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AdministrativeInformation this$administration = this.getAdministration();
        AdministrativeInformation other$administration = other.getAdministration();
        if (this$administration == null ? other$administration != null : !((Object)this$administration).equals(other$administration)) {
            return false;
        }
        List<LangString> this$description = this.getDescription();
        List<LangString> other$description = other.getDescription();
        if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
            return false;
        }
        String this$idShort = this.getIdShort();
        String other$idShort = other.getIdShort();
        if (this$idShort == null ? other$idShort != null : !this$idShort.equals(other$idShort)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Reference this$semanticId = this.getSemanticId();
        Reference other$semanticId = other.getSemanticId();
        if (this$semanticId == null ? other$semanticId != null : !((Object)this$semanticId).equals(other$semanticId)) {
            return false;
        }
        List<Endpoint> this$endpoints = this.getEndpoints();
        List<Endpoint> other$endpoints = other.getEndpoints();
        return !(this$endpoints == null ? other$endpoints != null : !((Object)this$endpoints).equals(other$endpoints));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SubmodelDescriptor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AdministrativeInformation $administration = this.getAdministration();
        result = result * 59 + ($administration == null ? 43 : ((Object)$administration).hashCode());
        List<LangString> $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        String $idShort = this.getIdShort();
        result = result * 59 + ($idShort == null ? 43 : $idShort.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Reference $semanticId = this.getSemanticId();
        result = result * 59 + ($semanticId == null ? 43 : ((Object)$semanticId).hashCode());
        List<Endpoint> $endpoints = this.getEndpoints();
        result = result * 59 + ($endpoints == null ? 43 : ((Object)$endpoints).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SubmodelDescriptor(administration=" + this.getAdministration() + ", description=" + this.getDescription() + ", idShort=" + this.getIdShort() + ", id=" + this.getId() + ", semanticId=" + this.getSemanticId() + ", endpoints=" + this.getEndpoints() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class SubmodelDescriptorBuilder {
        @Generated
        private AdministrativeInformation administration;
        @Generated
        private List<LangString> description;
        @Generated
        private String idShort;
        @Generated
        private String id;
        @Generated
        private Reference semanticId;
        @Generated
        private List<Endpoint> endpoints;

        @Generated
        SubmodelDescriptorBuilder() {
        }

        @Generated
        public SubmodelDescriptorBuilder administration(AdministrativeInformation administration) {
            this.administration = administration;
            return this;
        }

        @Generated
        public SubmodelDescriptorBuilder description(List<LangString> description) {
            this.description = description;
            return this;
        }

        @Generated
        public SubmodelDescriptorBuilder idShort(String idShort) {
            this.idShort = idShort;
            return this;
        }

        @Generated
        public SubmodelDescriptorBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public SubmodelDescriptorBuilder semanticId(Reference semanticId) {
            this.semanticId = semanticId;
            return this;
        }

        @Generated
        public SubmodelDescriptorBuilder endpoints(List<Endpoint> endpoints) {
            this.endpoints = endpoints;
            return this;
        }

        @Generated
        public SubmodelDescriptor build() {
            return new SubmodelDescriptor(this.administration, this.description, this.idShort, this.id, this.semanticId, this.endpoints);
        }

        @Generated
        public String toString() {
            return "SubmodelDescriptor.SubmodelDescriptorBuilder(administration=" + this.administration + ", description=" + this.description + ", idShort=" + this.idShort + ", id=" + this.id + ", semanticId=" + this.semanticId + ", endpoints=" + this.endpoints + ")";
        }
    }
}

