/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.component.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

@JsonSerialize(using=ToStringSerializer.class)
public enum AspectType {
    ADDRESS_ASPECT("AddressAspect"),
    BATCH("Batch"),
    BATTERY_PASS("BatteryPass"),
    CERTIFICATE_OF_DESTRUCTION("CertificateOfDestruction"),
    CERTIFICATE_OF_DISMANTLER("CertificateOfDismantler"),
    CHARGING_PROCESS("ChargingProcess"),
    CLAIM_DATA("ClaimData"),
    DIAGNOSTIC_DATA("DiagnosticData"),
    END_OF_LIFE("EndOfLife"),
    ESR_CERTIFICATE("EsrCertificate"),
    ESR_CERTIFICATE_STATISTICS("EsrCertificateStateStatistic"),
    ID_CONVERSION("IdConversion"),
    MARKETPLACE_OFFER("MarketplaceOffer"),
    MATERIAL_FOR_HOMOLOGATION("MaterialForHomologation"),
    MATERIAL_FOR_RECYCLING("MaterialForRecycling"),
    PART_AS_PLANNED("PartAsPlanned"),
    PART_AS_SPECIFIED("PartAsSpecified"),
    PHYSICAL_DIMENSION("PhysicalDimension"),
    PRODUCT_DESCRIPTION("ProductDescription"),
    RETURN_REQUEST("ReturnRequest"),
    SERIAL_PART("SerialPart"),
    PART_SITE_INFORMATION_AS_PLANNED("PartSiteInformationAsPlanned"),
    SINGLE_LEVEL_BOM_AS_BUILT("SingleLevelBomAsBuilt"),
    SINGLE_LEVEL_BOM_AS_PLANNED("SingleLevelBomAsPlanned"),
    SINGLE_LEVEL_BOM_AS_SPECIFIED("SingleLevelBomAsSpecified"),
    SINGLE_LEVEL_USAGE_AS_BUILT("SingleLevelUsageAsBuilt"),
    SINGLE_LEVEL_USAGE_AS_PLANNED("SingleLevelUsageAsPlanned");

    private final String name;

    private AspectType(String name) {
        this.name = name;
    }

    public static AspectType value(String value) {
        return AspectType.valueOf(value);
    }

    @JsonCreator
    public static AspectType fromValue(String value) {
        return Stream.of(AspectType.values()).filter(aspectType -> aspectType.name.equals(value)).findFirst().orElseThrow(() -> new NoSuchElementException("Unsupported AspectType: " + value + ". Must be one of: " + AspectType.supportedAspectTypes()));
    }

    private static String supportedAspectTypes() {
        return Stream.of(AspectType.values()).map(aspect -> aspect.name).collect(Collectors.joining(", "));
    }

    public String toString() {
        return this.name;
    }

    public static final class AspectTypesConstants {
        public static final String ADDRESS_ASPECT = "AddressAspect";
        public static final String BATCH = "Batch";
        public static final String BATTERY_PASS = "BatteryPass";
        public static final String CERTIFICATE_OF_DESTRUCTION = "CertificateOfDestruction";
        public static final String CERTIFICATE_OF_DISMANTLER = "CertificateOfDismantler";
        public static final String CHARGING_PROCESS = "ChargingProcess";
        public static final String CLAIM_DATA = "ClaimData";
        public static final String DIAGNOSTIC_DATA = "DiagnosticData";
        public static final String END_OF_LIFE = "EndOfLife";
        public static final String ESR_CERTIFICATE = "EsrCertificate";
        public static final String ESR_CERTIFICATE_STATISTICS = "EsrCertificateStateStatistic";
        public static final String ID_CONVERSION = "IdConversion";
        public static final String MARKETPLACE_OFFER = "MarketplaceOffer";
        public static final String MATERIAL_FOR_HOMOLOGATION = "MaterialForHomologation";
        public static final String MATERIAL_FOR_RECYCLING = "MaterialForRecycling";
        public static final String PART_AS_PLANNED = "PartAsPlanned";
        public static final String PART_AS_SPECIFIED = "PartAsSpecified";
        public static final String PHYSICAL_DIMENSION = "PhysicalDimension";
        public static final String PRODUCT_DESCRIPTION = "ProductDescription";
        public static final String RETURN_REQUEST = "ReturnRequest";
        public static final String SERIAL_PART = "SerialPart";
        public static final String PART_SITE_INFORMATION_AS_PLANNED = "PartSiteInformationAsPlanned";
        public static final String SINGLE_LEVEL_BOM_AS_BUILT = "SingleLevelBomAsBuilt";
        public static final String SINGLE_LEVEL_BOM_AS_PLANNED = "SingleLevelBomAsPlanned";
        public static final String SINGLE_LEVEL_BOM_AS_SPECIFIED = "SingleLevelBomAsSpecified";
        public static final String SINGLE_LEVEL_USAGE_AS_BUILT = "SingleLevelUsageAsBuilt";
        public static final String SINGLE_LEVEL_USAGE_AS_PLANNED = "SingleLevelUsageAsPlanned";

        @Generated
        private AspectTypesConstants() {
        }
    }
}

