/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.dtos;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;

@Schema(description="Error response.")
@JsonDeserialize(builder=ErrorResponseBuilder.class)
public final class ErrorResponse {
    @Schema(description="Error code.")
    private final HttpStatus statusCode;
    @Schema(description="Error.")
    private final String error;
    @ArraySchema(arraySchema=@Schema(description="List of error messages.", implementation=String.class), maxItems=0x7FFFFFFF)
    private final List<String> messages;

    @Generated
    ErrorResponse(HttpStatus statusCode, String error, List<String> messages) {
        this.statusCode = statusCode;
        this.error = error;
        this.messages = messages;
    }

    @Generated
    public static ErrorResponseBuilder builder() {
        return new ErrorResponseBuilder();
    }

    @Generated
    public ErrorResponseBuilder toBuilder() {
        return new ErrorResponseBuilder().withStatusCode(this.statusCode).withError(this.error).withMessages(this.messages);
    }

    @Generated
    public HttpStatus getStatusCode() {
        return this.statusCode;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public List<String> getMessages() {
        return this.messages;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorResponse)) {
            return false;
        }
        ErrorResponse other = (ErrorResponse)o;
        HttpStatus this$statusCode = this.getStatusCode();
        HttpStatus other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !this$statusCode.equals(other$statusCode)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        List<String> this$messages = this.getMessages();
        List<String> other$messages = other.getMessages();
        return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpStatus $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : $statusCode.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        List<String> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ErrorResponse(statusCode=" + this.getStatusCode() + ", error=" + this.getError() + ", messages=" + this.getMessages() + ")";
    }

    @Generated
    public static class ErrorResponseBuilder {
        @Generated
        private HttpStatus statusCode;
        @Generated
        private String error;
        @Generated
        private List<String> messages;

        @Generated
        ErrorResponseBuilder() {
        }

        @Generated
        public ErrorResponseBuilder withStatusCode(HttpStatus statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Generated
        public ErrorResponseBuilder withError(String error) {
            this.error = error;
            return this;
        }

        @Generated
        public ErrorResponseBuilder withMessages(List<String> messages) {
            this.messages = messages;
            return this;
        }

        @Generated
        public ErrorResponse build() {
            return new ErrorResponse(this.statusCode, this.error, this.messages);
        }

        @Generated
        public String toString() {
            return "ErrorResponse.ErrorResponseBuilder(statusCode=" + this.statusCode + ", error=" + this.error + ", messages=" + this.messages + ")";
        }
    }
}

