/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.registryclient.central;

import io.github.resilience4j.core.functions.Either;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.eclipse.tractusx.irs.component.Shell;
import org.eclipse.tractusx.irs.component.assetadministrationshell.IdentifierKeyValuePair;
import org.eclipse.tractusx.irs.registryclient.DigitalTwinRegistryKey;
import org.eclipse.tractusx.irs.registryclient.DigitalTwinRegistryService;
import org.eclipse.tractusx.irs.registryclient.central.DigitalTwinRegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CentralDigitalTwinRegistryService
implements DigitalTwinRegistryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CentralDigitalTwinRegistryService.class);
    private final DigitalTwinRegistryClient digitalTwinRegistryClient;

    @Override
    public Collection<Either<Exception, Shell>> fetchShells(Collection<DigitalTwinRegistryKey> keys) {
        return keys.stream().map(key -> {
            String aaShellIdentification = this.getAAShellIdentificationOrGlobalAssetId(key.shellId());
            log.info("Retrieved AAS Identification {} for globalAssetId {}", (Object)aaShellIdentification, (Object)key.shellId());
            return Either.right((Object)new Shell("", this.digitalTwinRegistryClient.getAssetAdministrationShellDescriptor(aaShellIdentification)));
        }).toList();
    }

    @Override
    public Collection<DigitalTwinRegistryKey> lookupShellIdentifiers(String bpn) {
        log.info("Looking up shells for bpn {}", (Object)bpn);
        List<String> shellIds = this.digitalTwinRegistryClient.getAllAssetAdministrationShellIdsByAssetLink(List.of()).getResult();
        log.info("Found {} shells in total", (Object)shellIds.size());
        return shellIds.stream().map(id -> new DigitalTwinRegistryKey((String)id, bpn)).toList();
    }

    private String getAAShellIdentificationOrGlobalAssetId(String globalAssetId) {
        IdentifierKeyValuePair identifierKeyValuePair = IdentifierKeyValuePair.builder().name("globalAssetId").value(globalAssetId).build();
        List<String> allAssetAdministrationShellIdsByAssetLink = this.digitalTwinRegistryClient.getAllAssetAdministrationShellIdsByAssetLink(Collections.singletonList(identifierKeyValuePair)).getResult();
        return allAssetAdministrationShellIdsByAssetLink.stream().findFirst().orElse(globalAssetId);
    }

    @Generated
    public CentralDigitalTwinRegistryService(DigitalTwinRegistryClient digitalTwinRegistryClient) {
        this.digitalTwinRegistryClient = digitalTwinRegistryClient;
    }
}

