/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.registryclient.decentral;

import io.github.resilience4j.core.functions.Either;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.eclipse.edc.spi.types.domain.edr.EndpointDataReference;
import org.eclipse.tractusx.irs.common.ExceptionUtils;
import org.eclipse.tractusx.irs.common.util.concurrent.ResultFinder;
import org.eclipse.tractusx.irs.component.Shell;
import org.eclipse.tractusx.irs.component.assetadministrationshell.AssetAdministrationShellDescriptor;
import org.eclipse.tractusx.irs.component.assetadministrationshell.IdentifierKeyValuePair;
import org.eclipse.tractusx.irs.edc.client.EdcConfiguration;
import org.eclipse.tractusx.irs.registryclient.DigitalTwinRegistryKey;
import org.eclipse.tractusx.irs.registryclient.DigitalTwinRegistryService;
import org.eclipse.tractusx.irs.registryclient.decentral.DecentralDigitalTwinRegistryClient;
import org.eclipse.tractusx.irs.registryclient.decentral.EndpointDataForConnectorsService;
import org.eclipse.tractusx.irs.registryclient.discovery.ConnectorEndpointsService;
import org.eclipse.tractusx.irs.registryclient.exceptions.RegistryServiceException;
import org.eclipse.tractusx.irs.registryclient.exceptions.ShellNotFoundException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public class DecentralDigitalTwinRegistryService
implements DigitalTwinRegistryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DecentralDigitalTwinRegistryService.class);
    private static final String TOOK_MS = "{} took {} ms";
    private final ConnectorEndpointsService connectorEndpointsService;
    private final EndpointDataForConnectorsService endpointDataForConnectorsService;
    private final DecentralDigitalTwinRegistryClient decentralDigitalTwinRegistryClient;
    private final EdcConfiguration config;
    private ResultFinder resultFinder = new ResultFinder();

    private static Stream<Map.Entry<String, List<DigitalTwinRegistryKey>>> groupKeysByBpn(Collection<DigitalTwinRegistryKey> keys) {
        return keys.stream().collect(Collectors.groupingBy(DigitalTwinRegistryKey::bpn)).entrySet().stream();
    }

    void setResultFinder(ResultFinder resultFinder) {
        this.resultFinder = resultFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Either<Exception, Shell>> fetchShells(Collection<DigitalTwinRegistryKey> keys) throws RegistryServiceException {
        StopWatch watch = new StopWatch();
        String msg = "Fetching shell(s) for %s key(s)".formatted(keys.size());
        watch.start(msg);
        log.info(msg);
        try {
            HashSet<String> calledEndpoints = new HashSet<String>();
            List<Either<Exception, Shell>> collectedShells = DecentralDigitalTwinRegistryService.groupKeysByBpn(keys).flatMap(entry -> {
                try {
                    return this.fetchShellDescriptors((Map.Entry<String, List<DigitalTwinRegistryKey>>)entry, (Set<String>)calledEndpoints);
                }
                catch (RuntimeException | TimeoutException e) {
                    log.warn(e.getMessage(), (Throwable)e);
                    return Stream.of(Either.left((Object)e));
                }
            }).toList();
            if (collectedShells.stream().noneMatch(Either::isRight)) {
                log.info("No shells found");
                ShellNotFoundException shellNotFoundException = new ShellNotFoundException("Unable to find any of the requested shells", calledEndpoints);
                ExceptionUtils.addSuppressedExceptions(collectedShells, (Exception)shellNotFoundException);
                throw shellNotFoundException;
            }
            log.info("Found {} shell(s) for {} key(s)", (Object)collectedShells.size(), (Object)keys.size());
            List<Either<Exception, Shell>> list = collectedShells;
            return list;
        }
        finally {
            watch.stop();
            log.info(TOOK_MS, (Object)watch.getLastTaskName(), (Object)watch.getLastTaskTimeMillis());
        }
    }

    private Stream<Either<Exception, Shell>> fetchShellDescriptors(Map.Entry<String, List<DigitalTwinRegistryKey>> entry, Set<String> calledEndpoints) throws TimeoutException {
        try {
            CompletableFuture<List<Either<Exception, Shell>>> futures = this.fetchShellDescriptors(calledEndpoints, entry.getKey(), entry.getValue());
            List<Either<Exception, Shell>> shellDescriptors = futures.get(this.config.getAsyncTimeoutMillis(), TimeUnit.MILLISECONDS);
            return shellDescriptors.stream();
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            return Stream.of(Either.left((Object)e));
        }
        catch (ExecutionException | RegistryServiceException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return Stream.of(Either.left((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<List<Either<Exception, Shell>>> fetchShellDescriptors(Set<String> calledEndpoints, String bpn, List<DigitalTwinRegistryKey> keys) throws RegistryServiceException {
        StopWatch watch = new StopWatch();
        String msg = "Fetching %s shells for bpn '%s'".formatted(keys.size(), bpn);
        watch.start(msg);
        log.info(msg);
        try {
            List<String> edcUrls = this.connectorEndpointsService.fetchConnectorEndpoints(bpn);
            if (edcUrls.isEmpty()) {
                throw new RegistryServiceException("No EDC Endpoints could be discovered for BPN '%s'".formatted(bpn));
            }
            log.info("Found {} connector endpoints for bpn '{}'", (Object)edcUrls.size(), (Object)bpn);
            calledEndpoints.addAll(edcUrls);
            CompletableFuture<List<Either<Exception, Shell>>> completableFuture = this.fetchShellDescriptorsForConnectorEndpoints(keys, edcUrls, bpn);
            return completableFuture;
        }
        finally {
            watch.stop();
            log.info(TOOK_MS, (Object)watch.getLastTaskName(), (Object)watch.getLastTaskTimeMillis());
        }
    }

    private CompletableFuture<List<Either<Exception, Shell>>> fetchShellDescriptorsForConnectorEndpoints(List<DigitalTwinRegistryKey> keys, List<String> edcUrls, String bpn) {
        List<CompletableFuture> shellsFuture = this.endpointDataForConnectorsService.createFindEndpointDataForConnectorsFutures(edcUrls, bpn).stream().map(edrFuture -> edrFuture.thenCompose(edr -> CompletableFuture.supplyAsync(() -> this.fetchShellDescriptorsForKey(keys, (EndpointDataReference)edr)))).toList();
        log.debug("Created {} futures", (Object)shellsFuture.size());
        return this.resultFinder.getFastestResult(shellsFuture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Either<Exception, Shell>> fetchShellDescriptorsForKey(List<DigitalTwinRegistryKey> keys, EndpointDataReference endpointDataReference) {
        StopWatch watch = new StopWatch();
        String msg = "Fetching shell descriptors for keys %s from endpoint '%s'".formatted(keys, endpointDataReference.getEndpoint());
        watch.start(msg);
        log.info(msg);
        try {
            List<Either<Exception, Shell>> list = keys.stream().map(key -> Either.right((Object)new Shell(endpointDataReference.getContractId(), this.fetchShellDescriptor(endpointDataReference, (DigitalTwinRegistryKey)key)))).toList();
            return list;
        }
        finally {
            watch.stop();
            log.info(TOOK_MS, (Object)watch.getLastTaskName(), (Object)watch.getLastTaskTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AssetAdministrationShellDescriptor fetchShellDescriptor(EndpointDataReference endpointDataReference, DigitalTwinRegistryKey key) {
        StopWatch watch = new StopWatch();
        String msg = "Retrieving AAS identification for DigitalTwinRegistryKey: '%s'".formatted(key);
        watch.start(msg);
        log.info(msg);
        try {
            String aaShellIdentification = this.mapToShellId(endpointDataReference, key.shellId());
            AssetAdministrationShellDescriptor assetAdministrationShellDescriptor = this.decentralDigitalTwinRegistryClient.getAssetAdministrationShellDescriptor(endpointDataReference, aaShellIdentification);
            return assetAdministrationShellDescriptor;
        }
        finally {
            watch.stop();
            log.info(TOOK_MS, (Object)watch.getLastTaskName(), (Object)watch.getLastTaskTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private String mapToShellId(EndpointDataReference endpointDataReference, String providedId) {
        StopWatch watch = new StopWatch();
        String msg = "Mapping '%s' to shell ID for endpoint '%s'".formatted(providedId, endpointDataReference.getEndpoint());
        watch.start(msg);
        log.info(msg);
        try {
            IdentifierKeyValuePair identifierKeyValuePair = IdentifierKeyValuePair.builder().name("globalAssetId").value(providedId).build();
            Stream mappingResultStream = this.decentralDigitalTwinRegistryClient.getAllAssetAdministrationShellIdsByAssetLink(endpointDataReference, identifierKeyValuePair).getResult().stream();
            Optional mappingResult = mappingResultStream.findFirst();
            String shellId = mappingResult.orElse(providedId);
            if (providedId.equals(shellId)) {
                log.info("Found shell with shellId {} in registry", (Object)shellId);
            } else {
                log.info("Retrieved shellId {} for globalAssetId {}", (Object)shellId, (Object)providedId);
            }
            String string = shellId;
            return string;
        }
        finally {
            watch.stop();
            log.info(TOOK_MS, (Object)watch.getLastTaskName(), (Object)watch.getLastTaskTimeMillis());
        }
    }

    private Collection<String> lookupShellIds(String bpn) throws RegistryServiceException {
        log.info("Looking up shell ids for bpn {}", (Object)bpn);
        try {
            List<String> edcUrls = this.connectorEndpointsService.fetchConnectorEndpoints(bpn);
            log.info("Looking up shell ids for bpn '{}' with connector endpoints {}", (Object)bpn, edcUrls);
            List<CompletableFuture<EndpointDataReference>> endpointDataReferenceFutures = this.endpointDataForConnectorsService.createFindEndpointDataForConnectorsFutures(edcUrls, bpn);
            return this.lookupShellIds(bpn, endpointDataReferenceFutures);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RegistryServiceException("%s occurred while looking up shell ids for bpn '%s'".formatted(e.getClass().getSimpleName(), bpn), e);
        }
    }

    @NotNull
    private Collection<String> lookupShellIds(String bpn, List<CompletableFuture<EndpointDataReference>> endpointDataReferenceFutures) throws RegistryServiceException {
        try {
            List<CompletableFuture> futures = endpointDataReferenceFutures.stream().map(edrFuture -> edrFuture.thenCompose(edr -> CompletableFuture.supplyAsync(() -> this.lookupShellIds(bpn, (EndpointDataReference)edr)))).toList();
            Collection shellIds = (Collection)this.resultFinder.getFastestResult(futures).get(this.config.getAsyncTimeoutMillis(), TimeUnit.MILLISECONDS);
            log.info("Found {} shell id(s) in total", (Object)shellIds.size());
            return shellIds;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RegistryServiceException("%s occurred while looking up shell ids for bpn '%s'".formatted(e.getClass().getSimpleName(), bpn), e);
        }
        catch (ExecutionException e) {
            throw new RegistryServiceException("%s occurred while looking up shell ids for bpn '%s'".formatted(e.getClass().getSimpleName(), bpn), e);
        }
        catch (TimeoutException e) {
            throw new RegistryServiceException("Timeout during shell ID lookup for bpn '%s'".formatted(bpn), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> lookupShellIds(String bpn, EndpointDataReference endpointDataReference) {
        StopWatch watch = new StopWatch();
        String msg = "Looking up shell IDs for bpn '%s' with endpointDataReference '%s'".formatted(bpn, endpointDataReference);
        watch.start(msg);
        log.info(msg);
        try {
            List<String> list = this.decentralDigitalTwinRegistryClient.getAllAssetAdministrationShellIdsByAssetLink(endpointDataReference, IdentifierKeyValuePair.builder().name("manufacturerId").value(bpn).build()).getResult();
            return list;
        }
        finally {
            watch.stop();
            log.info(TOOK_MS, (Object)watch.getLastTaskName(), (Object)watch.getLastTaskTimeMillis());
        }
    }

    @Override
    public Collection<DigitalTwinRegistryKey> lookupShellIdentifiers(String bpn) throws RegistryServiceException {
        return this.lookupShellIds(bpn).stream().map(id -> new DigitalTwinRegistryKey((String)id, bpn)).toList();
    }

    @Generated
    public DecentralDigitalTwinRegistryService(ConnectorEndpointsService connectorEndpointsService, EndpointDataForConnectorsService endpointDataForConnectorsService, DecentralDigitalTwinRegistryClient decentralDigitalTwinRegistryClient, EdcConfiguration config) {
        this.connectorEndpointsService = connectorEndpointsService;
        this.endpointDataForConnectorsService = endpointDataForConnectorsService;
        this.decentralDigitalTwinRegistryClient = decentralDigitalTwinRegistryClient;
        this.config = config;
    }
}

