/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.registryclient.discovery;

import io.github.resilience4j.retry.annotation.Retry;
import java.util.List;
import lombok.Generated;
import org.eclipse.tractusx.irs.registryclient.discovery.DiscoveryFinderClient;
import org.eclipse.tractusx.irs.registryclient.discovery.DiscoveryFinderRequest;
import org.eclipse.tractusx.irs.registryclient.discovery.DiscoveryResponse;
import org.eclipse.tractusx.irs.registryclient.discovery.EdcDiscoveryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.client.RestTemplate;

public class DiscoveryFinderClientImpl
implements DiscoveryFinderClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiscoveryFinderClientImpl.class);
    public static final String DISCOVERY_ENDPOINTS_CACHE = "discovery_endpoints_cache";
    private final String discoveryFinderUrl;
    private final RestTemplate restTemplate;

    public DiscoveryFinderClientImpl(String discoveryFinderUrl, RestTemplate restTemplate) {
        this.discoveryFinderUrl = discoveryFinderUrl;
        this.restTemplate = restTemplate;
    }

    @Override
    @Retry(name="registry")
    @Cacheable(value={"discovery_endpoints_cache"})
    public DiscoveryResponse findDiscoveryEndpoints(DiscoveryFinderRequest request) {
        return (DiscoveryResponse)this.restTemplate.postForObject(this.discoveryFinderUrl, (Object)request, DiscoveryResponse.class, new Object[0]);
    }

    @CacheEvict(value={"discovery_endpoints_cache"}, allEntries=true)
    @Scheduled(fixedRateString="${irs-edc-client.discoveryFinderClient.cacheTTL}")
    public void evictDiscoveryEndpointsCacheValues() {
        log.debug("Clearing \"{}\" cache.", (Object)DISCOVERY_ENDPOINTS_CACHE);
    }

    @Override
    @Retry(name="registry")
    public List<EdcDiscoveryResult> findConnectorEndpoints(String endpointAddress, List<String> bpns) {
        return DiscoveryFinderClientImpl.toList((EdcDiscoveryResult[])this.restTemplate.postForObject(endpointAddress, bpns, EdcDiscoveryResult[].class, new Object[0]));
    }

    private static <T> List<T> toList(T ... arr) {
        return arr == null ? List.of() : List.of(arr);
    }
}

