/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.registryclient;

import io.github.resilience4j.retry.RetryRegistry;
import java.time.Clock;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.tractusx.irs.edc.client.EdcConfiguration;
import org.eclipse.tractusx.irs.edc.client.EdcDataPlaneClient;
import org.eclipse.tractusx.irs.edc.client.EdcOrchestrator;
import org.eclipse.tractusx.irs.edc.client.EdcSubmodelClient;
import org.eclipse.tractusx.irs.edc.client.EdcSubmodelClientImpl;
import org.eclipse.tractusx.irs.edc.client.EdcSubmodelFacade;
import org.eclipse.tractusx.irs.edc.client.exceptions.EdcClientException;
import org.eclipse.tractusx.irs.registryclient.central.CentralDigitalTwinRegistryService;
import org.eclipse.tractusx.irs.registryclient.central.DigitalTwinRegistryClient;
import org.eclipse.tractusx.irs.registryclient.central.DigitalTwinRegistryClientImpl;
import org.eclipse.tractusx.irs.registryclient.decentral.DecentralDigitalTwinRegistryClient;
import org.eclipse.tractusx.irs.registryclient.decentral.DecentralDigitalTwinRegistryService;
import org.eclipse.tractusx.irs.registryclient.decentral.EdcEndpointReferenceRetriever;
import org.eclipse.tractusx.irs.registryclient.decentral.EdcRetrieverException;
import org.eclipse.tractusx.irs.registryclient.decentral.EndpointDataForConnectorsService;
import org.eclipse.tractusx.irs.registryclient.discovery.ConnectorEndpointsService;
import org.eclipse.tractusx.irs.registryclient.discovery.DiscoveryFinderClient;
import org.eclipse.tractusx.irs.registryclient.discovery.DiscoveryFinderClientImpl;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
public class DefaultConfiguration {
    public static final String DIGITAL_TWIN_REGISTRY_REST_TEMPLATE = "digitalTwinRegistryRestTemplate";
    public static final String EDC_REST_TEMPLATE = "edcRestTemplate";
    private static final String CONFIG_PREFIX = "digitalTwinRegistryClient";
    private static final String CONFIG_FIELD_TYPE = "type";
    private static final String CONFIG_VALUE_DECENTRAL = "decentral";
    private static final String CONFIG_VALUE_CENTRAL = "central";
    private static final int POOL_SIZE = 20;

    @Bean
    @ConditionalOnProperty(prefix="digitalTwinRegistryClient", name={"type"}, havingValue="central")
    public CentralDigitalTwinRegistryService centralDigitalTwinRegistryService(DigitalTwinRegistryClient client) {
        return new CentralDigitalTwinRegistryService(client);
    }

    @Bean
    @ConditionalOnProperty(prefix="digitalTwinRegistryClient", name={"type"}, havingValue="central")
    public DigitalTwinRegistryClient digitalTwinRegistryClientImpl(@Qualifier(value="digitalTwinRegistryRestTemplate") RestTemplate restTemplate, @Value(value="${digitalTwinRegistryClient.descriptorEndpoint:}") String descriptorEndpoint, @Value(value="${digitalTwinRegistryClient.shellLookupEndpoint:}") String shellLookupEndpoint) {
        return new DigitalTwinRegistryClientImpl(restTemplate, descriptorEndpoint, shellLookupEndpoint);
    }

    @Bean
    @ConditionalOnProperty(prefix="digitalTwinRegistryClient", name={"type"}, havingValue="decentral")
    public DecentralDigitalTwinRegistryService decentralDigitalTwinRegistryService(ConnectorEndpointsService connectorEndpointsService, EndpointDataForConnectorsService endpointDataForConnectorsService, DecentralDigitalTwinRegistryClient decentralDigitalTwinRegistryClient, EdcConfiguration edcConfiguration) {
        return new DecentralDigitalTwinRegistryService(connectorEndpointsService, endpointDataForConnectorsService, decentralDigitalTwinRegistryClient, edcConfiguration);
    }

    @Bean
    @ConditionalOnProperty(prefix="digitalTwinRegistryClient", name={"type"}, havingValue="decentral")
    public DiscoveryFinderClient discoveryFinderClient(@Qualifier(value="digitalTwinRegistryRestTemplate") RestTemplate dtrRestTemplate, @Value(value="${digitalTwinRegistryClient.discoveryFinderUrl:}") String finderUrl) {
        return new DiscoveryFinderClientImpl(finderUrl, dtrRestTemplate);
    }

    @Bean
    @ConditionalOnProperty(prefix="digitalTwinRegistryClient", name={"type"}, havingValue="decentral")
    public ConnectorEndpointsService connectorEndpointsService(DiscoveryFinderClient discoveryFinderClient, @Value(value="${digitalTwinRegistryClient.discovery.type:}") String discoveryType) {
        return new ConnectorEndpointsService(discoveryFinderClient, discoveryType);
    }

    @Bean
    @ConditionalOnProperty(prefix="digitalTwinRegistryClient", name={"type"}, havingValue="decentral")
    public EndpointDataForConnectorsService endpointDataForConnectorsService(EdcSubmodelFacade facade) {
        EdcEndpointReferenceRetriever edcEndpointReferenceRetriever = (edcConnectorEndpoint, bpn) -> {
            try {
                return facade.getEndpointReferencesForRegistryAsset(edcConnectorEndpoint, bpn);
            }
            catch (EdcClientException e) {
                throw new EdcRetrieverException.Builder(e).withEdcUrl(edcConnectorEndpoint).withBpn(bpn).build();
            }
        };
        return new EndpointDataForConnectorsService(edcEndpointReferenceRetriever);
    }

    @Bean
    public EdcSubmodelFacade edcSubmodelFacade(EdcSubmodelClient client, EdcConfiguration config) {
        return new EdcSubmodelFacade(client, config);
    }

    @Bean
    @ConditionalOnProperty(prefix="digitalTwinRegistryClient", name={"type"}, havingValue="decentral")
    public EdcSubmodelClient edcSubmodelClient(EdcConfiguration edcConfiguration, EdcDataPlaneClient edcDataPlaneClient, EdcOrchestrator edcOrchestrator, RetryRegistry retryRegistry) {
        return new EdcSubmodelClientImpl(edcConfiguration, edcDataPlaneClient, edcOrchestrator, retryRegistry);
    }

    @Bean
    @ConditionalOnProperty(prefix="digitalTwinRegistryClient", name={"type"}, havingValue="decentral")
    public DecentralDigitalTwinRegistryClient decentralDigitalTwinRegistryClient(@Qualifier(value="edcRestTemplate") RestTemplate edcRestTemplate, @Value(value="${digitalTwinRegistryClient.shellDescriptorTemplate:}") String shellDescriptorTemplate, @Value(value="${digitalTwinRegistryClient.lookupShellsTemplate:}") String lookupShellsTemplate) {
        return new DecentralDigitalTwinRegistryClient(edcRestTemplate, shellDescriptorTemplate, lookupShellsTemplate);
    }

    @Bean
    @ConditionalOnMissingBean(value={Clock.class})
    public Clock clock() {
        return Clock.systemUTC();
    }

    @Bean
    @ConditionalOnMissingBean(value={ScheduledExecutorService.class})
    public ScheduledExecutorService scheduledExecutorService() {
        return Executors.newScheduledThreadPool(20);
    }

    @Bean
    @ConditionalOnMissingBean(value={ExecutorService.class})
    public ExecutorService fixedThreadPoolExecutorService(@Value(value="${irs-edc-client.controlplane.orchestration.thread-pool-size}") int threadPoolSize) {
        return Executors.newFixedThreadPool(threadPoolSize);
    }
}

