/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.registryclient.central;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.tractusx.irs.component.assetadministrationshell.AssetAdministrationShellDescriptor;
import org.eclipse.tractusx.irs.component.assetadministrationshell.Endpoint;
import org.eclipse.tractusx.irs.component.assetadministrationshell.IdentifierKeyValuePair;
import org.eclipse.tractusx.irs.component.assetadministrationshell.LangString;
import org.eclipse.tractusx.irs.component.assetadministrationshell.ProtocolInformation;
import org.eclipse.tractusx.irs.component.assetadministrationshell.Reference;
import org.eclipse.tractusx.irs.component.assetadministrationshell.SemanticId;
import org.eclipse.tractusx.irs.component.assetadministrationshell.SubmodelDescriptor;
import org.eclipse.tractusx.irs.data.CxTestDataContainer;
import org.springframework.web.client.RestClientException;

class AssetAdministrationShellTestdataCreator {
    private final CxTestDataContainer cxTestDataContainer;

    AssetAdministrationShellTestdataCreator(CxTestDataContainer cxTestDataContainer) {
        this.cxTestDataContainer = cxTestDataContainer;
    }

    public AssetAdministrationShellDescriptor createDummyAssetAdministrationShellDescriptorForId(String catenaXId) {
        Optional cxTestData = this.cxTestDataContainer.getByCatenaXId(catenaXId);
        if (cxTestData.isEmpty()) {
            throw new RestClientException("Dummy Exception");
        }
        ArrayList submodelDescriptors = new ArrayList();
        ((CxTestDataContainer.CxTestData)cxTestData.get()).getSingleLevelBomAsBuilt().ifPresent(submodel -> submodelDescriptors.add(this.createSingleLevelBomAsBuiltSubmodelDescriptor(catenaXId)));
        ((CxTestDataContainer.CxTestData)cxTestData.get()).getSerialPart().ifPresent(submodel -> submodelDescriptors.add(this.createSerialPartSubmodelDescriptor(catenaXId)));
        ((CxTestDataContainer.CxTestData)cxTestData.get()).getSingleLevelUsageAsBuilt().ifPresent(submodel -> submodelDescriptors.add(this.createSingleLevelUsageAsBuiltSubmodelDescriptor(catenaXId)));
        ((CxTestDataContainer.CxTestData)cxTestData.get()).getSingleLevelBomAsSpecified().ifPresent(submodel -> submodelDescriptors.add(this.createSingleLevelBomAsSpecifiedSubmodelDescriptor(catenaXId)));
        ((CxTestDataContainer.CxTestData)cxTestData.get()).getSingleLevelBomAsPlanned().ifPresent(submodel -> submodelDescriptors.add(this.createSingleLevelBomAsPlannedSubmodelDescriptor(catenaXId)));
        ((CxTestDataContainer.CxTestData)cxTestData.get()).getSingleLevelUsageAsPlanned().ifPresent(submodel -> submodelDescriptors.add(this.createSingleLevelUsageAsPlannedSubmodelDescriptor(catenaXId)));
        ((CxTestDataContainer.CxTestData)cxTestData.get()).getPartAsPlanned().ifPresent(submodel -> submodelDescriptors.add(this.createPartAsPlannedSubmodelDescriptor(catenaXId)));
        ((CxTestDataContainer.CxTestData)cxTestData.get()).getBatch().ifPresent(submodel -> submodelDescriptors.add(this.createBatchSubmodelDescriptor(catenaXId)));
        ((CxTestDataContainer.CxTestData)cxTestData.get()).getMaterialForRecycling().ifPresent(submodel -> submodelDescriptors.add(this.createMaterialForRecyclingSubmodelDescriptor(catenaXId)));
        ((CxTestDataContainer.CxTestData)cxTestData.get()).getProductDescription().ifPresent(submodel -> submodelDescriptors.add(this.createProductDescriptionSubmodelDescriptor(catenaXId)));
        ((CxTestDataContainer.CxTestData)cxTestData.get()).getPhysicalDimension().ifPresent(submodel -> submodelDescriptors.add(this.createPhysicalDimensionSubmodelDescriptor(catenaXId)));
        ((CxTestDataContainer.CxTestData)cxTestData.get()).getPartAsSpecified().ifPresent(submodel -> submodelDescriptors.add(this.createPartAsSpecifiedSubmodelDescriptor(catenaXId)));
        return AssetAdministrationShellDescriptor.builder().description(List.of(LangString.builder().build())).globalAssetId(catenaXId).idShort("idShort").id(catenaXId).specificAssetIds(List.of(IdentifierKeyValuePair.builder().name("ManufacturerId").value("BPNL00000003AYRE").build())).submodelDescriptors(submodelDescriptors).build();
    }

    private SubmodelDescriptor createSingleLevelBomAsBuiltSubmodelDescriptor(String catenaXId) {
        return this.createSubmodelDescriptor(catenaXId, "urn:samm:io.catenax.single_level_bom_as_built:3.0.0#SingleLevelBomAsBuilt", "singleLevelBomAsBuilt");
    }

    private SubmodelDescriptor createSingleLevelUsageAsPlannedSubmodelDescriptor(String catenaXId) {
        return this.createSubmodelDescriptor(catenaXId, "urn:samm:io.catenax.single_level_usage_as_planned:2.0.0#SingleLevelUsageAsPlanned", "singleLevelUsageAsPlanned");
    }

    private SubmodelDescriptor createSingleLevelUsageAsBuiltSubmodelDescriptor(String catenaXId) {
        return this.createSubmodelDescriptor(catenaXId, "urn:samm:io.catenax.single_level_usage_as_built:3.0.0#SingleLevelUsageAsBuilt", "singleLevelUsageAsBuilt");
    }

    private SubmodelDescriptor createSingleLevelBomAsSpecifiedSubmodelDescriptor(String catenaXId) {
        return this.createSubmodelDescriptor(catenaXId, "urn:samm:io.catenax.single_level_bom_as_specified:2.0.0#SingleLevelBomAsSpecified", "singleLevelBomAsSpecified");
    }

    private SubmodelDescriptor createSerialPartSubmodelDescriptor(String catenaXId) {
        return this.createSubmodelDescriptor(catenaXId, "urn:samm:io.catenax.serial_part:3.0.0#SerialPart", "serialPart");
    }

    private SubmodelDescriptor createSingleLevelBomAsPlannedSubmodelDescriptor(String catenaXId) {
        return this.createSubmodelDescriptor(catenaXId, "urn:samm:io.catenax.single_level_bom_as_planned:3.0.0#SingleLevelBomAsPlanned", "singleLevelBomAsPlanned");
    }

    private SubmodelDescriptor createPartAsPlannedSubmodelDescriptor(String catenaXId) {
        return this.createSubmodelDescriptor(catenaXId, "urn:samm:io.catenax.part_as_planned:1.0.1#PartAsPlanned", "partAsPlanned");
    }

    private SubmodelDescriptor createBatchSubmodelDescriptor(String catenaXId) {
        return this.createSubmodelDescriptor(catenaXId, "urn:samm:io.catenax.batch:3.0.0#Batch", "batch");
    }

    private SubmodelDescriptor createMaterialForRecyclingSubmodelDescriptor(String catenaXId) {
        return this.createSubmodelDescriptor(catenaXId, "urn:samm:io.catenax.material_for_recycling:1.1.0#MaterialForRecycling", "materialForRecycling");
    }

    private SubmodelDescriptor createProductDescriptionSubmodelDescriptor(String catenaXId) {
        return this.createSubmodelDescriptor(catenaXId, "urn:samm:io.catenax.battery.product_description:1.0.1#ProductDescription", "productDescription");
    }

    private SubmodelDescriptor createPhysicalDimensionSubmodelDescriptor(String catenaXId) {
        return this.createSubmodelDescriptor(catenaXId, "urn:samm:io.catenax.physical_dimension:1.0.0#PhysicalDimension", "physicalDimension");
    }

    private SubmodelDescriptor createPartAsSpecifiedSubmodelDescriptor(String catenaXId) {
        return this.createSubmodelDescriptor(catenaXId, "urn:samm:io.catenax.part_as_specified:2.0.0#PartAsSpecified", "partAsSpecified");
    }

    private SubmodelDescriptor createSubmodelDescriptor(String catenaXId, String submodelUrn, String submodelName) {
        ProtocolInformation protocolInformation = ProtocolInformation.builder().href(submodelName).endpointProtocol("AAS/SUBMODEL").endpointProtocolVersion(List.of("1.0RC02")).subprotocolBody("id=" + catenaXId + ";dspEndpoint=http://edc.control.plane/").build();
        Endpoint endpoint = Endpoint.builder().interfaceInformation("https://TEST.connector").protocolInformation(protocolInformation).build();
        Reference reference = Reference.builder().keys(List.of(SemanticId.builder().value(submodelUrn).build())).build();
        return SubmodelDescriptor.builder().id(catenaXId).idShort(submodelName).endpoints(List.of(endpoint)).semanticId(reference).build();
    }
}

