/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.registryclient.central;

import io.github.resilience4j.core.functions.Either;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.tractusx.irs.component.PartChainIdentificationKey;
import org.eclipse.tractusx.irs.component.Shell;
import org.eclipse.tractusx.irs.component.assetadministrationshell.IdentifierKeyValuePair;
import org.eclipse.tractusx.irs.registryclient.DigitalTwinRegistryKey;
import org.eclipse.tractusx.irs.registryclient.DigitalTwinRegistryService;
import org.eclipse.tractusx.irs.registryclient.central.DigitalTwinRegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CentralDigitalTwinRegistryService
implements DigitalTwinRegistryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CentralDigitalTwinRegistryService.class);
    private final DigitalTwinRegistryClient digitalTwinRegistryClient;

    @Override
    public Collection<Either<Exception, Shell>> fetchShells(Collection<DigitalTwinRegistryKey> keys) {
        return keys.stream().map(key -> {
            String aaShellIdentification = this.getAAShellIdentificationOrGlobalAssetId(key.shellId());
            log.info("Retrieved AAS Identification {} for globalAssetId {}", (Object)aaShellIdentification, (Object)key.shellId());
            return Either.right((Object)this.fetchShell(aaShellIdentification));
        }).toList();
    }

    @Override
    public Optional<Shell> fetchShell(PartChainIdentificationKey key) {
        if (!StringUtils.isBlank((CharSequence)key.getIdentifier())) {
            return Optional.of(this.fetchShell(key.getIdentifier()));
        }
        return this.fetchShells(List.of(new DigitalTwinRegistryKey(key.getGlobalAssetId(), key.getBpn()))).stream().map(Either::getOrNull).filter(Objects::nonNull).findFirst();
    }

    private Shell fetchShell(String aaShellIdentification) {
        return new Shell("", this.digitalTwinRegistryClient.getAssetAdministrationShellDescriptor(aaShellIdentification));
    }

    @Override
    public Collection<DigitalTwinRegistryKey> lookupShellIdentifiers(String bpn) {
        log.info("Looking up shells for bpn {}", (Object)bpn);
        List<String> shellIds = this.digitalTwinRegistryClient.getAllAssetAdministrationShellIdsByAssetLink(List.of()).getResult();
        log.info("Found {} shells in total", (Object)shellIds.size());
        return shellIds.stream().map(id -> new DigitalTwinRegistryKey((String)id, bpn)).toList();
    }

    private String getAAShellIdentificationOrGlobalAssetId(String globalAssetId) {
        IdentifierKeyValuePair identifierKeyValuePair = IdentifierKeyValuePair.builder().name("globalAssetId").value(globalAssetId).build();
        List<String> allAssetAdministrationShellIdsByAssetLink = this.digitalTwinRegistryClient.getAllAssetAdministrationShellIdsByAssetLink(Collections.singletonList(identifierKeyValuePair)).getResult();
        return allAssetAdministrationShellIdsByAssetLink.stream().findFirst().orElse(globalAssetId);
    }

    @Generated
    public CentralDigitalTwinRegistryService(DigitalTwinRegistryClient digitalTwinRegistryClient) {
        this.digitalTwinRegistryClient = digitalTwinRegistryClient;
    }
}

